/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FloatValue implements Enumerator
{
    UNSPECIFIED_LITERAL(0, "unspecified", "unspecified"),
    IEEE_EXTENDED_INTEL_LITERAL(1, "ieeeExtendedIntel", "ieeeExtendedIntel"),
    IEEE_EXTENDED_AIX_LITERAL(2, "ieeeExtendedAIX", "ieeeExtendedAIX"),
    IEEE_EXTENDED_OS390_LITERAL(3, "ieeeExtendedOS390", "ieeeExtendedOS390"),
    IEEE_EXTENDED_AS400_LITERAL(4, "ieeeExtendedAS400", "ieeeExtendedAS400"),
    IEEE_NON_EXTENDED_LITERAL(5, "ieeeNonExtended", "ieeeNonExtended"),
    IBM390_HEX_LITERAL(6, "ibm390Hex", "ibm390Hex"),
    IBM400_HEX_LITERAL(7, "ibm400Hex", "ibm400Hex"),
    IEEE_DFP_IBM_LITERAL(8, "ieeeDfpIBM", "ieeeDfpIBM");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int UNSPECIFIED = 0;
    public static final int IEEE_EXTENDED_INTEL = 1;
    public static final int IEEE_EXTENDED_AIX = 2;
    public static final int IEEE_EXTENDED_OS390 = 3;
    public static final int IEEE_EXTENDED_AS400 = 4;
    public static final int IEEE_NON_EXTENDED = 5;
    public static final int IBM390_HEX = 6;
    public static final int IBM400_HEX = 7;
    public static final int IEEE_DFP_IBM = 8;
    private static final FloatValue[] VALUES_ARRAY;
    public static final List<FloatValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FloatValue[]{UNSPECIFIED_LITERAL, IEEE_EXTENDED_INTEL_LITERAL, IEEE_EXTENDED_AIX_LITERAL, IEEE_EXTENDED_OS390_LITERAL, IEEE_EXTENDED_AS400_LITERAL, IEEE_NON_EXTENDED_LITERAL, IBM390_HEX_LITERAL, IBM400_HEX_LITERAL, IEEE_DFP_IBM_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FloatValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FloatValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FloatValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FloatValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FloatValue get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED_LITERAL;
            }
            case 1: {
                return IEEE_EXTENDED_INTEL_LITERAL;
            }
            case 2: {
                return IEEE_EXTENDED_AIX_LITERAL;
            }
            case 3: {
                return IEEE_EXTENDED_OS390_LITERAL;
            }
            case 4: {
                return IEEE_EXTENDED_AS400_LITERAL;
            }
            case 5: {
                return IEEE_NON_EXTENDED_LITERAL;
            }
            case 6: {
                return IBM390_HEX_LITERAL;
            }
            case 7: {
                return IBM400_HEX_LITERAL;
            }
            case 8: {
                return IEEE_DFP_IBM_LITERAL;
            }
        }
        return null;
    }

    private FloatValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

