/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Encoding implements Enumerator
{
    EBCDIC_LITERAL(0, "ebcdic", "ebcdic"),
    ASCII_LITERAL(1, "ascii", "ascii"),
    PACKED390_LITERAL(2, "packed390", "packed390");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int EBCDIC = 0;
    public static final int ASCII = 1;
    public static final int PACKED390 = 2;
    private static final Encoding[] VALUES_ARRAY;
    public static final List<Encoding> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Encoding[]{EBCDIC_LITERAL, ASCII_LITERAL, PACKED390_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Encoding get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Encoding result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Encoding getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Encoding result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Encoding get(int value) {
        switch (value) {
            case 0: {
                return EBCDIC_LITERAL;
            }
            case 1: {
                return ASCII_LITERAL;
            }
            case 2: {
                return PACKED390_LITERAL;
            }
        }
        return null;
    }

    private Encoding(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

