/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AddrUnitValue implements Enumerator
{
    BIT_LITERAL(0, "bit", "bit"),
    BYTE_LITERAL(1, "byte", "byte"),
    WORD_LITERAL(2, "word", "word"),
    DOUBLE_WORD_LITERAL(3, "doubleWord", "doubleWord"),
    HALF_WORD_LITERAL(4, "halfWord", "halfWord"),
    QUAD_WORD_LITERAL(5, "quadWord", "quadWord");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int BIT = 0;
    public static final int BYTE = 1;
    public static final int WORD = 2;
    public static final int DOUBLE_WORD = 3;
    public static final int HALF_WORD = 4;
    public static final int QUAD_WORD = 5;
    private static final AddrUnitValue[] VALUES_ARRAY;
    public static final List<AddrUnitValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AddrUnitValue[]{BIT_LITERAL, BYTE_LITERAL, WORD_LITERAL, DOUBLE_WORD_LITERAL, HALF_WORD_LITERAL, QUAD_WORD_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AddrUnitValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AddrUnitValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AddrUnitValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AddrUnitValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AddrUnitValue get(int value) {
        switch (value) {
            case 0: {
                return BIT_LITERAL;
            }
            case 1: {
                return BYTE_LITERAL;
            }
            case 2: {
                return WORD_LITERAL;
            }
            case 3: {
                return DOUBLE_WORD_LITERAL;
            }
            case 4: {
                return HALF_WORD_LITERAL;
            }
            case 5: {
                return QUAD_WORD_LITERAL;
            }
        }
        return null;
    }

    private AddrUnitValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

