/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.wizards;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceBuilder;
import com.ibm.zosconnect.ui.service.wizards.NewServiceProjectPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewServiceProjectWizard
extends BasicNewProjectResourceWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private NewServiceProjectPage page1;

    public NewServiceProjectWizard() {
        this.setWindowTitle(Xlat.label((String)"SERVICEEDIT_LABEL_PROGRAMNAME"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new NewServiceProjectPage();
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ServiceProjectController serviceProjectController = ServiceProjectController.createNewServiceProject((String)NewServiceProjectWizard.this.page1.getServiceName(), (IProgressMonitor)monitor);
                        ServiceModelController serviceModel = serviceProjectController.getServiceModel();
                        serviceModel.setAllServiceProperties(NewServiceProjectWizard.this.page1.getServiceName(), NewServiceProjectWizard.this.page1.getServiceDescription(), NewServiceProjectWizard.this.page1.getServiceType());
                        ServiceExtension serviceExtension = serviceProjectController.getServiceModel().getServiceExtension();
                        IProject serviceProject = serviceProjectController.getProject();
                        for (String projectNatureId : serviceExtension.getProjectNatureIds()) {
                            NewServiceProjectWizard.appendNature(serviceProject, projectNatureId);
                        }
                        IFile servicePropertiesFile = serviceProjectController.getServicePropertiesFile(monitor);
                        try {
                            IServiceBuilder builderImpl = serviceExtension.getBuilderClass();
                            if (builderImpl != null) {
                                for (String name : builderImpl.getNewProjectFolderNames()) {
                                    serviceProjectController.createFolderInProject(name, monitor);
                                }
                            } else {
                                ZCeeUILogger.info((String)"Builder class provided by extension is null or not an instance of IServiceBuilder", (Object[])new Object[0]);
                            }
                        }
                        catch (CoreException ce) {
                            ZCeeUILogger.error((Throwable)ce);
                            ZCeeErrorDialog.openError((Exception)((Object)ce));
                        }
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
                        IEditorDescriptor editorDescriptor = editorRegistry.findEditor("com.ibm.zosconnect.ui.service.serviceprojecteditor");
                        if (editorDescriptor == null) {
                            editorDescriptor = editorRegistry.getDefaultEditor(servicePropertiesFile.getName());
                        }
                        IWorkbenchPage workbenchPage = workbench.getActiveWorkbenchWindow().getActivePage();
                        workbenchPage.openEditor((IEditorInput)new FileEditorInput(servicePropertiesFile), editorDescriptor.getId());
                        IViewPart view = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                        if (view == null) {
                            view = workbenchPage.showView("org.eclipse.ui.navigator.ProjectExplorer");
                        }
                        ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)servicePropertiesFile));
                        serviceProject.open(monitor);
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
                        ZCeeErrorDialog.openError((Exception)e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        return true;
    }

    public static void appendNature(IProject project, String id) throws Exception {
        IProjectDescription description = project.getDescription();
        if (description.hasNature(id)) {
            return;
        }
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = id;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }
}

