/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.wizards;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectInvalidInputException;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.PosixPortableValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewServiceProjectPage
extends WizardPage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text txtServiceProjectName;
    private String strServiceType;
    private Text txtServiceDescription;
    private final List<IConfigurationElement> serviceTypeElements;

    public NewServiceProjectPage() {
        super("NewServiceProjectPage");
        this.setTitle(Xlat.label((String)"NEWSERVICE_WIZARD_TITLE"));
        this.setDescription(Xlat.description((String)"NEWSERVICE_WIZARD_DESC"));
        IConfigurationElement[] unorderedServiceTypeElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.zosconnect.ui.servicetype");
        this.serviceTypeElements = Arrays.asList(unorderedServiceTypeElements);
        Collections.sort(this.serviceTypeElements, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String o1Label = o1.getAttribute("label");
                String o2Label = o2.getAttribute("label");
                if (o1Label == null && o2Label != null) {
                    return 1;
                }
                if (o1Label != null && o2Label == null) {
                    return -1;
                }
                if (o1Label == null && o2Label == null) {
                    return 0;
                }
                return o1Label.compareTo(o2Label);
            }
        });
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(1, false);
        container.setLayout((Layout)gl_container);
        Composite compServiceProperties = new Composite(container, 0);
        compServiceProperties.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compServiceProperties = new GridLayout(1, false);
        compServiceProperties.setLayout((Layout)gl_compServiceProperties);
        Label lblServiceProjectName = new Label(compServiceProperties, 0);
        GridData gd_lblServiceProjectName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblServiceProjectName.verticalIndent = 5;
        lblServiceProjectName.setLayoutData((Object)gd_lblServiceProjectName);
        lblServiceProjectName.setText(Xlat.label((String)"NEWSERVICE_LABEL_PROJECT_NAME") + Xlat.colon());
        this.txtServiceProjectName = new Text(compServiceProperties, 2048);
        GridData gd_txtServiceProjectName = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtServiceProjectName.widthHint = 425;
        this.txtServiceProjectName.setLayoutData((Object)gd_txtServiceProjectName);
        this.txtServiceProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewServiceProjectPage.this.validatePage();
            }
        });
        this.txtServiceProjectName.setFocus();
        Label lblServiceType = new Label(compServiceProperties, 0);
        GridData gd_lblServiceType = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblServiceType.verticalIndent = 5;
        lblServiceType.setLayoutData((Object)gd_lblServiceType);
        lblServiceType.setText(Xlat.label((String)"NEWSERVICE_LABEL_PROJECT_TYPE") + Xlat.colon());
        final Combo comboServiceType = new Combo(compServiceProperties, 2060);
        for (IConfigurationElement serviceTypeElement : this.serviceTypeElements) {
            if (!serviceTypeElement.getName().equals("service")) continue;
            comboServiceType.add(serviceTypeElement.getAttribute("label"));
        }
        if (comboServiceType.getItemCount() == 0) {
            this.setPageComplete(false);
        }
        comboServiceType.select(0);
        XSwt.addTabTraverseListener((Control)comboServiceType);
        comboServiceType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewServiceProjectPage.this.validatePage();
            }
        });
        comboServiceType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                for (IConfigurationElement serviceTypeElement : NewServiceProjectPage.this.serviceTypeElements) {
                    if (!serviceTypeElement.getName().equals("service") || !serviceTypeElement.getAttribute("label").equals(comboServiceType.getText())) continue;
                    NewServiceProjectPage.this.strServiceType = serviceTypeElement.getAttribute("serviceType");
                    break;
                }
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        comboServiceType.notifyListeners(13, new Event());
        Label lblServiceDescription = new Label(container, 0);
        GridData gd_lblServiceDescription = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblServiceDescription.verticalIndent = 5;
        lblServiceDescription.setLayoutData((Object)gd_lblServiceDescription);
        lblServiceDescription.setText(Xlat.label((String)"SERVICEEDIT_LABEL_DESCRIPTION") + Xlat.colon());
        this.txtServiceDescription = new Text(container, 2626);
        GridData gd_txtServiceDescription = new GridData(4, 4, true, true, 1, 1);
        gd_txtServiceDescription.widthHint = 425;
        gd_txtServiceDescription.heightHint = 125;
        this.txtServiceDescription.setLayoutData((Object)gd_txtServiceDescription);
        XSwt.addTabTraverseListener((Control)this.txtServiceDescription);
        this.txtServiceDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewServiceProjectPage.this.validatePage();
            }
        });
        this.validatePage();
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.ibm.zosconnect.ui.service.createservice");
    }

    private void validatePage() {
        try {
            this.validateServiceName(this.txtServiceProjectName);
            this.validateServiceType(this.strServiceType);
            this.validateServiceDescription(this.txtServiceDescription);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (ZosConnectInvalidInputException zciie) {
            this.setErrorMessage(zciie.getMessage());
            this.setPageComplete(false);
        }
    }

    private void validateServiceName(Text serviceName) throws ZosConnectInvalidInputException {
        if (serviceName != null && !serviceName.getText().isEmpty()) {
            IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(serviceName.getText(), 4);
            if (!nameStatus.isOK()) {
                throw new ZosConnectInvalidInputException(nameStatus.getMessage());
            }
            IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(serviceName.getText());
            if (handle.exists()) {
                throw new ZosConnectInvalidInputException(Xlat.error((String)"EXIST_PROJ_NAME_ERROR"));
            }
            String errMsg = PosixPortableValidator.validate((String)serviceName.getText(), (PosixPortableValidator.MessageInsertType)PosixPortableValidator.MessageInsertType.SERVICE);
            if (errMsg != null) {
                throw new ZosConnectInvalidInputException(errMsg);
            }
        } else {
            throw new ZosConnectInvalidInputException(Xlat.error((String)"EMPTY_PROJ_NAME_ERROR"));
        }
    }

    private void validateServiceType(String serviceType) {
    }

    private void validateServiceDescription(Text serviceDescription) {
    }

    public String getServiceName() {
        return XSwt.getText((Text)this.txtServiceProjectName);
    }

    public String getServiceType() {
        if (this.strServiceType != null && !this.strServiceType.isEmpty()) {
            return this.strServiceType;
        }
        return "";
    }

    public String getServiceDescription() {
        return XSwt.getText((Text)this.txtServiceDescription);
    }
}

