/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.validation;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.DataTypeCapabilitiesVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceCapabilitiesValidator;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class WVCapabilitiesValidator
implements IServiceCapabilitiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public final String className = this.getClass().getName();
    public static final String VALIDATOR_ID = "ibm.services.wvservice.";

    public ArrayList<String> getExploitedCapabilityList(IProject project) {
        String methodName = "getExploitedCapabilityList";
        ZCeeUILogger.entering((String)this.className, (String)"getExploitedCapabilityList", (Object[])new Object[]{project});
        ArrayList<String> usedCapabilities = new ArrayList<String>();
        try {
            ServiceProjectController serviceProjectController = new ServiceProjectController(project);
            ServiceModelController serviceModelController = serviceProjectController.getServiceModel();
            String requestSIName = serviceModelController.getServiceRequestSIName();
            IFile file = serviceProjectController.getFolder("service-interfaces").getFile(requestSIName);
            Message requestMsg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)file);
            boolean canUseLds = false;
            String serviceType = serviceModelController.getValue("servicetype");
            if (serviceType.equals("imsLargeDataStructure") || serviceType.equals("imsMessageSegment")) {
                canUseLds = true;
            }
            if ((serviceType.equals("cicsChannel") || serviceType.equals("cicsCommarea")) && this.usingBidi(serviceModelController)) {
                usedCapabilities.add("ibm.services.wvservice.cicsBidi");
            }
            boolean isUsingArrayCounters = false;
            boolean overrideBoolean = false;
            boolean overrideDate = false;
            boolean redefineAsChar = false;
            if (requestMsg != null) {
                DataTypeCapabilitiesVisitor requestVisitor = new DataTypeCapabilitiesVisitor();
                new MessageWalker().accept((IMessageVisitor)requestVisitor, requestMsg.getMessage());
                isUsingArrayCounters = requestVisitor.isUsingArrayCounters();
                if (isUsingArrayCounters) {
                    usedCapabilities.add("ibm.services.wvservice.arrayCounter");
                }
                if (overrideBoolean = requestVisitor.overrideBoolean()) {
                    usedCapabilities.add("ibm.services.wvservice.overrideBoolean");
                }
                if (overrideDate = requestVisitor.overrideDate()) {
                    usedCapabilities.add("ibm.services.wvservice.overrideDate");
                }
                if (redefineAsChar = requestVisitor.redefineAsChar()) {
                    usedCapabilities.add("ibm.services.wvservice.redefineAsChar");
                }
                if (canUseLds && this.ldsStartsWithLLZZTRANCODE(serviceModelController)) {
                    usedCapabilities.add("ibm.services.wvservice.inImsLdsStartsWithLlZzTrancodeFields");
                }
                if (canUseLds && this.truncateInputLastCharField(serviceModelController)) {
                    usedCapabilities.add("ibm.services.wvservice.truncateInputLastCharField");
                }
            }
            String responseSIName = serviceModelController.getServiceResponseSIName();
            file = serviceProjectController.getFolder("service-interfaces").getFile(responseSIName);
            Message responseMsg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)file);
            if (responseMsg != null) {
                DataTypeCapabilitiesVisitor responseVisitor = new DataTypeCapabilitiesVisitor();
                new MessageWalker().accept((IMessageVisitor)responseVisitor, responseMsg.getMessage());
                if (!isUsingArrayCounters && responseVisitor.isUsingArrayCounters()) {
                    usedCapabilities.add("ibm.services.wvservice.arrayCounter");
                }
                if (!overrideBoolean && responseVisitor.overrideBoolean()) {
                    usedCapabilities.add("ibm.services.wvservice.overrideBoolean");
                }
                if (!overrideDate && responseVisitor.overrideDate()) {
                    usedCapabilities.add("ibm.services.wvservice.overrideDate");
                }
                if (!redefineAsChar && responseVisitor.redefineAsChar()) {
                    usedCapabilities.add("ibm.services.wvservice.redefineAsChar");
                }
                if (canUseLds && this.ldsStartsWithLLZZ(serviceModelController)) {
                    usedCapabilities.add("ibm.services.wvservice.outImsLdsStartsWithLlZzFields");
                }
            }
        }
        catch (Exception e) {
            EclipseLogger.logError((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"getExploitedCapabilityList", (Object[])new Object[]{usedCapabilities});
        return usedCapabilities;
    }

    private boolean usingBidi(ServiceModelController serviceModelController) {
        String value = serviceModelController.getValue("bidiConfigRef");
        return value != null && !value.isEmpty();
    }

    private boolean ldsStartsWithLLZZTRANCODE(ServiceModelController serviceModelController) {
        String value = serviceModelController.getValue("ldsStartsWithLLZZTRANCODE");
        return value != null && value.contentEquals("true");
    }

    private boolean ldsStartsWithLLZZ(ServiceModelController serviceModelController) {
        String value = serviceModelController.getValue("ldsStartsWithLLZZ");
        return value != null && value.contentEquals("true");
    }

    private boolean truncateInputLastCharField(ServiceModelController serviceModelController) {
        String value = serviceModelController.getValue("truncateInputLastCharField");
        return value != null && value.contentEquals("true");
    }
}

