/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.validation;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.PosixPortableValidator;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceCapabilityValidatorExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionCompositeProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceCapabilitiesValidator;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import com.ibm.zosconnect.ui.service.editors.CsvListWidget;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectValidator;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;
import org.osgi.framework.Version;

public class ServiceProjectValidator
implements IServiceProjectValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = this.getClass().getName();
    private static final String CAPABILITIES_FILE = ".capabilities";
    private ServiceProjectController serviceController;
    private IProject project;
    private List<ServiceProjectValidationError> errors;

    public ServiceProjectValidator(IProject project, ServiceProjectController serviceProjectController) throws CoreException {
        this.project = project;
        this.serviceController = serviceProjectController;
    }

    public List<ServiceProjectValidationError> validateServicePropertiesFile() throws CoreException {
        String methodName = "validateServicePropertiesFile";
        ZCeeUILogger.entering((String)this.className, (String)"validateServicePropertiesFile", (Object[])new Object[0]);
        this.resetErrors();
        if (this.addErrorIfFound(this.checkFileExistsAndLoadPropertiesIfFileFound())) {
            return this.errors;
        }
        this.validateStandardProperties();
        this.validatePropertiesForServiceType();
        ZCeeUILogger.exiting((String)this.className, (String)"validateServicePropertiesFile", (Object[])new Object[0]);
        return this.errors;
    }

    private void resetErrors() {
        String methodName = "resetErrors";
        ZCeeUILogger.entering((String)this.className, (String)"resetErrors", (Object[])new Object[0]);
        this.errors = new ArrayList<ServiceProjectValidationError>();
        ZCeeUILogger.exiting((String)this.className, (String)"resetErrors", (Object[])new Object[0]);
    }

    private ServiceProjectValidationError checkFileExistsAndLoadPropertiesIfFileFound() {
        String methodName = "checkFileExistsAndLoadPropertiesIfFileFound";
        ZCeeUILogger.entering((String)this.className, (String)"checkFileExistsAndLoadPropertiesIfFileFound", (Object[])new Object[0]);
        ServiceProjectValidationError result = null;
        if (!this.serviceController.getServiceModel().existsPropertiesFile()) {
            String msg = Xlat.error((String)"PROJECT_FILE_MISSING_ERROR", (String[])new String[]{"service.properties", this.project.getName()});
            result = new ServiceProjectValidationError((IResource)this.project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, msg);
        }
        this.serviceController.getServiceModel().loadPropertiesFromServicePropertiesFile();
        ZCeeUILogger.exiting((String)this.className, (String)"checkFileExistsAndLoadPropertiesIfFileFound", (Object[])new Object[0]);
        return result;
    }

    private void validateStandardProperties() {
        String methodName = "validateStandardProperties";
        ZCeeUILogger.entering((String)this.className, (String)"validateStandardProperties", (Object[])new Object[0]);
        List standardPropertyNamesList = ServiceModelController.getStandardPropertyNamesList();
        for (String key : standardPropertyNamesList) {
            this.validateStandardProperty(key);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateStandardProperties", (Object[])new Object[0]);
    }

    private HashSet<String> getServiceExtensionCapabilities() {
        String methodName = "getServiceExtensionCapabilities";
        ZCeeUILogger.entering((String)this.className, (String)"getServiceExtensionCapabilities", (Object[])new Object[0]);
        HashSet<String> allCapabilities = new HashSet<String>();
        HashMap capabilityValidatorExtensions = this.serviceController.getServiceModel().getServiceExtension().getCapabilityValidators();
        Iterator it = capabilityValidatorExtensions.keySet().iterator();
        while (it.hasNext()) {
            ServiceCapabilityValidatorExtension currValidatorExtension = (ServiceCapabilityValidatorExtension)capabilityValidatorExtensions.get(it.next());
            String idPrefix = currValidatorExtension.getId();
            String capabilitiesStr = currValidatorExtension.getSupportedCapabilities();
            if (capabilitiesStr.isEmpty()) continue;
            String[] capArray = capabilitiesStr.split("\\s*,\\s*");
            int i = 0;
            while (i < capArray.length) {
                allCapabilities.add(idPrefix + "." + capArray[i]);
                ++i;
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"getServiceExtensionCapabilities", (Object[])new Object[0]);
        return allCapabilities;
    }

    public List<ServiceProjectValidationError> validateCapabilitiesFile() throws CoreException, IOException {
        String methodName = "validateCapabilitiesFile";
        ZCeeUILogger.entering((String)this.className, (String)"validateCapabilitiesFile", (Object[])new Object[0]);
        HashSet<String> allCapabilities = this.getServiceExtensionCapabilities();
        Properties properties = ProjectTreeFileHelper.getProjectCapabilities((IProject)this.project);
        this.resetErrors();
        if (properties != null) {
            Enumeration<?> capabilities = properties.propertyNames();
            while (capabilities.hasMoreElements()) {
                String currCapabilityStr = (String)capabilities.nextElement();
                if (allCapabilities.contains(currCapabilityStr)) continue;
                this.addErrorIfFound(new ServiceProjectValidationError((IResource)this.project, ServiceProjectMarkerTypes.CAPABILITIES_PROBLEM, Xlat.error((String)"UNKNOWN_CAPABILITY", (String[])new String[]{currCapabilityStr})));
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateCapabilitiesFile", (Object[])new Object[0]);
        return this.errors;
    }

    public void updateProjectCapabilities() throws CoreException, IOException {
        String methodName = "updateProjectCapabilities";
        ZCeeUILogger.entering((String)this.className, (String)"updateProjectCapabilities", (Object[])new Object[0]);
        ArrayList projectCapabilities = new ArrayList();
        HashMap capabilityValidatorExtensions = this.serviceController.getServiceModel().getServiceExtension().getCapabilityValidators();
        Iterator it = capabilityValidatorExtensions.keySet().iterator();
        while (it.hasNext()) {
            ServiceCapabilityValidatorExtension currValidatorExtension = (ServiceCapabilityValidatorExtension)capabilityValidatorExtensions.get(it.next());
            IServiceCapabilitiesValidator capabilityValidator = currValidatorExtension.getValidatorClass();
            ArrayList usedCapabilities = capabilityValidator.getExploitedCapabilityList(this.project);
            if (usedCapabilities == null || usedCapabilities.isEmpty()) continue;
            projectCapabilities.addAll(usedCapabilities);
        }
        IFile capabilitiesFile = this.project.getFile(CAPABILITIES_FILE);
        if (capabilitiesFile.exists()) {
            capabilitiesFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!projectCapabilities.isEmpty()) {
            this.serviceController.createFileInProject(CAPABILITIES_FILE);
            ZCeeUILogger.info((String)"Writing capabilities to file {0}", (Object[])new Object[]{capabilitiesFile.getName()});
            FileWriter writer = new FileWriter(capabilitiesFile.getLocation().toFile());
            for (String str : projectCapabilities) {
                writer.write(str + "\n");
            }
            writer.close();
        }
        ZCeeUILogger.exiting((String)this.className, (String)"updateProjectCapabilities", (Object[])new Object[0]);
    }

    private void validatePropertiesForServiceType() throws CoreException {
        String methodName = "validatePropertiesForServiceType";
        ZCeeUILogger.entering((String)this.className, (String)"validatePropertiesForServiceType", (Object[])new Object[0]);
        Set existingNonStandardPropertyNamesList = this.serviceController.getServiceModel().getExistingNonStandardPropertyNamesList();
        ServiceExtension serviceExtension = this.serviceController.getServiceModel().getServiceExtension();
        HashSet propertiesForServiceType = new HashSet(serviceExtension.getPropertiesAsStringSet());
        IServicePropertiesValidator servicePropertiesValidator = this.serviceController.getServiceModel().getServiceExtension().getValidatorClass();
        IResource resourceImpl = this.serviceController.getServiceModel().getResource();
        for (String key : propertiesForServiceType) {
            if (servicePropertiesValidator == null) {
                ZCeeUILogger.info((String)"No validator class provided for service speciic properties", (Object[])new Object[0]);
                break;
            }
            if (!existingNonStandardPropertyNamesList.contains(key)) continue;
            ZCeeUILogger.info((String)"Validating service methodType provided property", (Object[])new Object[]{key});
            ServiceExtensionProperty extensionProperty = serviceExtension.getPropertyByKey(key);
            String propertyName = extensionProperty.getPropertyName();
            String propertyValue = this.serviceController.getServiceModel().getValue(propertyName);
            boolean isRequired = extensionProperty.isRequired();
            String propertyType = extensionProperty.getPropertyType();
            ServiceProjectValidationError validationError = servicePropertiesValidator.validateConfigurationProperty(this.serviceController, resourceImpl, propertyName, propertyValue, isRequired, propertyType);
            ServiceProjectValidationError readableValidationError = null;
            if (validationError != null) {
                readableValidationError = new ServiceProjectValidationError(validationError.getResource(), ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, validationError.getMessage().replace(propertyName, extensionProperty.getPropertyLabel()));
            }
            if (propertyType.equalsIgnoreCase("StringCsv")) {
                HashSet<String> allHeaders = new HashSet<String>();
                for (String header : CsvListWidget.getItems(propertyValue)) {
                    if (header.isEmpty()) continue;
                    if (allHeaders.contains(header)) {
                        this.addErrorIfFound(new ServiceProjectValidationError(resourceImpl, "com.ibm.zosconnect.service.ui.propertiesproblem", Xlat.error((String)"DUPLICATE_VALUE_NAMED", (String[])new String[]{extensionProperty.getPropertyLabel()}), null, null, Integer.valueOf(1)));
                        break;
                    }
                    allHeaders.add(header);
                }
            }
            this.addErrorIfFound(readableValidationError);
            existingNonStandardPropertyNamesList.remove(key);
        }
        for (ServiceExtensionCompositeProperty property : serviceExtension.getCompositeProperties()) {
            this.addErrorIfFound(servicePropertiesValidator.validateDefinitionProperty(resourceImpl, property.getProjectKey(), this.serviceController.getServiceModel().getValue(property.getProjectKey())));
            existingNonStandardPropertyNamesList.remove(property.getProjectKey());
        }
        for (String key : existingNonStandardPropertyNamesList) {
            if (key.equals("enforceMinArrayOccurrenceResponse") || key.equals("imsTranCodeSpaceDelimited")) continue;
            ZCeeUILogger.info((String)"Found unexpected property", (Object[])new Object[]{key});
            String msg = Xlat.error((String)"UNEXPECTED_SERVICE_PROPERTY_FOUND_WARNING", (String[])new String[]{key});
            this.errors.add(this.createPropertyError(msg, key, this.serviceController.getServiceModel().getValue(key), 1));
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validatePropertiesForServiceType", (Object[])new Object[0]);
    }

    public ServiceProjectValidationError validateServiceExtensionProperty(IMessageManager messageMgr, HashMap<String, Control> configurationControls, String label, String propertyValue) {
        ServiceProjectValidationError validationError = null;
        ServiceExtension serviceExtension = this.serviceController.getServiceModel().getServiceExtension();
        IServicePropertiesValidator servicePropertiesValidator = null;
        try {
            servicePropertiesValidator = this.serviceController.getServiceModel().getServiceExtension().getValidatorClass();
        }
        catch (CoreException e) {
            ZCeeUILogger.info((String)"Failed to create executable class from extension.", (Object[])new Object[0]);
            return null;
        }
        if (servicePropertiesValidator == null) {
            ZCeeUILogger.info((String)"No validator class provided for service speciic properties", (Object[])new Object[0]);
            return null;
        }
        ServiceExtensionProperty extensionProperty = serviceExtension.getPropertyByLabel(label);
        if (extensionProperty == null) {
            ZCeeUILogger.info((String)"Property not found in extension properties", (Object[])new Object[0]);
            return null;
        }
        IResource resourceImpl = this.serviceController.getServiceModel().getResource();
        String propertyName = extensionProperty.getPropertyName();
        validationError = servicePropertiesValidator.validateConfigurationProperty(this.serviceController, messageMgr, configurationControls, resourceImpl, extensionProperty, propertyValue);
        ServiceProjectValidationError readableValidationError = null;
        if (validationError != null) {
            readableValidationError = new ServiceProjectValidationError(validationError.getResource(), ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, validationError.getMessage().replace(propertyName, extensionProperty.getPropertyLabel()));
        }
        return readableValidationError;
    }

    private void validateStandardProperty(String key) {
        String methodName = "validateStandardProperty";
        ZCeeUILogger.entering((String)this.className, (String)"validateStandardProperty", (Object[])new Object[]{key});
        String value = this.serviceController.getServiceModel().getValue(key);
        if (value == null) {
            String msg = Xlat.error((String)"REQUIRED_SERVICE_PROPERTY_MISSING", (String[])new String[]{key});
            this.errors.add(this.createPropertyError(msg, key, null, 2));
            return;
        }
        if (key.equals("name")) {
            this.addErrorIfFound(this.validateServiceName(value));
        } else if (key.equals("description")) {
            this.addErrorIfFound(this.validateServiceDescription(value));
        } else if (key.equals("version")) {
            this.addErrorIfFound(this.validateServiceVersion(value));
        } else if (key.equals("servicetype")) {
            this.addErrorIfFound(this.validateServiceType(value));
        } else if (key.equals("provider")) {
            this.addErrorIfFound(this.validateServiceProvider(value));
        } else {
            String msg = Xlat.error((String)"UNEXPECTED_SERVICE_PROPERTY_FOUND_WARNING", (String[])new String[]{key});
            this.errors.add(this.createPropertyError(msg, key, value, 2));
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateStandardProperty", (Object[])new Object[]{key});
    }

    private boolean addErrorIfFound(ServiceProjectValidationError newError) {
        if (newError != null) {
            if (!this.errors.contains(newError)) {
                this.errors.add(newError);
            }
            return true;
        }
        return false;
    }

    private boolean addErrorIfFound(List<ServiceProjectValidationError> newErrors) {
        if (newErrors != null) {
            for (ServiceProjectValidationError newError : newErrors) {
                if (this.errors.contains(newError)) continue;
                this.errors.add(newError);
            }
            return true;
        }
        return false;
    }

    public ServiceProjectValidationError validateServiceName(String value) {
        String errMsg;
        if (!this.project.getName().equals(value)) {
            this.serviceController.getServiceModel().setServiceName(this.project.getName());
            this.serviceController.getServiceModel().savePropertiesAndRefreshProjectExplorer();
        }
        if ((errMsg = PosixPortableValidator.validate((String)value, (PosixPortableValidator.MessageInsertType)PosixPortableValidator.MessageInsertType.SERVICE)) != null) {
            return this.createServiceNameError(errMsg);
        }
        return null;
    }

    public ServiceProjectValidationError validateServiceDescription(String description) {
        ServiceProjectValidationError result = null;
        return result;
    }

    public ServiceProjectValidationError validateServiceVersion(String version) {
        ServiceProjectValidationError result = null;
        if (version.isEmpty()) {
            String msg = Xlat.error((String)"REQUIRED_SERVICE_PROPERTY_MISSING", (String[])new String[]{Xlat.label((String)"SERVICEEDIT_LABEL_VERSION")});
            return this.createPropertyError(msg, "version", version, 2);
        }
        try {
            Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            String msg = Xlat.error((String)"VERSION_MUST_BE_OSGI_FORMAT", (String[])new String[]{e.getLocalizedMessage()});
            result = this.createPropertyError(msg, "version", version, 2);
        }
        return result;
    }

    public ServiceProjectValidationError validateServiceType(String value) {
        ServiceProjectValidationError result = null;
        if (!this.serviceController.getServiceModel().getServiceExtension().getValidServiceTypes().contains(value)) {
            String msg = Xlat.error((String)"UNKNOWN_SERVICE_TYPE", (String[])new String[]{value, "service.properties"});
            result = this.createPropertyError(msg, "servicetype", value, 2);
        }
        return result;
    }

    private ServiceProjectValidationError validateServiceProvider(String value) {
        ServiceProjectValidationError result = null;
        HashSet providers = ServiceExtension.getAllProviders();
        if (!providers.contains(value)) {
            String msg = Xlat.error((String)"INVALID_PROVIDER", (String[])new String[]{value, "service.properties"});
            result = this.createPropertyError(msg, "provider", value, 2);
        }
        return result;
    }

    private ServiceProjectValidationError createServiceNameError(String msg) {
        return new ServiceProjectValidationError((IResource)this.project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, msg);
    }

    private ServiceProjectValidationError createPropertyError(String message, String propertyKey, String propertyValue, int severity) {
        ServiceProjectValidationError error = new ServiceProjectValidationError(this.serviceController.getServiceModel().getResource(), ServiceProjectMarkerTypes.PROPERTIES_PROBLEM.toString(), message, null, null, Integer.valueOf(severity));
        error.getAttributes().put("key", propertyKey);
        error.getAttributes().put("value", propertyValue);
        return error;
    }

    @Override
    public void setControlToError(IMessageManager messageMgr, String key, ServiceProjectValidationError errorValidation, Control control) {
        messageMgr.addMessage((Object)key, errorValidation.getMessage(), null, 3, control);
    }

    @Override
    public void setControlToWarning(IMessageManager messageMgr, String key, ServiceProjectValidationError errorValidation, Control control) {
        messageMgr.addMessage((Object)key, errorValidation.getMessage(), null, 2, control);
    }

    @Override
    public void resetControlToError(IMessageManager messageMgr, String key, Control control) {
        messageMgr.removeMessage((Object)key, control);
    }

    @Override
    public void removeMessages(IMessageManager messageMgr, Control control) {
        messageMgr.removeMessages(control);
    }
}

