/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.validation;

import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import org.eclipse.core.resources.IResource;

public class AdvancedOptionsValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private ServiceProjectValidationError createPropertyError(IResource resource, String message, String propertyKey, String propertyValue) {
        ServiceProjectValidationError error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, message);
        error.getAttributes().put("key", propertyKey);
        error.getAttributes().put("value", propertyValue);
        return error;
    }

    private ServiceProjectValidationError createPropertyWarning(IResource resource, String message, String propertyKey, String propertyValue, String markerType) {
        ServiceProjectValidationError error = new ServiceProjectValidationError(resource, markerType, message, null, null, Integer.valueOf(1));
        error.getAttributes().put("key", propertyKey);
        error.getAttributes().put("value", propertyValue);
        return error;
    }

    public ServiceProjectValidationError validateTrimOutputLeadingWhitespace(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_TRIM_OUTPUT_LEADING_WHITESPACE")});
            result = this.createPropertyError(resource, msg, "trimOutputLeadingWhitespace", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateTrimOutputTrailingWhitespace(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_TRIM_OUTPUT_TRAILING_WHITESPACE")});
            result = this.createPropertyError(resource, msg, "trimOutputTrailingWhitespace", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateEscapeOutputControlCharacters(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_ESCAPE_CONTROL_CHARACTERS")});
            result = this.createPropertyError(resource, msg, "escapeOutputControlCharacters", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateOmitOutputEmptyTags(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_OMIT_EMPTY_FIELDS")});
            result = this.createPropertyError(resource, msg, "omitOutputEmptyTags", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateOmitOutputFieldsByValue(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_OMIT_FIELDS_BY_VALUE")});
            result = this.createPropertyError(resource, msg, "omitOutputFieldsByValue", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateInitializeInputFields(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_INITIALIZE_INPUT_FIELDS")});
            result = this.createPropertyError(resource, msg, "initializeInputFields", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateEnforceMinArrayOccurrence(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_ENFORCE_MIN_ARRAY_OCCURRENCE")});
            result = this.createPropertyError(resource, msg, "enforceMinArrayOccurrence", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateEnforceMinArrayOccurrenceResponse(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (value == null) {
            return result;
        }
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_ENFORCE_MIN_ARRAY_OCCURRENCE_RESPONSE")});
            result = this.createPropertyError(resource, msg, "enforceMinArrayOccurrenceResponse", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateLdsStartsWithLLZZ(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (value == null) {
            return result;
        }
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_LDS_STARTS_LLZZ")});
            result = this.createPropertyError(resource, msg, "ldsStartsWithLLZZ", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateLdsStartsWithLLZZTRANCODE(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (value == null) {
            return result;
        }
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_LDS_STARTS_LLZZTRANCODE")});
            result = this.createPropertyError(resource, msg, "ldsStartsWithLLZZTRANCODE", value);
        }
        return result;
    }

    public ServiceProjectValidationError validateLdsStartsWithLLZZUseSameInterface(IResource resource, String value, boolean needToCheckLLZZForEditorChange, boolean callFromBuilder, IServiceModelController advancedOptionsServiceModelController) {
        ServiceProjectValidationError result = null;
        boolean checkForError = false;
        ServiceProjectController serviceProjectController = new ServiceProjectController(resource.getProject());
        if (callFromBuilder) {
            String responseSIName;
            String requestSIName = serviceProjectController.getServiceModel().getValue("requestSIName");
            if (requestSIName.equals(responseSIName = serviceProjectController.getServiceModel().getValue("responseSIName"))) {
                checkForError = true;
            }
        } else if (needToCheckLLZZForEditorChange) {
            checkForError = true;
        }
        if (checkForError) {
            String propVal = null;
            propVal = needToCheckLLZZForEditorChange && advancedOptionsServiceModelController != null ? advancedOptionsServiceModelController.getValue("ldsStartsWithLLZZ") : serviceProjectController.getServiceModel().getValue("ldsStartsWithLLZZ");
            if (propVal != null && propVal.equals("true")) {
                String msg = Xlat.error((String)"SAME_REQUEST_RESPONSE_INTERFACE_LDS_STARTSWITH_LLZZ");
                result = this.createPropertyWarning(resource, msg, "ldsStartsWithLLZZ", value, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM.toString());
            }
        }
        return result;
    }

    public ServiceProjectValidationError validateLdsStartsWithLLZZTRANCODEUseSameInterface(IResource resource, String value, boolean needToCheckLLZZForEditorChange, boolean callFromBuilder, IServiceModelController advancedOptionsServiceModelController) {
        ServiceProjectValidationError result = null;
        boolean checkForError = false;
        ServiceProjectController serviceProjectController = new ServiceProjectController(resource.getProject());
        if (callFromBuilder) {
            String responseSIName;
            String requestSIName = serviceProjectController.getServiceModel().getValue("requestSIName");
            if (requestSIName.equals(responseSIName = serviceProjectController.getServiceModel().getValue("responseSIName"))) {
                checkForError = true;
            }
        } else if (needToCheckLLZZForEditorChange) {
            checkForError = true;
        }
        if (checkForError) {
            String propVal = null;
            propVal = needToCheckLLZZForEditorChange && advancedOptionsServiceModelController != null ? advancedOptionsServiceModelController.getValue("ldsStartsWithLLZZTRANCODE") : serviceProjectController.getServiceModel().getValue("ldsStartsWithLLZZTRANCODE");
            if (propVal != null && propVal.equals("true")) {
                String msg = Xlat.error((String)"SAME_REQUEST_RESPONSE_INTERFACE_LDS_STARTSWITH_LLZZTRANCODE");
                result = this.createPropertyWarning(resource, msg, "ldsStartsWithLLZZTRANCODE", value, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM.toString());
            }
        }
        return result;
    }

    public ServiceProjectValidationError validateTruncateInputLastCharField(IResource resource, String value) {
        ServiceProjectValidationError result = null;
        if (value == null) {
            return result;
        }
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"TSW_TRUNCATE_INPUT_LAST_CHAR_FIELD")});
            result = this.createPropertyError(resource, msg, "truncateInputLastCharField", value);
        }
        return result;
    }
}

