/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.nav.properties;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectService;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceDetail;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServiceNode;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ServicePropertiesSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label labelResourceType;
    private Label labelServiceName;
    private Label labelServiceDescription;
    private Label labelServiceProvider;
    private Label labelServiceUrl;
    private Label labelServiceInvokeUrl;
    private Label labelDataTxformProvider;
    private Label labelServiceStatus;
    private StyledText textResourceType;
    private StyledText textServiceName;
    private StyledText textServiceDescription;
    private StyledText textServiceProvider;
    private StyledText textDataTxformProvider;
    private StyledText textServiceStatus;
    private ImageHyperlink imageLinkServiceUrl;
    private ImageHyperlink imageLinkServiceInvokeUrl;
    private Hyperlink linkServiceUrl;
    private Hyperlink linkServiceInvokeUrl;
    private Composite containerComposite;
    private Composite row1Composite;
    private Composite row2Composite;
    private Composite row3Composite;
    private Composite row4Composite;
    private Composite row5Composite;
    private Composite row6Composite;
    private Composite row7Composite;
    private Composite row8Composite;
    private TabbedPropertySheetWidgetFactory factory;
    private ZosConnectServiceNode selectedServiceNode;
    private ClickUrlListener clickServiceUrlListener = null;
    private ClickUrlListener clickServiceInvokeUrlListener = null;
    private CopyUrlListener copyServiceUrlListener = null;
    private CopyUrlListener copyServiceInvokeUrlListener = null;
    private ZosConnectService service;
    private ZosConnectServiceDetail serviceDetail;
    private TabbedPropertySheetPage page;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.factory = this.getWidgetFactory();
        this.containerComposite = this.factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(1, false);
        GridData data = new GridData(16384, 4, false, true);
        data.widthHint = 500;
        this.containerComposite.setLayout((Layout)layout);
        this.containerComposite.setData((Object)data);
        this.row1Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row2Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row3Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row4Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row5Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row6Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row7Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row8Composite = this.factory.createFlatFormComposite(this.containerComposite);
        RowLayout rLayout = new RowLayout();
        rLayout.center = true;
        rLayout.wrap = true;
        this.row1Composite.setLayout((Layout)rLayout);
        this.row2Composite.setLayout((Layout)rLayout);
        this.row3Composite.setLayout((Layout)rLayout);
        this.row4Composite.setLayout((Layout)rLayout);
        this.row5Composite.setLayout((Layout)rLayout);
        this.row6Composite.setLayout((Layout)rLayout);
        this.row7Composite.setLayout((Layout)rLayout);
        this.row8Composite.setLayout((Layout)rLayout);
        this.labelResourceType = this.factory.createLabel(this.row1Composite, Xlat.label((String)"PROPERTIES_RESOURCE_TYPE") + Xlat.colon());
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.labelResourceType.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)this.labelResourceType.getDisplay());
        this.labelResourceType.setFont(boldFont);
        this.labelResourceType.setLayoutData((Object)new RowData());
        this.textResourceType = new StyledText(this.row1Composite, 64);
        this.textResourceType.setText(Xlat.label((String)"PROPERTIES_SERVICE_TYPE_ZCEE"));
        this.textResourceType.setEditable(false);
        this.textResourceType.setLayoutData((Object)new RowData());
        this.labelServiceName = this.factory.createLabel(this.row2Composite, Xlat.label((String)"PROPERTIES_SERVICE_NAME") + Xlat.colon());
        this.labelServiceName.setFont(boldFont);
        this.labelServiceName.setLayoutData((Object)new RowData());
        this.textServiceName = new StyledText(this.row2Composite, 64);
        this.textServiceName.setEditable(false);
        this.textServiceName.setLayoutData((Object)new RowData());
        this.labelServiceUrl = this.factory.createLabel(this.row3Composite, Xlat.label((String)"PROPERTIES_SERVICE_URL") + Xlat.colon());
        this.labelServiceUrl.setFont(boldFont);
        this.labelServiceUrl.setLayoutData((Object)new RowData());
        this.imageLinkServiceUrl = this.factory.createImageHyperlink(this.row3Composite, 0);
        this.imageLinkServiceUrl.setLayoutData((Object)new RowData());
        this.imageLinkServiceUrl.setImage(XImg.icon((String)"copy_edit.png"));
        this.imageLinkServiceUrl.setToolTipText(Xlat.description((String)"TOOLTIP_COPY_LINK_LOCATION"));
        this.linkServiceUrl = this.factory.createHyperlink(this.row3Composite, "", 64);
        this.linkServiceUrl.setLayoutData((Object)new RowData());
        this.labelServiceInvokeUrl = this.factory.createLabel(this.row4Composite, Xlat.label((String)"PROPERTIES_SERVICE_INVOKE_URL") + Xlat.colon());
        this.labelServiceInvokeUrl.setFont(boldFont);
        this.labelServiceInvokeUrl.setLayoutData((Object)new RowData());
        this.imageLinkServiceInvokeUrl = this.factory.createImageHyperlink(this.row4Composite, 0);
        this.imageLinkServiceInvokeUrl.setLayoutData((Object)new RowData());
        this.imageLinkServiceInvokeUrl.setImage(XImg.icon((String)"copy_edit.png"));
        this.imageLinkServiceInvokeUrl.setToolTipText(Xlat.description((String)"TOOLTIP_COPY_LINK_LOCATION"));
        this.linkServiceInvokeUrl = this.factory.createHyperlink(this.row4Composite, "", 64);
        this.linkServiceInvokeUrl.setLayoutData((Object)new RowData());
        this.labelServiceStatus = this.factory.createLabel(this.row5Composite, Xlat.label((String)"PROPERTIES_SERVICE_STATUS") + Xlat.colon());
        this.labelServiceStatus.setFont(boldFont);
        this.labelServiceStatus.setLayoutData((Object)new RowData());
        this.textServiceStatus = new StyledText(this.row5Composite, 64);
        this.textServiceStatus.setEditable(false);
        this.textServiceStatus.setLayoutData((Object)new RowData());
        this.labelServiceDescription = this.factory.createLabel(this.row6Composite, Xlat.label((String)"PROPERTIES_SERVICE_DESCRIPTION") + Xlat.colon());
        this.labelServiceDescription.setFont(boldFont);
        this.labelServiceDescription.setLayoutData((Object)new RowData());
        this.textServiceDescription = new StyledText(this.row6Composite, 64);
        this.textServiceDescription.setEditable(false);
        this.textServiceDescription.setLayoutData((Object)new RowData());
        this.labelServiceProvider = this.factory.createLabel(this.row7Composite, Xlat.label((String)"PROPERTIES_SERVICE_PROVIDER") + Xlat.colon());
        this.labelServiceProvider.setFont(boldFont);
        this.labelServiceProvider.setLayoutData((Object)new RowData());
        this.textServiceProvider = new StyledText(this.row7Composite, 64);
        this.textServiceProvider.setEditable(false);
        this.textServiceProvider.setLayoutData((Object)new RowData());
        this.labelDataTxformProvider = this.factory.createLabel(this.row8Composite, Xlat.label((String)"PROPERTIES_SERVICE_DATAXFORM_PROVIDER") + Xlat.colon());
        this.labelDataTxformProvider.setFont(boldFont);
        this.labelDataTxformProvider.setLayoutData((Object)new RowData());
        this.textDataTxformProvider = new StyledText(this.row8Composite, 64);
        this.textDataTxformProvider.setEditable(false);
        this.textDataTxformProvider.setLayoutData((Object)new RowData());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.selectedServiceNode = (ZosConnectServiceNode)((IStructuredSelection)selection).getFirstElement();
    }

    public void refresh() {
        super.refresh();
        ZosConnectServerNode serverNode = (ZosConnectServerNode)this.selectedServiceNode.getParent().getParent();
        if (!serverNode.getConnectedState()) {
            return;
        }
        this.service = this.selectedServiceNode.getService();
        this.serviceDetail = this.selectedServiceNode.getServiceDetail();
        if (XSwt.isNotDisposed((Control)this.imageLinkServiceUrl) && this.copyServiceUrlListener != null) {
            this.imageLinkServiceUrl.removeHyperlinkListener((IHyperlinkListener)this.copyServiceUrlListener);
            this.copyServiceUrlListener = null;
        }
        if (XSwt.isNotDisposed((Control)this.linkServiceUrl) && this.clickServiceUrlListener != null) {
            this.linkServiceUrl.removeHyperlinkListener((IHyperlinkListener)this.clickServiceUrlListener);
            this.clickServiceUrlListener = null;
        }
        if (XSwt.isNotDisposed((Control)this.imageLinkServiceInvokeUrl) && this.copyServiceInvokeUrlListener != null) {
            this.imageLinkServiceInvokeUrl.removeHyperlinkListener((IHyperlinkListener)this.copyServiceInvokeUrlListener);
            this.copyServiceInvokeUrlListener = null;
        }
        if (XSwt.isNotDisposed((Control)this.linkServiceInvokeUrl) && this.clickServiceInvokeUrlListener != null) {
            this.linkServiceInvokeUrl.removeHyperlinkListener((IHyperlinkListener)this.clickServiceInvokeUrlListener);
            this.clickServiceInvokeUrlListener = null;
        }
        XSwt.setText((StyledText)this.textServiceName, (String)StringUtils.trimToEmpty((String)this.service.getServiceName()));
        XSwt.setText((StyledText)this.textServiceProvider, (String)StringUtils.trimToEmpty((String)this.service.getServiceProvider()));
        XSwt.setText((StyledText)this.textServiceDescription, (String)StringUtils.trimToEmpty((String)this.service.getServiceDescription()));
        XSwt.setText((StyledText)this.textServiceStatus, (String)"");
        XSwt.setText((Hyperlink)this.linkServiceInvokeUrl, (String)"");
        XSwt.setText((StyledText)this.textDataTxformProvider, (String)"");
        if (!XSwt.isAnyDisposed((Control[])new Control[]{this.imageLinkServiceUrl, this.linkServiceUrl})) {
            String serviceUrl = StringUtils.trimToEmpty((String)this.service.getServiceURL());
            this.linkServiceUrl.setText(serviceUrl);
            if (!serviceUrl.isEmpty()) {
                this.copyServiceUrlListener = new CopyUrlListener((Control)this.imageLinkServiceUrl, serviceUrl);
                this.imageLinkServiceUrl.addHyperlinkListener((IHyperlinkListener)this.copyServiceUrlListener);
                this.clickServiceUrlListener = new ClickUrlListener((Control)this.linkServiceUrl, serviceUrl);
                this.linkServiceUrl.addHyperlinkListener((IHyperlinkListener)this.clickServiceUrlListener);
            }
        }
        if (this.serviceDetail.getServiceStatus() != null) {
            XSwt.setText((StyledText)this.textServiceStatus, (String)this.serviceDetail.getServiceStatus().toStringXlat());
        }
        if (!XSwt.isAnyDisposed((Control[])new Control[]{this.imageLinkServiceInvokeUrl, this.linkServiceInvokeUrl})) {
            String serviceInvokeUrl = StringUtils.trimToEmpty((String)this.serviceDetail.getServiceInvokeURL());
            this.linkServiceInvokeUrl.setText(serviceInvokeUrl);
            if (!serviceInvokeUrl.isEmpty()) {
                this.copyServiceInvokeUrlListener = new CopyUrlListener((Control)this.imageLinkServiceInvokeUrl, serviceInvokeUrl);
                this.imageLinkServiceInvokeUrl.addHyperlinkListener((IHyperlinkListener)this.copyServiceInvokeUrlListener);
                this.clickServiceInvokeUrlListener = new ClickUrlListener((Control)this.linkServiceInvokeUrl, serviceInvokeUrl);
                this.linkServiceInvokeUrl.addHyperlinkListener((IHyperlinkListener)this.clickServiceInvokeUrlListener);
            }
        }
        XSwt.setText((StyledText)this.textDataTxformProvider, (String)StringUtils.trimToEmpty((String)this.serviceDetail.getDataXformProvider()));
        XSwt.layout((Composite)this.containerComposite, (boolean)true);
    }

    private class ClickUrlListener
    extends HyperlinkAdapter2 {
        private String url;

        public ClickUrlListener(Control owner, String url) {
            super(owner);
            this.url = url;
        }

        public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = browserSupport.getExternalBrowser();
                browser.openURL(URI.create(this.url).toURL());
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                ZCeeErrorDialog.openError((Exception)e);
            }
        }
    }

    private class CopyUrlListener
    extends HyperlinkAdapter2 {
        private String url;

        public CopyUrlListener(Control owner, String url) {
            super(owner);
            this.url = url;
        }

        public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
            XSwt.setClipboardText((String)this.url);
        }

        public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
            owner.setBackground(XSwt.getColor((int)19));
        }

        public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
            owner.setBackground(XSwt.getColor((int)37));
        }
    }
}

