/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.nav;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceStatus;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServiceNode;
import com.ibm.zosconnect.ui.model.ZosConnectServicesFolder;
import com.ibm.zosconnect.ui.nav.IZosConnectServerViewParticipant;
import com.ibm.zosconnect.ui.nav.ServerOverlayImageDescriptor;
import com.ibm.zosconnect.ui.service.jobs.RefreshServicesJob;
import com.ibm.zosconnect.ui.util.Images;
import com.ibm.zosconnect.ui.util.Utility;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ServerViewParticipant
implements IZosConnectServerViewParticipant {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = ServerViewParticipant.class.getName();
    private static final String[] decoratesClassNames = new String[]{ZosConnectServicesFolder.class.getName(), ZosConnectServiceNode.class.getName()};
    private static Image SERVICE_STARTED_COMPOSITE_IMAGE = null;
    private static Image SERVICE_STOPPED_COMPOSITE_IMAGE = null;
    private static Image SERVICE_UNKNOWN_COMPOSITE_IMAGE = null;

    public ServerViewParticipant() {
        this.initDecoratedImages();
    }

    public void refreshServer(ZosConnectServerNode server, JobGroup jobGroup) {
        ZCeeUILogger.entering((String)TAG, (String)"refreshServer(server={0})", (Object[])new Object[]{server});
        IConnection connection = server.getConnection();
        if (connection != null && connection.isConnected()) {
            RefreshServicesJob refresh = new RefreshServicesJob(server);
            if (jobGroup != null) {
                refresh.setJobGroup(jobGroup);
            }
            refresh.schedule();
        }
        ZCeeUILogger.exiting((String)TAG, (String)"refreshServer(ZosConnectServerNode)", (Object[])new Object[0]);
    }

    public String[] getDecoratesClasses() {
        return decoratesClassNames;
    }

    public String getText(Object element) {
        StringBuilder builder = new StringBuilder();
        if (element instanceof ZosConnectServiceNode) {
            builder.append(((ZosConnectServiceNode)element).getName());
        } else if (element instanceof ZosConnectServicesFolder) {
            builder.append(((ZosConnectServicesFolder)element).getName());
        }
        return builder.toString();
    }

    public Image getImage(Object element) {
        Image image = null;
        image = element instanceof ZosConnectServiceNode ? Images.getServiceImage() : (element instanceof ZosConnectServicesFolder ? Images.getFolderImage() : Images.getErrorWarningImage());
        return image;
    }

    public String decorateText(String label, Object element) {
        StringBuilder builder = new StringBuilder();
        builder.append(label);
        if (element instanceof ZosConnectServiceNode) {
            builder.append(this.decorateText((ZosConnectServiceNode)element));
        } else if (element instanceof ZosConnectServicesFolder) {
            builder.append(this.decorateText((ZosConnectServicesFolder)element));
        }
        return builder.toString();
    }

    private String decorateText(ZosConnectServiceNode node) {
        StringBuilder builder = new StringBuilder();
        ZosConnectServiceStatus status = ZosConnectServiceStatus.UNKNOWN;
        if (node.getServiceDetail() != null) {
            status = node.getServiceDetail().getServiceStatus();
        }
        if (status != null) {
            builder.append(" (");
            builder.append(status.toStringXlat());
            builder.append(")");
        }
        return builder.toString();
    }

    private String decorateText(ZosConnectServicesFolder node) {
        StringBuilder builder = new StringBuilder();
        if (node.isRefreshing()) {
            builder.append(" (");
            builder.append(Xlat.description((String)"STATUS_REFRESHING"));
            builder.append(")");
        } else {
            Integer serviceCount = ArrayUtilz.length((Object[])node.getChildren());
            if (serviceCount > 0) {
                builder.append(" (");
                builder.append(ArrayUtilz.length((Object[])node.getChildren()));
                builder.append(")");
            }
        }
        return builder.toString();
    }

    public Image decorateImage(Image image, Object element) {
        if (element instanceof ZosConnectServiceNode) {
            image = this.decorateImage(image, (ZosConnectServiceNode)element);
        }
        return image;
    }

    private Image decorateImage(Image image, ZosConnectServiceNode element) {
        ZosConnectServiceNode serviceNode = element;
        image = serviceNode.isStatusStarted() ? SERVICE_STARTED_COMPOSITE_IMAGE : (serviceNode.isStatusStopped() ? SERVICE_STOPPED_COMPOSITE_IMAGE : SERVICE_UNKNOWN_COMPOSITE_IMAGE);
        return image;
    }

    private void initDecoratedImages() {
        ServerOverlayImageDescriptor olid;
        ImageDescriptor overlayImage;
        ImageDescriptor baseImage;
        if (SERVICE_STARTED_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor((String)"service_16.gif");
            overlayImage = Utility.getImageDescriptor((String)"started_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            SERVICE_STARTED_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
        if (SERVICE_STOPPED_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor((String)"service_16.gif");
            overlayImage = Utility.getImageDescriptor((String)"stopped_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            SERVICE_STOPPED_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
        if (SERVICE_UNKNOWN_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor((String)"service_16.gif");
            overlayImage = Utility.getImageDescriptor((String)"unknown_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            SERVICE_UNKNOWN_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
    }
}

