/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServiceNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import com.ibm.zosconnect.ui.service.jobs.StartServicesJob;
import com.ibm.zosconnect.ui.util.AdminApiConnectionUIUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class StartServiceHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = StartServiceHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List services;
        block7: {
            block6: {
                ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (part instanceof ZosConnectServerNav) break block6;
                return null;
            }
            services = StartServiceHandler.getSelectedElementsOfType(ZosConnectServiceNode.class);
            if (!ListUtilz.isEmpty((List)services)) break block7;
            return null;
        }
        try {
            boolean sequentialJobExecution = AdminApiConnectionUIUtil.servicesRefSameCredential((List)services);
            ZCeeUILogger.info((String)"sequentialJobExecution={0}", (Object[])new Object[]{sequentialJobExecution});
            ZosConnectServerNode firstServer = ((ZosConnectServiceNode)services.get(0)).getServerNode();
            LinkedHashMap server2ApisMap = StartServiceHandler.getServer2ServicesMap((List)services);
            for (Map.Entry server2Apis : server2ApisMap.entrySet()) {
                StartServicesJob startServicesJob = new StartServicesJob((ZosConnectServerNode)server2Apis.getKey(), (List)server2Apis.getValue());
                if (sequentialJobExecution) {
                    startServicesJob.setJobGroup(firstServer.getJobGroup());
                }
                startServicesJob.setUser(true);
                startServicesJob.schedule();
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        ZCeeUILogger.entering((String)TAG, (String)"isEnabled()", (Object[])new Object[0]);
        List services = StartServiceHandler.getSelectedElementsOfType(ZosConnectServiceNode.class);
        Iterator servicesIt = services.iterator();
        if (servicesIt.hasNext()) {
            enabled = true;
            while (enabled && servicesIt.hasNext()) {
                ZosConnectServiceNode service = (ZosConnectServiceNode)servicesIt.next();
                ZosConnectServerNode server = service.getServerNode();
                if (server != null && server.getConnectedState() && service.isStatusStopped()) continue;
                enabled = false;
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"{0}:isEnabled()", (Object[])new Object[]{enabled});
        return enabled;
    }
}

