/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServicesFolder;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import com.ibm.zosconnect.ui.service.jobs.RefreshServicesJob;
import com.ibm.zosconnect.ui.util.AdminApiConnectionUIUtil;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshServicesHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = RefreshServicesHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List servers;
        block7: {
            block6: {
                ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (part instanceof ZosConnectServerNav) break block6;
                return null;
            }
            servers = RefreshServicesHandler.getSelectedElementsOfType(ZosConnectServerNode.class, (boolean)true);
            if (!ListUtilz.isEmpty((List)servers)) break block7;
            return null;
        }
        try {
            boolean sequentialJobExecution = AdminApiConnectionUIUtil.serversRefSameCredential((List)servers);
            ZCeeUILogger.info((String)"sequentialJobExecution={0}", (Object[])new Object[]{sequentialJobExecution});
            ZosConnectServerNode firstServer = (ZosConnectServerNode)servers.get(0);
            for (ZosConnectServerNode server : servers) {
                RefreshServicesJob refreshJob = new RefreshServicesJob(server);
                if (sequentialJobExecution) {
                    refreshJob.setJobGroup(firstServer.getJobGroup());
                }
                refreshJob.schedule();
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        ZCeeUILogger.entering((String)TAG, (String)"isEnabled()", (Object[])new Object[0]);
        List serviceFolders = RefreshServicesHandler.getSelectedElementsOfType(ZosConnectServicesFolder.class);
        Iterator serviceFoldersIt = serviceFolders.iterator();
        if (serviceFoldersIt.hasNext()) {
            enabled = true;
            while (enabled && serviceFoldersIt.hasNext()) {
                ZosConnectServicesFolder serviceFolder = (ZosConnectServicesFolder)serviceFoldersIt.next();
                ZosConnectServerNode server = serviceFolder.getServerNode();
                if (server == null) continue;
                server.getConnectedState();
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"{0}:isEnabled()", (Object[])new Object[]{enabled});
        return enabled;
    }
}

