/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.controllers.ServiceExportController;
import com.ibm.zosconnect.ui.service.dialogs.ExportServiceDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportServiceHandler
implements IHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5655-CE3 (c) Copyright IBM Corp. 2015, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWorkbenchPartSite site = part.getSite();
        ISelectionProvider selProvider = site.getSelectionProvider();
        ISelection selection = selProvider.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection treeSel = (TreeSelection)selection;
            TreePath[] paths = treeSel.getPaths();
            TreePath path = paths[0];
            Object lastSeg = path.getLastSegment();
            IProject project = null;
            while (path != null) {
                if (lastSeg instanceof IProject) {
                    project = (IProject)lastSeg;
                    break;
                }
                path = path.getParentPath();
                lastSeg = path.getLastSegment();
            }
            this.displayExportServiceDialog(project);
        }
        return null;
    }

    public void displayExportServiceDialog(IProject project) {
        if (project != null) {
            try {
                if (!ExportServiceHandler.checkExportDirtyProject(project)) {
                    return;
                }
                WorkspaceUtil.clearServiceDeployProblemMarkers((IResource)project);
                if (project.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2) < 2) {
                    ServiceExportController controller = new ServiceExportController(project);
                    ExportServiceDialog dialog = new ExportServiceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), controller);
                    dialog.open();
                    try {
                        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
                    }
                } else {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Xlat.label((String)"EXPRT_SERVICE_DLG_ERROR_TITLE"), (String)Xlat.error((String)"EXPORT_SERVICE_ERRORS_ON_PROJECT", (String[])new String[]{project.getName(), Xlat.label((String)"EDITOR_SERVICE_PROJECT_EDITOR")}));
                }
            }
            catch (CoreException e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
                ZCeeErrorDialog.openError((Exception)((Object)e));
            }
        }
    }

    public boolean isEnabled() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        IStructuredSelection selection = (IStructuredSelection)selectionService.getSelection();
        int numApis = selection.toList().size();
        return numApis == 1;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    public static boolean checkExportDirtyProject(IProject project) throws CoreException {
        boolean checkExport = true;
        if (WorkspaceUtil.isProjectDirty((IProject)project)) {
            MessageDialog dialog = new MessageDialog(XSwt.getActiveShell(), Xlat.label((String)"EXPRT_SERVICE_DLG_ERROR_TITLE"), MessageDialog.getDefaultImage(), Xlat.error((String)"EXPORT_CONFIRM_SERVICE_DIRTY", (String[])new String[]{project.getName()}), 4, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
            checkExport = dialog.open() == 0;
        }
        return checkExport;
    }
}

