/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.jobs;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.connections.AdminApiConnectionUtil;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectService;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceDetail;
import com.ibm.zosconnect.ui.connections.utils.ZCeeAdminApiUtils;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServiceNode;
import com.ibm.zosconnect.ui.model.ZosConnectServicesFolder;
import com.ibm.zosconnect.ui.model.ZosConnectTreeObject;
import com.ibm.zosconnect.ui.model.ZosConnectTreeParent;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.jobs.ServicesJob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class RefreshServicesJob
extends ServicesJob {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = RefreshServicesJob.class.getName();
    private static final HashSet<String> providerPrivateServiceNames = ServiceExtension.getAllProviderPrivateServiceNames();
    private ZosConnectServerNode server;
    private List<ZosConnectTreeObject> serviceNodes;
    private boolean addedServicesFolder = false;
    private ZosConnectServicesFolder servicesFolder;

    public RefreshServicesJob(ZosConnectServerNode server) {
        super(server, Xlat.description((String)"STATUS_REFRESHING_SERVICES", (String[])new String[]{AdminApiConnectionUtil.getServerNameWithHostAndPort((ConnectionProfile)server.getConnectionProfile())}));
        this.server = server;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block29: {
            block28: {
                IZCeeAdminApiConnection connection;
                block27: {
                    ZCeeUILogger.entering((String)TAG, (String)"run(IProgressMonitor)", (Object[])new Object[0]);
                    ConnectionProfile profile = this.server.getConnectionProfile();
                    connection = ZCeeAdminApiUtils.getConnection((ConnectionProfile)profile, (boolean)false);
                    if (connection == null || !connection.isConnected()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.addedServicesFolder = false;
                    this.servicesFolder = null;
                    if (this.server.acquireLock(TAG)) break block27;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    try {
                        if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                            this.servicesFolder.setChildren(this.serviceNodes);
                            this.servicesFolder.setRefreshing(false);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ZosConnectServerNav nav = ZosConnectServerNav.getView();
                                    if (nav != null) {
                                        nav.refreshServerViewNested((ZosConnectTreeParent)RefreshServicesJob.this.servicesFolder);
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
                    }
                    this.server.releaseLock(TAG);
                    monitor.done();
                    return iStatus;
                }
                try {
                    try {
                        monitor.worked(50);
                        this.servicesFolder = (ZosConnectServicesFolder)ArrayUtilz.getFirstElementOfType((Object[])this.server.getChildren(), ZosConnectServicesFolder.class);
                        if (this.servicesFolder == null) {
                            this.servicesFolder = new ZosConnectServicesFolder((ZosConnectTreeParent)this.server);
                            this.server.addChild((ZosConnectTreeObject)this.servicesFolder);
                            this.addedServicesFolder = true;
                        }
                        this.servicesFolder.setRefreshing(true);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZosConnectServerNav nav = ZosConnectServerNav.getView();
                                if (nav != null) {
                                    if (RefreshServicesJob.this.addedServicesFolder) {
                                        nav.refreshServerView(RefreshServicesJob.this.server);
                                    } else {
                                        nav.refreshServerViewNested((ZosConnectTreeParent)RefreshServicesJob.this.servicesFolder);
                                    }
                                }
                            }
                        });
                        List serviceList = connection.getServicesWithDetails();
                        if (serviceList != null && !serviceList.isEmpty()) {
                            this.serviceNodes = new ArrayList<ZosConnectTreeObject>(Math.max(10, serviceList.size()));
                            for (Pair servicePair : serviceList) {
                                ZosConnectService service = (ZosConnectService)servicePair.getLeft();
                                if (providerPrivateServiceNames.contains(service.getServiceName())) {
                                    ZCeeUILogger.info((String)"Excluding private service \"{0}\"", (Object[])new Object[]{service.getServiceName()});
                                    continue;
                                }
                                ZosConnectServiceDetail serviceDetail = (ZosConnectServiceDetail)servicePair.getRight();
                                ZosConnectServiceNode serviceNode = new ZosConnectServiceNode(service.getServiceName(), (ZosConnectTreeParent)this.servicesFolder);
                                serviceNode.setName(service.getServiceName());
                                serviceNode.setService(service);
                                serviceNode.setServiceDetail(serviceDetail);
                                serviceNode.setParent((ZosConnectTreeParent)this.servicesFolder);
                                this.serviceNodes.add((ZosConnectTreeObject)serviceNode);
                            }
                        } else {
                            this.serviceNodes = new ArrayList<ZosConnectTreeObject>();
                        }
                        break block28;
                    }
                    catch (Exception e) {
                        this.setException(e);
                        this.servicesFolder.removeChildren();
                        if (e instanceof ZosConnectUIException && ((ZosConnectUIException)((Object)e)).isCausedByConnectivityException()) {
                            AdminApiConnectionUtil.doDisconnect((ConnectionProfile)this.server.getConnectionProfile());
                        }
                        try {
                            for (Job activeJob : this.getJobGroup().getActiveJobs()) {
                                if (!activeJob.belongsTo((Object)TAG)) continue;
                                activeJob.cancel();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ZCeeUILogger.error((Throwable)e);
                    ZCeeErrorDialog.openError((Exception)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                            this.servicesFolder.setChildren(this.serviceNodes);
                            this.servicesFolder.setRefreshing(false);
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    catch (Throwable t) {
                        ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
                    }
                    this.server.releaseLock(TAG);
                    monitor.done();
                    throw throwable;
                }
                try {
                    if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                        this.servicesFolder.setChildren(this.serviceNodes);
                        this.servicesFolder.setRefreshing(false);
                        Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                catch (Throwable t) {
                    ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
                }
                this.server.releaseLock(TAG);
                monitor.done();
                break block29;
            }
            try {
                if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                    this.servicesFolder.setChildren(this.serviceNodes);
                    this.servicesFolder.setRefreshing(false);
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Throwable t) {
                ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
            }
            this.server.releaseLock(TAG);
            monitor.done();
        }
        ZCeeUILogger.exiting((String)TAG, (String)"run(IProgressMonitor)", (Object[])new Object[0]);
        return Status.OK_STATUS;
    }

    @Override
    public String getFamily() {
        return TAG;
    }
}

