/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.jobs;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import com.ibm.zosconnect.ui.common.projects.ZCeeProjectConstants;
import com.ibm.zosconnect.ui.common.util.FileUtilz;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceStatus;
import com.ibm.zosconnect.ui.connections.utils.ZCeeAdminApiUtils;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.service.controllers.ServiceDeployController;
import com.ibm.zosconnect.ui.service.controllers.ServiceExportController;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.dialogs.DeployServiceResultDialog;
import com.ibm.zosconnect.ui.service.jobs.RefreshServicesJob;
import com.ibm.zosconnect.ui.service.jobs.ServicesJob;
import com.ibm.zosconnect.ui.service.model.DeployServiceResult;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class DeployServicesJob
extends ServicesJob {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = DeployServicesJob.class.getName();
    private ZosConnectPreferencesWrapper preferences = new ZosConnectPreferencesWrapper();
    private List<IProject> projects;
    private IZCeeAdminApiConnection connection;
    private ServiceDeployController controller;
    private final String sarFileExt = ".sar";
    private ZosConnectServerNode server;

    public DeployServicesJob(ZosConnectServerNode server, List<IProject> projects, IZCeeAdminApiConnection connection, ServiceDeployController controller) {
        super(server, Xlat.label((String)"DEPLOY_SERVICE_PROGRESS_TITLE"));
        this.server = server;
        this.projects = projects;
        this.connection = connection;
        this.controller = controller;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        ZCeeUILogger.entering((String)DeployServicesJob.TAG, (String)"run(monitor={0})", (Object[])new Object[]{monitor});
        deployResults = new Vector<DeployServiceResult>();
        serviceModelControllersMap = this.controller.getServiceModelControllersMap();
        configuration = this.connection.getConfiguration();
        try {
            monitor.beginTask(Xlat.label((String)"DEPLOY_SERVICE_PROGRESS_TASK", (String[])new String[]{ZCeeAdminApiUtils.getServerNameWithHostAndPort((ConnectionConfiguration)configuration)}), this.projects.size() * 2);
            i = 0;
            if (true) ** GOTO lbl81
        }
        catch (Exception e) {
            this.setException(e);
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
            v0 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
            if (!securityError) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RefreshServicesJob refreshservices = new RefreshServicesJob(DeployServicesJob.this.server);
                        refreshservices.setJobGroup(DeployServicesJob.this.getJobGroup());
                        refreshservices.schedule();
                    }
                });
            } else {
                ZCeeUILogger.info((String)"skipped refreshing services due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
            }
            monitor.done();
        }
        catch (Throwable var16_23) {
            v1 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
            if (!securityError) {
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            } else {
                ZCeeUILogger.info((String)"skipped refreshing services due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
            }
            monitor.done();
            throw var16_23;
        }
lbl32:
        // 1 sources

        while (true) {
            v2 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
            if (!securityError) {
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            } else {
                ZCeeUILogger.info((String)"skipped refreshing services due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
            }
            monitor.done();
            return var17_18;
        }
        {
            block21: {
                do {
                    proj = this.projects.get(i);
                    monitor.subTask(Xlat.label((String)"DEPLOY_SERVICE_PROGRESS_SUBTASK", (String[])new String[]{"\"" + proj.getName() + "\"" + Xlat.colon(), Integer.toString(i + 1), Integer.toString(this.projects.size())}));
                    WorkspaceUtil.clearServiceDeployProblemMarkers((IResource)proj);
                    outTempFile = FileUtilz.getTempFile((String)".sar");
                    outFileName = outTempFile.getAbsolutePath();
                    serviceModelController = (ServiceModelController)serviceModelControllersMap.get(proj.getName());
                    serviceExportController = new ServiceExportController(proj);
                    serviceExportController.setOutputFileName(outFileName);
                    serviceExportController.createZipFile();
                    serviceArchiveBytes = serviceExportController.getZipFileBytes();
                    outTempFile.delete();
                    monitor.worked(1);
                    serviceDetail = null;
                    uiException = null;
                    try {
                        exists = (Boolean)proj.getSessionProperty(ZCeeProjectConstants.PROP_SERVICE_EXISTS_ON_SERVER);
                        serviceName = serviceModelController.getServiceName();
                        if (exists.booleanValue()) {
                            if (this.preferences.getStopServiceOnUpdate()) {
                                this.connection.stopService(serviceName);
                            }
                            serviceDetail = this.preferences.getDeployServiceStarted() ? this.connection.updateService(serviceName, serviceArchiveBytes, ZosConnectServiceStatus.STARTED) : this.connection.updateService(serviceName, serviceArchiveBytes, ZosConnectServiceStatus.STOPPED);
                        } else {
                            serviceDetail = this.preferences.getDeployServiceStarted() ? this.connection.createService(serviceArchiveBytes, ZosConnectServiceStatus.STARTED) : this.connection.createService(serviceArchiveBytes, ZosConnectServiceStatus.STOPPED);
                        }
                    }
                    catch (ZosConnectUIException e) {
                        ZCeeUILogger.error((Throwable)e);
                        WorkspaceUtil.addServiceDeployProblemMarker((IResource)proj, (ZosConnectUIException)e);
                        uiException = e;
                        this.setException((Exception)uiException);
                    }
                    deployResults.add(new DeployServiceResult(serviceModelController.getServiceName(), serviceModelController.getServiceVersion(), serviceModelController.getServiceTypeLabel(), serviceDetail, uiException));
                    monitor.worked(1);
                    if (uiException != null && uiException.isCausedBySecurityException()) break block21;
                    ++i;
lbl81:
                    // 2 sources

                    if (i >= this.projects.size()) break block21;
                } while (!monitor.isCanceled());
                var17_18 = Status.CANCEL_STATUS;
                ** continue;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DeployServiceResultDialog dialog = new DeployServiceResultDialog(deployResults, XSwt.getActiveShell(), DeployServicesJob.this.connection);
                    dialog.open();
                }
            });
        }
        v3 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
        if (!securityError) {
            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
        } else {
            ZCeeUILogger.info((String)"skipped refreshing services due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
        }
        monitor.done();
        ZCeeUILogger.exiting((String)DeployServicesJob.TAG, (String)"run(IProgressMonitor)", (Object[])new Object[0]);
        return Status.OK_STATUS;
    }

    @Override
    public String getFamily() {
        return TAG;
    }
}

