/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.editors.listeners;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ServiceProjectNature;
import com.ibm.zosconnect.ui.common.util.Xlat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ServiceProjectImportListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void resourceChanged(IResourceChangeEvent changeEvent) {
        if (changeEvent.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = changeEvent.getDelta();
        if (rootDelta.getKind() != 4) {
            return;
        }
        try {
            rootDelta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        try {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject currProject;
                IResourceDelta currDelta = iResourceDeltaArray[n2];
                IResource currResource = currDelta.getResource();
                if (currResource instanceof IProject && currDelta.getKind() == 1 && ServiceProjectNature.hasNature((IProject)(currProject = (IProject)currResource))) {
                    new WorkspaceJob(Xlat.description((String)"STATUS_UPDATING_SERVICE_PROJECT", (String[])new String[]{currProject.getName()})){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            try {
                                currProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                currProject.build(6, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                ZCeeUILogger.error((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        return true;
    }
}

