/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.editors;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceProjectController;
import com.ibm.zosconnect.ui.service.editors.ServiceProjectEditor;
import com.ibm.zosconnect.ui.service.editors.listeners.IServiceEditorListener;
import com.ibm.zosconnect.ui.service.interfaces.IServiceOverviewComposite;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectValidator;
import com.ibm.zosconnect.ui.service.menu.handlers.DeployServiceHandler;
import com.ibm.zosconnect.ui.service.menu.handlers.ExportServiceHandler;
import com.ibm.zosconnect.ui.service.validation.ServiceProjectValidator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;

public class ServiceProjectEditorOverviewPage
extends FormPage
implements IServiceEditorListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String c = this.getClass().getName();
    private ScrolledForm scrolledForm;
    private Composite mainComposite;
    private IMessageManager messageMgr;
    private Text txtVersion;
    private Text txtDescription;
    private Label lblType;
    private Section sctnAction;
    private Label lblInstructions;
    private Composite compositeGeneral;
    private Label lblCreateServiceProjectActions;
    private Section sctnGeneralInfo;
    private boolean dirty;
    private boolean saving;
    private boolean loading;
    private IServiceOverviewComposite extenderServiceOveriewCompositeImpl;

    public ServiceProjectEditorOverviewPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.getServiceProjectEditor().getEditorSaveListeners().add(this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(Xlat.label((String)"SERVICE_PROJECT_EDITOR_TITLE") + Xlat.colon() + " " + this.getTitle());
        this.scrolledForm.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                XSwt.reflow((ScrolledForm)ServiceProjectEditorOverviewPage.this.scrolledForm);
            }

            public void controlMoved(ControlEvent arg0) {
                XSwt.reflow((ScrolledForm)ServiceProjectEditorOverviewPage.this.scrolledForm);
            }
        });
        this.scrolledForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
            }
        });
        IToolBarManager toolbarMgr = this.scrolledForm.getToolBarManager();
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"SERVICEEDIT_ACTION_DEPLOY_SERVICE"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/deploy_service_16.gif")){

            public void run() {
                DeployServiceHandler deployHandler = new DeployServiceHandler();
                deployHandler.displayDeployServiceDialog(ServiceProjectEditorOverviewPage.this.getProject());
            }
        });
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"EXPRT_SERVICE_DLG_TITLE"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/zosconnectee_export_aar_16.png")){

            public void run() {
                ExportServiceHandler exportHandler = new ExportServiceHandler();
                exportHandler.displayExportServiceDialog(ServiceProjectEditorOverviewPage.this.getProject());
            }
        });
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"HELP"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/xx_help16.gif")){

            public void run() {
                String extensionHelpContentId = ServiceProjectEditorOverviewPage.this.getServiceModelController().getServiceExtension().getHelpContextId();
                if (extensionHelpContentId == null || extensionHelpContentId.isEmpty()) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.zosconnect.ui.service.createservice");
                } else {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp(extensionHelpContentId);
                }
            }
        });
        toolbarMgr.update(true);
        this.scrolledForm.setAlwaysShowScrollBars(true);
        this.messageMgr = this.scrolledForm.getMessageManager();
        this.messageMgr.setAutoUpdate(true);
        this.messageMgr.removeAllMessages();
        Composite body = this.scrolledForm.getBody();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        toolkit.paintBordersFor(body);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        managedForm.getForm().getBody().setLayout((Layout)gridLayout);
        this.mainComposite = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
        GridLayout gl_compMain = new GridLayout(2, false);
        gl_compMain.marginWidth = 0;
        gl_compMain.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gl_compMain);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        managedForm.getToolkit().paintBordersFor(this.mainComposite);
        this.sctnGeneralInfo = managedForm.getToolkit().createSection(this.mainComposite, 258);
        GridData gd_sctnGeneralInfo = new GridData(-1, 4, false, false, 1, 1);
        gd_sctnGeneralInfo.verticalIndent = 10;
        this.sctnGeneralInfo.setLayoutData((Object)gd_sctnGeneralInfo);
        managedForm.getToolkit().paintBordersFor((Composite)this.sctnGeneralInfo);
        this.sctnGeneralInfo.setText(Xlat.label((String)"SERVICEEDIT_SECTION_GENERAL_INFO"));
        this.sctnGeneralInfo.setExpanded(true);
        this.compositeGeneral = managedForm.getToolkit().createComposite((Composite)this.sctnGeneralInfo, 0);
        managedForm.getToolkit().paintBordersFor(this.compositeGeneral);
        this.sctnGeneralInfo.setClient((Control)this.compositeGeneral);
        this.compositeGeneral.setLayout((Layout)new GridLayout(2, false));
        this.lblInstructions = managedForm.getToolkit().createLabel(this.compositeGeneral, Xlat.label((String)"SERVICEEDIT_GENERAL_INSTRUCTIONS"), 64);
        GridData gd_lblInstructions = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_lblInstructions.widthHint = 251;
        gd_lblInstructions.heightHint = 30;
        this.lblInstructions.setLayoutData((Object)gd_lblInstructions);
        managedForm.getToolkit().createLabel(this.compositeGeneral, Xlat.label((String)"SERVICEEDIT_LABEL_TYPE") + Xlat.colon(), 0);
        this.lblType = managedForm.getToolkit().createLabel(this.compositeGeneral, this.getServiceModelController().getServiceTypeLabel(), 0);
        managedForm.getToolkit().createLabel(this.compositeGeneral, Xlat.label((String)"SERVICEEDIT_LABEL_VERSION") + Xlat.colon(), 0);
        this.txtVersion = managedForm.getToolkit().createText(this.compositeGeneral, "", 0);
        GridData gd_txtVersion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtVersion.widthHint = 150;
        this.txtVersion.setLayoutData((Object)gd_txtVersion);
        this.txtVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ServiceProjectEditorOverviewPage.this.getServiceModelController().setServiceVersion(ServiceProjectEditorOverviewPage.this.txtVersion.getText());
                ServiceProjectValidationError errorValidation = ServiceProjectEditorOverviewPage.this.getProjectValidator().validateServiceVersion(ServiceProjectEditorOverviewPage.this.txtVersion.getText());
                String key = "version";
                if (errorValidation != null) {
                    ServiceProjectEditorOverviewPage.this.getProjectValidator().setControlToError(ServiceProjectEditorOverviewPage.this.messageMgr, key, errorValidation, (Control)ServiceProjectEditorOverviewPage.this.txtVersion);
                } else {
                    ServiceProjectEditorOverviewPage.this.getProjectValidator().resetControlToError(ServiceProjectEditorOverviewPage.this.messageMgr, key, (Control)ServiceProjectEditorOverviewPage.this.txtVersion);
                }
                ServiceProjectEditorOverviewPage.this.setDirty(true);
            }
        });
        this.txtVersion.setToolTipText(Xlat.label((String)"SERVICEEDIT_VERSION_TOOLTIP"));
        Label lblDescription = managedForm.getToolkit().createLabel(this.compositeGeneral, Xlat.label((String)"SERVICEEDIT_LABEL_DESCRIPTION") + Xlat.colon(), 0);
        GridData gd_lblDescription = new GridData(16384, 128, false, false, 1, 1);
        lblDescription.setLayoutData((Object)gd_lblDescription);
        this.txtDescription = managedForm.getToolkit().createText(this.compositeGeneral, "", 578);
        GridData gd_txtDescription = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtDescription.widthHint = XSwt.getAverageCharWidth((Control)this.txtDescription) * 60;
        gd_txtDescription.heightHint = XSwt.getFontHeight((Control)this.txtDescription) * 4;
        this.txtDescription.setLayoutData((Object)gd_txtDescription);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ServiceProjectEditorOverviewPage.this.getServiceModelController().setServiceDescription(ServiceProjectEditorOverviewPage.this.txtDescription.getText());
                ServiceProjectValidationError errorValidation = ServiceProjectEditorOverviewPage.this.getProjectValidator().validateServiceDescription(ServiceProjectEditorOverviewPage.this.txtDescription.getText());
                String key = "description";
                if (errorValidation != null) {
                    ServiceProjectEditorOverviewPage.this.getProjectValidator().setControlToError(ServiceProjectEditorOverviewPage.this.messageMgr, key, errorValidation, (Control)ServiceProjectEditorOverviewPage.this.txtDescription);
                } else {
                    ServiceProjectEditorOverviewPage.this.getProjectValidator().resetControlToError(ServiceProjectEditorOverviewPage.this.messageMgr, key, (Control)ServiceProjectEditorOverviewPage.this.txtDescription);
                }
                ServiceProjectEditorOverviewPage.this.setDirty(true);
            }
        });
        this.txtDescription.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.sctnAction = managedForm.getToolkit().createSection(this.mainComposite, 258);
        GridData gd_sctnAction = new GridData(16384, 4, false, false, 1, 1);
        gd_sctnAction.horizontalIndent = 10;
        gd_sctnAction.verticalIndent = 10;
        this.sctnAction.setLayoutData((Object)gd_sctnAction);
        managedForm.getToolkit().paintBordersFor((Composite)this.sctnAction);
        this.sctnAction.setText(Xlat.label((String)"SERVICEEDIT_SECTION_ACTIONS"));
        this.sctnAction.setExpanded(true);
        Composite composite_3 = managedForm.getToolkit().createComposite((Composite)this.sctnAction, 0);
        managedForm.getToolkit().paintBordersFor(composite_3);
        this.sctnAction.setClient((Control)composite_3);
        composite_3.setLayout((Layout)new GridLayout(1, false));
        this.lblCreateServiceProjectActions = managedForm.getToolkit().createLabel(composite_3, Xlat.label((String)"SERVICEEDIT_ACTIONS_INSTRUCTIONS"), 0);
        this.lblCreateServiceProjectActions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label action = managedForm.getToolkit().createLabel(composite_3, "1. " + Xlat.label((String)"SERVICEEDIT_ACTIONS_INSTRUCTION_VERSION"), 64);
        action.setLayoutData((Object)new GridData(0, 0, true, false));
        int actionCount = 2;
        this.extenderServiceOveriewCompositeImpl = null;
        try {
            Object executableExtension = this.getServiceModelController().getServiceExtension().getCompositeClass();
            if (executableExtension != null && executableExtension instanceof IServiceOverviewComposite) {
                this.extenderServiceOveriewCompositeImpl = (IServiceOverviewComposite)executableExtension;
                List<String> customActions = this.extenderServiceOveriewCompositeImpl.getCustomActions();
                for (String label : customActions) {
                    action = managedForm.getToolkit().createLabel(composite_3, actionCount + ". " + label, 64);
                    action.setLayoutData((Object)new GridData(0, 0, true, false));
                    ++actionCount;
                }
            } else {
                ZCeeUILogger.info((String)"Composite class provided by extension is null or not an instance of IServiceOverviewComposite", (Object[])new Object[0]);
            }
        }
        catch (CoreException ce) {
            ZCeeUILogger.error((Throwable)ce);
            ZCeeErrorDialog.openError((Exception)((Object)ce));
        }
        Hyperlink link4 = managedForm.getToolkit().createHyperlink(composite_3, actionCount + ". " + Xlat.label((String)"SERVICEEDIT_ACTIONS_INSTRUCTION_CONFIGURATION"), 64);
        link4.setLayoutData((Object)new GridData(0, 0, true, false));
        link4.setToolTipText(Xlat.label((String)"SERVICEEDIT_ACTIONS_TOOLTIP_CONFIGURATION"));
        Hyperlink link5 = managedForm.getToolkit().createHyperlink(composite_3, ++actionCount + ". " + Xlat.label((String)"SERVICEEDIT_ACTIONS_INSTRUCTION_DEPLOY"), 64);
        link5.setLayoutData((Object)new GridData(0, 0, true, false));
        link5.setToolTipText(Xlat.label((String)"SERVICEEDIT_ACTIONS_TOOLTIP_DEPLOY"));
        Hyperlink link6 = managedForm.getToolkit().createHyperlink(composite_3, ++actionCount + ". " + Xlat.label((String)"SERVICEEDIT_ACTIONS_INSTRUCTION_EXPORT"), 64);
        link6.setLayoutData((Object)new GridData(0, 0, true, false));
        link6.setToolTipText(Xlat.label((String)"SERVICEEDIT_ACTIONS_TOOLTIP_EXPORT"));
        link4.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ServiceProjectEditorOverviewPage.this.getEditor().setActivePage("ZosConnectServiceEditorPropertiesPage");
            }
        });
        link5.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                DeployServiceHandler deployHandler = new DeployServiceHandler();
                deployHandler.displayDeployServiceDialog(ServiceProjectEditorOverviewPage.this.getProject());
            }
        });
        link6.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                ExportServiceHandler exportHandler = new ExportServiceHandler();
                exportHandler.displayExportServiceDialog(ServiceProjectEditorOverviewPage.this.getProject());
            }
        });
        this.createExtenderFormContent(managedForm.getToolkit());
        String extensionHelpContentId = this.getServiceModelController().getServiceExtension().getHelpContextId();
        if (extensionHelpContentId == null || extensionHelpContentId.isEmpty()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.scrolledForm, "com.ibm.zosconnect.ui.service.createservice");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.scrolledForm, extensionHelpContentId);
        }
        this.getEditorSite().setSelectionProvider(this.getEditor().getEditorSite().getSelectionProvider());
        this.refreshPageFromModel();
    }

    private void createExtenderFormContent(FormToolkit formToolkit) {
        String methodName = "createExtenderFormContent";
        ZCeeUILogger.entering((String)this.c, (String)"createExtenderFormContent", (Object[])new Object[0]);
        if (this.extenderServiceOveriewCompositeImpl != null) {
            Composite extenderParentComposite = formToolkit.createComposite(this.mainComposite, 0);
            GridData gd_extenderParentComposite = new GridData(4, 4, false, false, 2, 1);
            extenderParentComposite.setLayoutData((Object)gd_extenderParentComposite);
            extenderParentComposite.setLayout((Layout)new GridLayout());
            LinkedHashMap<Composite, String> extenderComposites = this.extenderServiceOveriewCompositeImpl.getComposites(formToolkit, extenderParentComposite, this.getServiceProjectEditor());
            if (extenderComposites != null) {
                for (Map.Entry<Composite, String> entry : extenderComposites.entrySet()) {
                    Section newSection = formToolkit.createSection(extenderParentComposite, 258);
                    GridData gd_extSection = new GridData(4, 4, true, false, 2, 1);
                    gd_extSection.verticalIndent = 10;
                    newSection.setLayoutData((Object)gd_extSection);
                    formToolkit.paintBordersFor((Composite)newSection);
                    newSection.setText(entry.getValue());
                    newSection.setExpanded(true);
                    Composite extenderComposite = entry.getKey();
                    extenderComposite.setParent((Composite)newSection);
                    newSection.setClient((Control)extenderComposite);
                    formToolkit.paintBordersFor(extenderParentComposite);
                }
            } else {
                ZCeeUILogger.info((String)"No extender composites provided by extension.", (Object[])new Object[0]);
            }
        }
        ZCeeUILogger.exiting((String)this.c, (String)"createExtenderFormContent", (Object[])new Object[0]);
    }

    @Override
    public void refreshPageFromModel() {
        if (this.saving) {
            this.saving = false;
            return;
        }
        if (this.lblType != null) {
            this.loading = true;
            XSwt.setText((Text)this.txtVersion, (String)this.getServiceModelController().getServiceVersion());
            XSwt.setText((Text)this.txtDescription, (String)this.getServiceModelController().getServiceDescription());
            this.extenderServiceOveriewCompositeImpl.refreshPage(this.getServiceModelController().getProperties());
        }
        this.loading = false;
    }

    public ServiceProjectEditor getServiceProjectEditor() {
        ServiceProjectEditor retVal = null;
        FormEditor editor = this.getEditor();
        if (editor instanceof ServiceProjectEditor) {
            retVal = (ServiceProjectEditor)editor;
        }
        return retVal;
    }

    private IServiceProjectController getServiceProjectController() {
        return this.getServiceProjectEditor().getServiceProjectController();
    }

    public void launchPgmInterfaceEditor(IFile msgFile) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(msgFile), "com.ibm.zosconnect.editors.programinterface");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (!this.loading) {
            this.dirty = dirty;
            if (dirty) {
                this.firePropertyChange(257);
            }
            this.getServiceProjectEditor().editorDirtyStateChanged();
        }
    }

    @Override
    public void beforeSave(ServiceProjectEditor editor) {
    }

    @Override
    public void save(ServiceProjectEditor editor) {
        this.saving = true;
        this.getServiceModelController().savePropertiesAndRefreshProjectExplorer();
        this.dirty = false;
    }

    public IProject getProject() {
        return this.getServiceProjectController().getProject();
    }

    public ServiceProjectValidator getProjectValidator() {
        IServiceProjectValidator ispv = this.getServiceProjectEditor().getServiceProjectValidator();
        return (ServiceProjectValidator)ispv;
    }

    public IMessageManager getMessageManager() {
        return this.messageMgr;
    }

    public void setLoading(boolean isLoading) {
        this.loading = isLoading;
    }

    public boolean isLoading() {
        return this.loading;
    }

    private ServiceModelController getServiceModelController() {
        return (ServiceModelController)this.getServiceProjectController().getServiceModel();
    }
}

