/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.editors;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.EditServiceController;
import com.ibm.zosconnect.ui.service.controllers.exceptions.ServiceTypeExtensionException;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.editors.CsvListWidget;
import com.ibm.zosconnect.ui.service.editors.ServiceProjectEditor;
import com.ibm.zosconnect.ui.service.editors.listeners.IServiceEditorListener;
import com.ibm.zosconnect.ui.service.menu.handlers.DeployServiceHandler;
import com.ibm.zosconnect.ui.service.menu.handlers.ExportServiceHandler;
import com.ibm.zosconnect.ui.service.validation.ServiceProjectValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ServiceProjectEditorConfigurationPage
extends FormPage
implements IServiceEditorListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ScrolledForm scrolledForm;
    private Composite mainComposite;
    private IMessageManager messageMgr;
    private EditServiceController esController;
    private IProject project;
    private ServiceProjectValidator serviceProjectValidator = null;
    private boolean dirty;
    private boolean saving;
    private boolean loading;
    private Section requiredSection;
    private Section optionalSection;
    private Composite compositeRequired;
    private Composite compositeOptional;
    private Label lblRequiredInstructions;
    private Label lblOptionalInstructions;
    private HashMap<String, Widget> requiredConfigHandles = new HashMap();
    private HashMap<String, Widget> optionalConfigHandles = new HashMap();
    private HashMap<String, List<Widget>> dependsOnMap = new HashMap();
    private HashMap<String, Control> configurationControls = new HashMap();

    public ServiceProjectEditorConfigurationPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.esController = new EditServiceController(((ServiceProjectEditor)editor).getProjectName());
        this.getServiceProjectEditor().getEditorSaveListeners().add(this);
        this.project = this.getServiceProjectController().getProject();
        try {
            this.serviceProjectValidator = new ServiceProjectValidator(this.project, this.getServiceProjectController());
        }
        catch (CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(Xlat.label((String)"SERVICE_PROJECT_EDITOR_TITLE") + Xlat.colon() + " " + this.getTitle());
        this.scrolledForm.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                XSwt.reflow((ScrolledForm)ServiceProjectEditorConfigurationPage.this.scrolledForm);
            }

            public void controlMoved(ControlEvent arg0) {
                XSwt.reflow((ScrolledForm)ServiceProjectEditorConfigurationPage.this.scrolledForm);
            }
        });
        this.scrolledForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
            }
        });
        IToolBarManager toolbarMgr = this.scrolledForm.getToolBarManager();
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"SERVICEEDIT_ACTION_DEPLOY_SERVICE"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/deploy_service_16.gif")){

            public void run() {
                DeployServiceHandler deployHandler = new DeployServiceHandler();
                deployHandler.displayDeployServiceDialog(ServiceProjectEditorConfigurationPage.this.project);
            }
        });
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"EXPRT_SERVICE_DLG_TITLE"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/zosconnectee_export_aar_16.png")){

            public void run() {
                ExportServiceHandler exportHandler = new ExportServiceHandler();
                exportHandler.displayExportServiceDialog(ServiceProjectEditorConfigurationPage.this.project);
            }
        });
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"HELP"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/xx_help16.gif")){

            public void run() {
                String extensionHelpContentId = ServiceProjectEditorConfigurationPage.this.getServiceExtension().getHelpContextId();
                if (extensionHelpContentId == null || extensionHelpContentId.isEmpty()) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.zosconnect.ui.service.serviceproperties");
                } else {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp(extensionHelpContentId);
                }
            }
        });
        toolbarMgr.update(true);
        this.scrolledForm.setAlwaysShowScrollBars(true);
        this.messageMgr = this.scrolledForm.getMessageManager();
        this.messageMgr.setAutoUpdate(true);
        this.messageMgr.removeAllMessages();
        Composite body = this.scrolledForm.getBody();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        toolkit.paintBordersFor(body);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 10;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        managedForm.getForm().getBody().setLayout((Layout)gridLayout);
        this.mainComposite = managedForm.getToolkit().createComposite(managedForm.getForm().getBody(), 0);
        GridLayout gl_compMain = new GridLayout(1, true);
        gl_compMain.marginWidth = 0;
        gl_compMain.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gl_compMain);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        managedForm.getToolkit().paintBordersFor(this.mainComposite);
        this.requiredSection = managedForm.getToolkit().createSection(this.mainComposite, 322);
        managedForm.getToolkit().paintBordersFor((Composite)this.requiredSection);
        this.requiredSection.setText(Xlat.label((String)"SERVICEEDIT_REQUIRED_INFO"));
        this.compositeRequired = managedForm.getToolkit().createComposite((Composite)this.requiredSection, 0);
        this.requiredSection.setClient((Control)this.compositeRequired);
        this.compositeRequired.setLayout((Layout)new GridLayout(2, true));
        this.lblRequiredInstructions = managedForm.getToolkit().createLabel(this.compositeRequired, Xlat.label((String)"SERVICEEDIT_REQUIRED_INSTRUCTIONS"), 64);
        GridData gd_requiredInstructions = new GridData(4, 4, true, false, 2, 1);
        gd_requiredInstructions.widthHint = 600;
        this.lblRequiredInstructions.setLayoutData((Object)gd_requiredInstructions);
        managedForm.getToolkit().adapt(this.compositeRequired);
        this.createExtensionProvidedUIContent(managedForm, this.compositeRequired, true);
        if (this.serviceTypeHasOptionalConfiguration()) {
            this.optionalSection = managedForm.getToolkit().createSection(this.mainComposite, 322);
            managedForm.getToolkit().paintBordersFor((Composite)this.optionalSection);
            this.optionalSection.setText(Xlat.label((String)"SERVICEEDIT_OPTIONAL_INFO"));
            this.compositeOptional = managedForm.getToolkit().createComposite((Composite)this.optionalSection, 0);
            this.optionalSection.setClient((Control)this.compositeOptional);
            this.compositeOptional.setLayout((Layout)new GridLayout(2, true));
            this.lblOptionalInstructions = managedForm.getToolkit().createLabel(this.compositeOptional, Xlat.label((String)"SERVICEEDIT_OPTIONAL_INSTRUCTIONS"), 64);
            GridData gd_optionalInstructions = new GridData(4, 4, true, false, 2, 1);
            gd_optionalInstructions.widthHint = 600;
            this.lblOptionalInstructions.setLayoutData((Object)gd_optionalInstructions);
            managedForm.getToolkit().adapt(this.compositeOptional);
            this.createExtensionProvidedUIContent(managedForm, this.compositeOptional, false);
        }
        this.refreshPageFromModel();
        String extensionHelpContentId = this.getServiceExtension().getHelpContextId();
        if (extensionHelpContentId == null || extensionHelpContentId.isEmpty()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.scrolledForm, "com.ibm.zosconnect.ui.service.serviceproperties");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.scrolledForm, extensionHelpContentId);
        }
    }

    @Override
    public void beforeSave(ServiceProjectEditor serviceProjectEditor) {
    }

    @Override
    public void refreshPageFromModel() {
        if (this.saving) {
            this.saving = false;
            return;
        }
        String methodName = "refreshPageFromModel";
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"refreshPageFromModel", (Object[])new Object[0]);
        this.refreshConfig(this.requiredConfigHandles);
        this.refreshConfig(this.optionalConfigHandles);
        this.refreshConfigEnabledDisabledState(this.requiredConfigHandles);
        this.refreshConfigEnabledDisabledState(this.optionalConfigHandles);
        this.setDirty(false);
        this.loading = false;
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"refreshPageFromModel", (Object[])new Object[0]);
    }

    @Override
    public void save(ServiceProjectEditor serviceProjectEditor) {
        this.saving = true;
        this.saveConfig(this.requiredConfigHandles);
        this.saveConfig(this.optionalConfigHandles);
        this.getServiceProjectController().getServiceModel().savePropertiesAndRefreshProjectExplorer();
        this.dirty = false;
    }

    public ServiceProjectEditor getServiceProjectEditor() {
        ServiceProjectEditor retVal = null;
        FormEditor editor = this.getEditor();
        if (editor instanceof ServiceProjectEditor) {
            retVal = (ServiceProjectEditor)editor;
        }
        return retVal;
    }

    private ServiceProjectController getServiceProjectController() {
        return (ServiceProjectController)this.getServiceProjectEditor().getServiceProjectController();
    }

    private ServiceExtension getServiceExtension() {
        return this.getServiceProjectController().getServiceModel().getServiceExtension();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (!this.loading) {
            this.dirty = dirty;
            if (dirty) {
                this.firePropertyChange(257);
            }
            this.getServiceProjectEditor().editorDirtyStateChanged();
        }
    }

    private boolean serviceTypeHasOptionalConfiguration() {
        String methodName = "serviceTypeHasOptionalConfiguration";
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"serviceTypeHasOptionalConfiguration", (Object[])new Object[0]);
        for (ServiceExtensionProperty sep : this.getServiceExtension().getProperties()) {
            if (sep.isRequired()) continue;
            ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"serviceTypeHasOptionalConfiguration", (Object[])new Object[]{true});
            return true;
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"serviceTypeHasOptionalConfiguration", (Object[])new Object[]{false});
        return false;
    }

    private void createExtensionProvidedUIContent(IManagedForm managedForm, Composite comp, boolean requiredProps) {
        String methodName = "createExtensionProvidedUIContent";
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"createExtensionProvidedUIContent", (Object[])new Object[]{requiredProps});
        ArrayList sortedList = new ArrayList(this.getServiceExtension().getProperties());
        Collections.sort(sortedList);
        for (final ServiceExtensionProperty sep : sortedList) {
            String tooltip;
            Object controlNew;
            if (sep.isRequired() != requiredProps) continue;
            Label lblNewLabel = new Label(comp, 0);
            GridData gd_lbl = new GridData(16384, 128, false, false, 1, 1);
            gd_lbl.heightHint = 25;
            lblNewLabel.setLayoutData((Object)gd_lbl);
            lblNewLabel.setText(sep.getPropertyLabel() + Xlat.colon());
            if (sep.getPropertyType().equalsIgnoreCase("boolean")) {
                Button btnNew;
                controlNew = btnNew = new Button(comp, 32);
                GridData gd_btn = new GridData(16384, 128, true, false, 1, 1);
                btnNew.setLayoutData((Object)gd_btn);
                btnNew.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        if (ServiceProjectEditorConfigurationPage.this.dependsOnMap.containsKey(sep.getPropertyName())) {
                            for (Widget anonWidget : ServiceProjectEditorConfigurationPage.this.dependsOnMap.get(sep.getPropertyName())) {
                                if (!(anonWidget instanceof Control)) continue;
                                Control value = (Control)anonWidget;
                                value.setEnabled(btnNew.getSelection());
                            }
                        }
                        ServiceProjectEditorConfigurationPage.this.setDirty(true);
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                if (requiredProps) {
                    this.addWidget(true, sep, (Widget)btnNew);
                } else {
                    this.addWidget(false, sep, (Widget)btnNew);
                }
            } else if (sep.getPropertyType().equalsIgnoreCase("stringcsv")) {
                CsvListWidget listNew = new CsvListWidget(comp, 0);
                controlNew = listNew;
                gd = new GridData(16384, 128, true, false, 1, 1);
                listNew.setLayoutData(gd);
                listNew.addControlListener(new ControlListener(){

                    public void controlResized(ControlEvent event) {
                        XSwt.reflow((ScrolledForm)ServiceProjectEditorConfigurationPage.this.scrolledForm);
                    }

                    public void controlMoved(ControlEvent event) {
                    }
                });
                listNew.addCsvChangedEventListener(new CsvListWidget.CsvChangedEventListener(){
                    private Map<Text, ServiceProjectValidationError> prevValidation = new HashMap<Text, ServiceProjectValidationError>();

                    @Override
                    public void listChanged(CsvListWidget.CsvListChangedEventObject event) {
                        Set<Text> allTexts = event.getAllTexts();
                        HashSet<String> allHeaders = new HashSet<String>();
                        HashSet<String> duplicateHeaders = new HashSet<String>();
                        for (Text currentText : allTexts) {
                            String header = CsvListWidget.quoteText(currentText.getText());
                            if (header.isEmpty()) continue;
                            if (allHeaders.contains(header)) {
                                duplicateHeaders.add(header);
                                continue;
                            }
                            allHeaders.add(header);
                        }
                        Job validationJob = Job.create((String)"Validate headers", monitor -> {
                            HashMap<String, ServiceProjectValidationError> validationResults = new HashMap<String, ServiceProjectValidationError>();
                            for (String header : allHeaders) {
                                ServiceProjectValidationError errorValidation = ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.validateServiceExtensionProperty(null, ServiceProjectEditorConfigurationPage.this.configurationControls, sep.getPropertyLabel(), header);
                                if (errorValidation != null) {
                                    if (duplicateHeaders.contains(header)) {
                                        errorValidation.setMessage(errorValidation.getMessage() + "\n" + Xlat.error((String)"DUPLICATE_VALUE"));
                                    }
                                } else if (duplicateHeaders.contains(header)) {
                                    errorValidation = new ServiceProjectValidationError(ServiceProjectEditorConfigurationPage.this.getServiceProjectController().getServiceModel().getResource(), "com.ibm.zosconnect.service.ui.propertiesproblem", Xlat.error((String)"DUPLICATE_VALUE"), null, null, Integer.valueOf(1));
                                }
                                validationResults.put(header, errorValidation);
                            }
                            Display.getDefault().asyncExec(() -> {
                                HashMap<Text, ServiceProjectValidationError> currentValidation = new HashMap<Text, ServiceProjectValidationError>();
                                for (Text currentText : allTexts) {
                                    if (currentText.isDisposed()) continue;
                                    String key = ServiceProjectEditorConfigurationPage.this.getServiceExtension().getPropertyByLabel(sep.getPropertyLabel()).getPropertyName();
                                    ServiceProjectValidationError errorValidation = (ServiceProjectValidationError)validationResults.get(CsvListWidget.quoteText(currentText.getText()));
                                    if (errorValidation != null) {
                                        ServiceProjectValidationError previousError = this.prevValidation.get(currentText);
                                        if (previousError == null || !previousError.getMessage().equals(errorValidation.getMessage())) {
                                            if (errorValidation.getSeverity() == 2) {
                                                ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.setControlToError(ServiceProjectEditorConfigurationPage.this.messageMgr, key, errorValidation, (Control)currentText);
                                            } else {
                                                ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.setControlToWarning(ServiceProjectEditorConfigurationPage.this.messageMgr, key, errorValidation, (Control)currentText);
                                            }
                                        }
                                    } else if (this.prevValidation.get(currentText) != null) {
                                        ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.resetControlToError(ServiceProjectEditorConfigurationPage.this.messageMgr, key, (Control)currentText);
                                    }
                                    currentValidation.put(currentText, errorValidation);
                                }
                                if (event.getDisposedText() != null) {
                                    ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.removeMessages(ServiceProjectEditorConfigurationPage.this.messageMgr, (Control)event.getDisposedText());
                                    ServiceProjectEditorConfigurationPage.this.messageMgr.update();
                                }
                                this.prevValidation = currentValidation;
                            });
                        });
                        validationJob.schedule();
                        ServiceProjectEditorConfigurationPage.this.setDirty(true);
                    }
                });
                if (requiredProps) {
                    this.addWidget(true, sep, (Widget)listNew);
                } else {
                    this.addWidget(false, sep, (Widget)listNew);
                }
            } else if (sep.getPropertyAcceptedValues().isEmpty()) {
                final Text textNew = new Text(comp, 2048);
                controlNew = textNew;
                gd = new GridData(16384, 128, true, false, 1, 1);
                gd.widthHint = 200;
                textNew.setLayoutData((Object)gd);
                this.configurationControls.put(sep.getPropertyName(), (Control)textNew);
                textNew.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent arg0) {
                        try {
                            ServiceProjectValidationError errorValidation = ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.validateServiceExtensionProperty(ServiceProjectEditorConfigurationPage.this.messageMgr, ServiceProjectEditorConfigurationPage.this.configurationControls, sep.getPropertyLabel(), textNew.getText());
                            String key = ServiceProjectEditorConfigurationPage.this.getServiceExtension().getPropertyByLabel(sep.getPropertyLabel()).getPropertyName();
                            if (errorValidation != null) {
                                ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.setControlToError(ServiceProjectEditorConfigurationPage.this.messageMgr, key, errorValidation, (Control)textNew);
                            } else {
                                ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.resetControlToError(ServiceProjectEditorConfigurationPage.this.messageMgr, key, (Control)textNew);
                            }
                        }
                        finally {
                            ServiceProjectEditorConfigurationPage.this.setDirty(true);
                        }
                    }
                });
                if (requiredProps) {
                    this.addWidget(true, sep, (Widget)textNew);
                } else {
                    this.addWidget(false, sep, (Widget)textNew);
                }
            } else {
                final Combo comboNew = new Combo(comp, 8);
                controlNew = comboNew;
                gd = new GridData(16384, 128, true, false, 1, 1);
                gd.widthHint = 200;
                comboNew.setLayoutData((Object)gd);
                if (!requiredProps) {
                    comboNew.add("");
                }
                for (String value : sep.getPropertyAcceptedValues()) {
                    comboNew.add(value);
                }
                comboNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!ServiceProjectEditorConfigurationPage.this.getServiceProjectController().getServiceModel().getValue(sep.getPropertyName()).equals(comboNew.getItem(comboNew.getSelectionIndex()))) {
                            ServiceProjectEditorConfigurationPage.this.setDirty(true);
                        }
                        ServiceProjectValidationError errorValidation = ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.validateServiceExtensionProperty(null, ServiceProjectEditorConfigurationPage.this.configurationControls, sep.getPropertyLabel(), comboNew.getItem(comboNew.getSelectionIndex()));
                        String key = ServiceProjectEditorConfigurationPage.this.getServiceExtension().getPropertyByLabel(sep.getPropertyLabel()).getPropertyName();
                        if (errorValidation != null) {
                            ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.setControlToError(ServiceProjectEditorConfigurationPage.this.messageMgr, key, errorValidation, (Control)comboNew);
                        } else {
                            ServiceProjectEditorConfigurationPage.this.serviceProjectValidator.resetControlToError(ServiceProjectEditorConfigurationPage.this.messageMgr, key, (Control)comboNew);
                        }
                    }
                });
                if (requiredProps) {
                    this.addWidget(true, sep, (Widget)comboNew);
                } else {
                    this.addWidget(false, sep, (Widget)comboNew);
                }
            }
            String propertyHelpContextId = sep.getHelpContextId();
            if (propertyHelpContextId != null && !propertyHelpContextId.isEmpty()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)controlNew, propertyHelpContextId);
            }
            if ((tooltip = sep.getTooltip()) == null || tooltip.isEmpty()) continue;
            controlNew.setToolTipText(tooltip);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"createExtensionProvidedUIContent", (Object[])new Object[0]);
    }

    private void saveConfig(HashMap<String, Widget> configMap) {
        String methodName = "saveConfig";
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"saveConfig", (Object[])new Object[0]);
        for (String key : configMap.keySet()) {
            Widget anonWidget = configMap.get(key);
            this.saveConfigSingle(key, anonWidget);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"saveConfig", (Object[])new Object[0]);
    }

    private void saveConfigSingle(String key, Widget anonWidget) {
        if (anonWidget instanceof Text) {
            Text value = (Text)anonWidget;
            this.getServiceProjectController().getServiceModel().setValue(key, value.getText());
        } else if (anonWidget instanceof Button) {
            Button value = (Button)anonWidget;
            this.getServiceProjectController().getServiceModel().setValue(key, String.valueOf(value.getSelection()));
        } else if (anonWidget instanceof Combo) {
            Combo combo = (Combo)anonWidget;
            String value = "";
            if (combo.getSelectionIndex() != -1) {
                value = combo.getItem(combo.getSelectionIndex());
            }
            this.getServiceProjectController().getServiceModel().setValue(key, value);
        } else if (anonWidget instanceof CsvListWidget) {
            CsvListWidget value = (CsvListWidget)anonWidget;
            this.getServiceProjectController().getServiceModel().setValue(key, value.getList());
        }
    }

    public void refreshConfig(HashMap<String, Widget> configMap) {
        for (String key : configMap.keySet()) {
            Object value;
            Widget anonWidget = configMap.get(key);
            String propertyFileValue = this.getServiceProjectController().getServiceModel().getValue(key);
            if (anonWidget instanceof Text) {
                value = (Text)anonWidget;
                if (propertyFileValue == null) {
                    propertyFileValue = "";
                }
                value.setText(propertyFileValue);
                continue;
            }
            if (anonWidget instanceof Button) {
                value = (Button)anonWidget;
                if (propertyFileValue == null) {
                    propertyFileValue = "";
                }
                value.setSelection(Boolean.valueOf(propertyFileValue).booleanValue());
                continue;
            }
            if (anonWidget instanceof Combo) {
                value = (Combo)anonWidget;
                value.select(0);
                if (value.indexOf(propertyFileValue) == -1) continue;
                value.select(value.indexOf(propertyFileValue));
                continue;
            }
            if (!(anonWidget instanceof CsvListWidget)) continue;
            value = (CsvListWidget)anonWidget;
            if (propertyFileValue == null) {
                propertyFileValue = "";
            }
            ((CsvListWidget)((Object)value)).setList(propertyFileValue);
        }
    }

    private void refreshConfigEnabledDisabledState(HashMap<String, Widget> configMap) {
        for (Map.Entry<String, List<Widget>> entry : this.dependsOnMap.entrySet()) {
            if (!configMap.containsKey(entry.getKey())) continue;
            Widget anonWidget = configMap.get(entry.getKey());
            if (anonWidget instanceof Button) {
                Button value = (Button)anonWidget;
                for (Widget dependantWidget : entry.getValue()) {
                    if (!(dependantWidget instanceof Control)) continue;
                    Control anonControl = (Control)dependantWidget;
                    anonControl.setEnabled(value.getSelection());
                }
                continue;
            }
            ServiceTypeExtensionException e = new ServiceTypeExtensionException(Xlat.error((String)"UNSUPPORTED_DEPEND_ON_TYPE", (String[])new String[]{entry.getKey()}));
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public void addWidget(boolean isRequired, ServiceExtensionProperty property, Widget widget) {
        if (isRequired) {
            this.requiredConfigHandles.put(property.getPropertyName(), widget);
        } else {
            this.optionalConfigHandles.put(property.getPropertyName(), widget);
        }
        if (property.getDependsOn() != null && !property.getDependsOn().equals("")) {
            if (!this.dependsOnMap.containsKey(property.getDependsOn())) {
                this.dependsOnMap.put(property.getDependsOn(), new ArrayList());
            }
            this.dependsOnMap.get(property.getDependsOn()).add(widget);
        }
    }
}

