/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.editors;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.IResourceUtil;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.service.ZCeeUIServicePlugin;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceBuilder;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceProjectController;
import com.ibm.zosconnect.ui.service.editors.ServiceProjectEditorConfigurationPage;
import com.ibm.zosconnect.ui.service.editors.ServiceProjectEditorOverviewPage;
import com.ibm.zosconnect.ui.service.editors.listeners.IServiceEditorListener;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectEditor;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectValidator;
import com.ibm.zosconnect.ui.service.validation.ServiceProjectValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class ServiceProjectEditor
extends FormEditor
implements IServiceProjectEditor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String EDITOR_ID = "com.ibm.zosconnect.ui.service.serviceprojecteditor";
    private ServiceProjectEditorOverviewPage overviewPage;
    private ServiceProjectEditorConfigurationPage configurationPage;
    private ServiceProjectController serviceProjectController;
    private IServiceProjectValidator serviceProjectValidator;
    private IFile serviceFile;
    private ResourceTracker resourceTracker;
    private List<IServiceEditorListener> editorSaveListeners;
    private ISchedulingRule modifyRule = null;
    private boolean hasCapabilityErrors = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        String unknownCapabilities = Xlat.colon() + "\n";
        boolean haveCapabilityErrors = false;
        try {
            this.serviceFile = ((IFileEditorInput)input).getFile();
            IProject project = this.serviceFile.getProject();
            IMarker[] capMarkers = project.findMarkers(ServiceProjectMarkerTypes.CAPABILITIES_PROBLEM.toString(), false, 0);
            int i = 0;
            while (i < capMarkers.length) {
                unknownCapabilities = unknownCapabilities + String.valueOf(capMarkers[i].getAttribute("message")) + "\n";
                ++i;
            }
            if (capMarkers.length > 0) {
                haveCapabilityErrors = true;
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
        if (haveCapabilityErrors) {
            String errorMsg = Xlat.error((String)"UNKNOWN_CAPABILITY_EDITOR", (String[])new String[]{unknownCapabilities});
            Status status = new Status(4, "com.ibm.zosconnect.ui.service", errorMsg);
            this.hasCapabilityErrors = true;
            throw new PartInitException((IStatus)status);
        }
        super.init(site, input);
        this.setTitleImage(ZCeeUIServicePlugin.getImageDescriptor("service_16.gif"));
    }

    protected void setInput(IEditorInput input) {
        IFile editorInputFile;
        if (this.getEditorInput() != null) {
            editorInputFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            editorInputFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            editorInputFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            editorInputFile.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.setPartName(editorInputFile.getName());
            this.firePropertyChange(258);
            this.firePropertyChange(1);
        }
        this.serviceFile = ((IFileEditorInput)input).getFile();
        try {
            this.serviceProjectController = new ServiceProjectController(this.serviceFile.getProject());
            this.serviceProjectValidator = new ServiceProjectValidator(this.serviceProjectController.getProject(), this.serviceProjectController);
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.modifyRule = ruleFactory.modifyRule((IResource)this.serviceProjectController.getProject());
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public void updatePartName() {
        String title;
        String serviceTitle = "";
        if (this.serviceProjectController != null && !(title = StringUtils.trimToEmpty((String)this.serviceProjectController.getServiceModel().getServiceTitle())).isEmpty()) {
            serviceTitle = title;
        }
        if ("".equals(serviceTitle) && this.getEditorInput() != null && !(title = StringUtils.trimToEmpty((String)this.getEditorInput().getName())).isEmpty()) {
            serviceTitle = title;
        }
        this.setPartName(MessageFormat.format("{0} Service", serviceTitle));
        this.firePropertyChange(1);
    }

    protected void addPages() {
        try {
            this.overviewPage = new ServiceProjectEditorOverviewPage(this, "ZosConnectServiceEditorOverviewPage", Xlat.label((String)"SERVICE_DEFINITION_TAB_TITLE"));
            this.addPage((IFormPage)this.overviewPage);
            this.updatePartName();
            this.configurationPage = new ServiceProjectEditorConfigurationPage(this, "ZosConnectServiceEditorPropertiesPage", Xlat.label((String)"SERVICE_CONFIGURATION_TAB_TITLE"));
            this.addPage((IFormPage)this.configurationPage);
        }
        catch (PartInitException e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            SaveApiOperation workspaceOp = new SaveApiOperation(this.modifyRule);
            WorkspaceUtil.run((WorkspaceModifyOperation)workspaceOp, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IFile getServiceFile() {
        return this.serviceFile;
    }

    public boolean isDirty() {
        return this.overviewPage.isDirty() || this.configurationPage.isDirty();
    }

    @Override
    public IServiceProjectController getServiceProjectController() {
        return this.serviceProjectController;
    }

    @Override
    public String getProjectName() {
        return this.serviceProjectController.getProject().getName();
    }

    @Override
    public IProject getProject() {
        return this.serviceProjectController.getProject();
    }

    public void dispose() {
        if (!this.hasCapabilityErrors) {
            super.dispose();
            IFile editorInputFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            editorInputFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.resourceTracker = null;
            XSwt.dispose((FormPage)this.overviewPage);
            XSwt.dispose((FormPage)this.configurationPage);
        }
    }

    private void createRunnableToRefreshUI() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ServiceProjectEditor.this.serviceProjectController.getProject().exists()) {
                    ((ServiceModelController)ServiceProjectEditor.this.getServiceProjectController().getServiceModel()).loadPropertiesFromServicePropertiesFile();
                    ServiceProjectEditor.this.overviewPage.refreshPageFromModel();
                    ServiceProjectEditor.this.configurationPage.refreshPageFromModel();
                }
            }
        });
    }

    private void createRunnableToRefreshOverviewPage() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ServiceProjectEditor.this.serviceProjectController.getProject().exists()) {
                    ServiceProjectEditor.this.overviewPage.refreshPageFromModel();
                }
            }
        });
    }

    private boolean isResourceServicePropertiesFile(IResource resource) {
        IPath resourcePath;
        boolean isServicePropertiesFile = false;
        if (resource instanceof IFile && (resourcePath = resource.getProjectRelativePath()).segmentCount() == 1 && resourcePath.lastSegment().equals("service.properties")) {
            isServicePropertiesFile = true;
        }
        return isServicePropertiesFile;
    }

    private boolean isResourceCapabilitiesFile(IResource resource) {
        IPath resourcePath;
        boolean isCapabilitiesFile = false;
        if (resource instanceof IFile && (resourcePath = resource.getProjectRelativePath()).segmentCount() == 1 && resourcePath.lastSegment().equals(".capabilities")) {
            isCapabilitiesFile = true;
        }
        return isCapabilitiesFile;
    }

    private boolean isResourceBuilderOutput(IResource resource) throws CoreException {
        IServiceBuilder serviceBuilder = this.getServiceBuilder();
        if (resource == null || serviceBuilder == null) {
            return false;
        }
        IPath resourcePath = resource.getProjectRelativePath();
        if (resource instanceof IFile) {
            resourcePath = resourcePath.removeLastSegments(1);
        }
        boolean isResoureBuildOutput = false;
        List outputFolderPaths = serviceBuilder.getBuildOutputFolderPaths();
        int i = 0;
        while (i < outputFolderPaths.size() && !isResoureBuildOutput) {
            if (IResourceUtil.pathStartsWith((IPath)resourcePath, (IPath)((IPath)outputFolderPaths.get(i)))) {
                isResoureBuildOutput = true;
            }
            ++i;
        }
        return isResoureBuildOutput;
    }

    private void closeEditor(final boolean save) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServiceProjectEditor.this.getSite().getPage().closeEditor((IEditorPart)ServiceProjectEditor.this, save);
            }
        });
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    public void notifyEditorSaveListeners(boolean validate) {
        for (IServiceEditorListener editorSaveListener : this.getEditorSaveListeners()) {
            if (validate) {
                editorSaveListener.beforeSave(this);
                continue;
            }
            editorSaveListener.save(this);
        }
    }

    public List<IServiceEditorListener> getEditorSaveListeners() {
        if (this.editorSaveListeners == null) {
            this.editorSaveListeners = new ArrayList<IServiceEditorListener>();
        }
        return this.editorSaveListeners;
    }

    @Override
    public IServiceProjectValidator getServiceProjectValidator() {
        return this.serviceProjectValidator;
    }

    @Override
    public IMessageManager getMessageManager() {
        return this.overviewPage.getMessageManager();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.overviewPage.setDirty(dirty);
    }

    @Override
    public void setLoading(boolean loading) {
        this.overviewPage.setLoading(loading);
    }

    @Override
    public boolean isLoading() {
        return this.overviewPage.isLoading();
    }

    @Override
    public void launchPgmInterfaceEditor(IFile msgFile) throws PartInitException {
        this.overviewPage.launchPgmInterfaceEditor(msgFile);
    }

    protected void createPages() {
        super.createPages();
        this.createRunnableToRefreshUI();
    }

    private IServiceBuilder getServiceBuilder() throws CoreException {
        return ServiceExtension.getServiceExtension((String)this.serviceProjectController.getServiceModel().getServiceType()).getBuilderClass();
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null || delta.getResource() == null) {
                return true;
            }
            IResource resource = delta.getResource();
            IProject project = ServiceProjectEditor.this.serviceProjectController.getProject();
            if (resource.getProject() != project) {
                return true;
            }
            if (ServiceProjectEditor.this.isResourceCapabilitiesFile(resource)) {
                return true;
            }
            if (ServiceProjectEditor.this.isResourceBuilderOutput(resource)) {
                return true;
            }
            boolean resourceIsServiceProperties = ServiceProjectEditor.this.isResourceServicePropertiesFile(resource);
            if (delta.getKind() == 2 && delta.getAffectedChildren().length == 0) {
                if (resourceIsServiceProperties) {
                    if ((0x2000 & delta.getFlags()) == 0) {
                        if (!ServiceProjectEditor.this.isDirty()) {
                            ServiceProjectEditor.this.closeEditor(false);
                        }
                    } else {
                        final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                        Display display = ServiceProjectEditor.this.getSite().getShell().getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ServiceProjectEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                            }
                        });
                    }
                } else {
                    ServiceProjectEditor.this.createRunnableToRefreshOverviewPage();
                }
            }
            if (delta.getKind() == 4 && delta.getAffectedChildren().length == 0) {
                if (resourceIsServiceProperties) {
                    if ((delta.getFlags() & 0x40100) != 0) {
                        ServiceProjectEditor.this.createRunnableToRefreshUI();
                    }
                } else {
                    ServiceProjectEditor.this.createRunnableToRefreshOverviewPage();
                }
            }
            if (delta.getKind() == 1 && !resourceIsServiceProperties && delta.getAffectedChildren().length == 0) {
                ServiceProjectEditor.this.createRunnableToRefreshOverviewPage();
            }
            return true;
        }
    }

    private class SaveApiOperation
    extends WorkspaceModifyOperation {
        public SaveApiOperation(ISchedulingRule modifyRule) {
            super(modifyRule);
        }

        protected void execute(IProgressMonitor monitor) {
            try {
                ServiceProjectEditor.this.notifyEditorSaveListeners(false);
                ServiceProjectEditor.this.overviewPage.setDirty(false);
                ServiceProjectEditor.this.configurationPage.setDirty(false);
                ServiceProjectEditor.this.editorDirtyStateChanged();
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                ZCeeErrorDialog.openError((Exception)e);
            }
        }
    }
}

