/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.editors;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.SWTResourceManager;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.resources.ZCeeUIResourcePlugin;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CsvListWidget
extends Composite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private LinkedHashMap<Text, Button> rows = new LinkedHashMap();
    private Label addLabel;
    private Button addButton;
    private String oldList = "";
    private Vector<CsvChangedEventListener> listChangedListeners = new Vector();

    public CsvListWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.addRow(null);
    }

    public void setList(String list) {
        String methodName = "setList";
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"setList", (Object[])new Object[]{list});
        for (Map.Entry<Text, Button> entry : this.rows.entrySet()) {
            entry.getKey().dispose();
            entry.getValue().dispose();
        }
        this.rows.clear();
        for (String header : CsvListWidget.getItems(list)) {
            this.addRow(header);
        }
        for (CsvChangedEventListener listener : this.listChangedListeners) {
            listener.listChanged(new CsvListChangedEventObject((Object)this, this.rows.keySet(), null));
        }
        this.layout();
        this.pack();
        this.oldList = list;
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"setList", (Object[])new Object[0]);
    }

    public String getList() {
        String methodName = "getList";
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"getList", (Object[])new Object[0]);
        boolean needsUIRefresh = false;
        StringBuilder list = new StringBuilder();
        Iterator<Text> iterator = this.rows.keySet().iterator();
        while (iterator.hasNext()) {
            Text text = iterator.next();
            String nextValue = text.getText().trim();
            if (text.getText().length() != nextValue.length()) {
                text.setText(nextValue);
            }
            if (!nextValue.isEmpty()) {
                list.append(CsvListWidget.quoteText(nextValue));
                list.append(",");
                continue;
            }
            if (this.rows.size() <= 1) continue;
            this.rows.get(text).dispose();
            text.dispose();
            iterator.remove();
            needsUIRefresh = true;
            for (CsvChangedEventListener listener : this.listChangedListeners) {
                listener.listChanged(new CsvListChangedEventObject((Object)this, this.rows.keySet(), text));
            }
        }
        if (needsUIRefresh) {
            this.layout();
            this.pack();
        }
        if (list.length() > 1) {
            ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"getList", (Object[])new Object[]{list.substring(0, list.length() - 1)});
            return list.substring(0, list.length() - 1);
        }
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"getList", (Object[])new Object[]{""});
        return "";
    }

    public static String quoteText(String text) {
        if (((String)text).contains(",") || ((String)text).contains("\"")) {
            text = ((String)text).replace("\"", "\"\"");
            text = "\"" + (String)text + "\"";
        }
        return text;
    }

    public static String unquoteText(String text) {
        if (text.startsWith("\"")) {
            text = text.substring(1, text.length() - 1);
            text = text.replace("\"\"", "\"");
        }
        return text;
    }

    public static List<String> getItems(String list) {
        ArrayList<String> headers = new ArrayList<String>();
        int startIndex = 0;
        boolean inQuotedItem = false;
        int currentIndex = 0;
        while (currentIndex < list.length()) {
            if (list.charAt(currentIndex) == '\"') {
                inQuotedItem = !inQuotedItem;
            } else if (!inQuotedItem && list.charAt(currentIndex) == ',') {
                headers.add(CsvListWidget.unquoteText(list.substring(startIndex, currentIndex)));
                startIndex = currentIndex + 1;
            }
            ++currentIndex;
        }
        headers.add(CsvListWidget.unquoteText(list.substring(startIndex)));
        return headers;
    }

    private Text addRow(String item) {
        Label controlNew;
        Text textNew;
        if (item == null) {
            textNew = null;
            Label labelNew = new Label((Composite)this, 0);
            labelNew.setText(Xlat.label((String)"CSV_LIST_ADD"));
            this.addLabel = labelNew;
            GridData gd = new GridData(131072, 0x1000000, true, false, 1, 1);
            labelNew.setLayoutData((Object)gd);
            controlNew = labelNew;
        } else {
            textNew = new Text((Composite)this, 2048);
            textNew.setText(item);
            textNew.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    for (CsvChangedEventListener listener : CsvListWidget.this.listChangedListeners) {
                        listener.listChanged(new CsvListChangedEventObject(textNew, CsvListWidget.this.rows.keySet(), null));
                    }
                }
            });
            GridData gd = new GridData(16384, 0x1000000, true, false, 1, 1);
            gd.widthHint = 200;
            textNew.setLayoutData((Object)gd);
            controlNew = textNew;
        }
        controlNew.setToolTipText(this.getToolTipText());
        final Button addRemove = new Button((Composite)this, 8);
        if (item == null) {
            Image addImage = SWTResourceManager.getImage(ZCeeUIResourcePlugin.class, (String)"icons/add_16.gif");
            addRemove.setImage(addImage);
            this.addButton = addRemove;
            this.addButton.setToolTipText(Xlat.label((String)"CSV_ADD_ROW_TOOLTIP"));
        } else {
            Image removeImage = SWTResourceManager.getImage(ZCeeUIResourcePlugin.class, (String)"icons/remove_16.gif");
            addRemove.setImage(removeImage);
            addRemove.setToolTipText(Xlat.label((String)"CSV_REMOVE_ROW_TOOLTIP"));
        }
        GridData addRemoveGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        addRemove.setLayoutData((Object)addRemoveGridData);
        addRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Text source = null;
                Text disposedText = null;
                if (event.getSource() == CsvListWidget.this.addButton) {
                    source = CsvListWidget.this.addRow("");
                    source.setFocus();
                } else if (CsvListWidget.this.rows.size() > 1) {
                    CsvListWidget.this.rows.remove(textNew);
                    textNew.dispose();
                    addRemove.dispose();
                    disposedText = textNew;
                } else {
                    textNew.setText("");
                }
                for (CsvChangedEventListener listener : CsvListWidget.this.listChangedListeners) {
                    if (source == null) {
                        listener.listChanged(new CsvListChangedEventObject(this, CsvListWidget.this.rows.keySet(), disposedText));
                        continue;
                    }
                    listener.listChanged(new CsvListChangedEventObject(source, CsvListWidget.this.rows.keySet(), null));
                }
                CsvListWidget.this.layout();
                CsvListWidget.this.pack();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        if (item != null) {
            textNew.moveAbove((Control)this.addLabel);
            addRemove.moveAbove((Control)this.addLabel);
            this.rows.put(textNew, addRemove);
        }
        return textNew;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.getEnabled()) {
            super.setEnabled(enabled);
            if (enabled) {
                this.setList(this.oldList);
            } else {
                String tempList = this.getList();
                this.setList("");
                this.oldList = tempList;
            }
            for (Map.Entry<Text, Button> entry : this.rows.entrySet()) {
                entry.getKey().setEnabled(enabled);
                entry.getValue().setEnabled(enabled);
            }
            this.addButton.setEnabled(enabled);
        }
    }

    public void setToolTipText(String tooltip) {
        super.setToolTipText(tooltip);
        for (Map.Entry<Text, Button> row : this.rows.entrySet()) {
            row.getKey().setToolTipText(tooltip);
            row.getValue().setToolTipText(tooltip);
        }
    }

    public void addCsvChangedEventListener(CsvChangedEventListener listener) {
        this.listChangedListeners.addElement(listener);
    }

    public void removeCsvChangedEventListener(CsvChangedEventListener listener) {
        this.listChangedListeners.removeElement(listener);
    }

    public static interface CsvChangedEventListener
    extends EventListener {
        public void listChanged(CsvListChangedEventObject var1);
    }

    public class CsvListChangedEventObject
    extends EventObject {
        private static final long serialVersionUID = -4962853203707808045L;
        private Set<Text> allTexts;
        private Text disposedText;

        public CsvListChangedEventObject(Object source, Set<Text> allTexts, Text disposedText) {
            super(source);
            this.allTexts = allTexts;
            this.disposedText = disposedText;
        }

        public Set<Text> getAllTexts() {
            return this.allTexts;
        }

        public Text getDisposedText() {
            return this.disposedText;
        }
    }
}

