/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.dialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.dialogs.WorkspaceFileSelectionDialog;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceProjectController;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ServiceInterfaceSelectionDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Composite compButtonBar;
    private Label lblSelectServiceInterface;
    private List listServiceInterfaces;
    private Button btnWorkspace;
    private Button btnFileSystem;
    private Button btnOk;
    private IServiceProjectController serviceProjectController;
    private boolean isContextMenu;

    public ServiceInterfaceSelectionDialog(Shell parentShell, IServiceProjectController serviceProjectController, boolean isContextMenu) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.serviceProjectController = serviceProjectController;
        this.isContextMenu = isContextMenu;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ruleFactory.modifyRule((IResource)serviceProjectController.getProject());
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) throws Exception {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblSelectServiceInterface = new Label(this.compContents, 0);
        if (this.isContextMenu) {
            this.lblSelectServiceInterface.setText(Xlat.label((String)"SERVICEEDIT_LABEL_IMPORTSERVICEINTERFACE"));
        } else {
            this.lblSelectServiceInterface.setText(Xlat.label((String)"SERVICEEDIT_LABEL_IMPORTSERVICEINTERFACE"));
        }
        new Label(this.compContents, 0);
        this.listServiceInterfaces = new List(this.compContents, 2816);
        GridData gd_compResourceBrowser = new GridData(4, 128, false, false, 1, 1);
        gd_compResourceBrowser.widthHint = 400;
        gd_compResourceBrowser.heightHint = 250;
        this.listServiceInterfaces.setLayoutData((Object)gd_compResourceBrowser);
        this.listServiceInterfaces.setBounds(0, 0, 89, 89);
        this.listServiceInterfaces.setItems(this.getImportedServiceInterfaceNames());
        XSwt.sortItems((List)this.listServiceInterfaces);
        this.listServiceInterfaces.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (ServiceInterfaceSelectionDialog.this.listServiceInterfaces.getSelectionCount() == 1) {
                    ServiceInterfaceSelectionDialog.this.btnOk.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        if (this.isContextMenu) {
            this.listServiceInterfaces.setEnabled(false);
        }
        this.compButtonBar = new Composite(this.compContents, 0);
        GridLayout gl_compButtonBar = new GridLayout(1, false);
        gl_compButtonBar.horizontalSpacing = 0;
        gl_compButtonBar.marginBottom = 5;
        gl_compButtonBar.marginHeight = 0;
        this.compButtonBar.setLayout((Layout)gl_compButtonBar);
        this.compButtonBar.setLayoutData((Object)new GridData(0x1000000, 128, false, true, 1, 1));
        this.btnWorkspace = new Button(this.compButtonBar, 0);
        this.btnWorkspace.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnWorkspace.setText(Xlat.label((String)"APIDLG_BUTTON_WORKSPACE"));
        this.btnWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkspaceFileSelectionDialog dialog = new WorkspaceFileSelectionDialog(null, Xlat.label((String)"SERVICEEDIT_BUTTON_IMPORTDATASET"), Xlat.label((String)"SERVICEEDIT_BUTTON_IMPORTDATASET"), "si", true, ServiceInterfaceSelectionDialog.this.serviceProjectController.getProject());
                if (dialog.open() == 0) {
                    ArrayList siFiles = dialog.getResults();
                    int i = 0;
                    while (i < siFiles.size()) {
                        File sourceSIFile = ((IFile)siFiles.get(i)).getLocation().toFile();
                        File destinationDirectory = ServiceInterfaceSelectionDialog.this.serviceProjectController.getServiceModel().getServiceProject().getLocation().append("service-interfaces").toFile();
                        ServiceInterfaceSelectionDialog.this.validateAndCopy(sourceSIFile, destinationDirectory);
                        ServiceInterfaceSelectionDialog.this.refreshWorkspaceFolder();
                        ++i;
                    }
                }
            }
        });
        this.btnFileSystem = new Button(this.compButtonBar, 0);
        this.btnFileSystem.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnFileSystem.setText(Xlat.label((String)"APIDLG_BUTTON_FILE_SYSTEM"));
        this.btnFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ServiceInterfaceSelectionDialog.this.btnFileSystem.getShell(), 4098);
                dialog.setFilterExtensions(new String[]{"*.si"});
                dialog.setFilterPath("/");
                String firstFileName = dialog.open();
                if (firstFileName != null) {
                    String path = firstFileName.substring(0, firstFileName.lastIndexOf(File.separator) + 1);
                    String[] fileNames = dialog.getFileNames();
                    int i = 0;
                    while (i < fileNames.length) {
                        String name = path + fileNames[i];
                        File sourceSIFile = new File(name);
                        File destinationDirectory = ServiceInterfaceSelectionDialog.this.serviceProjectController.getServiceModel().getServiceProject().getLocation().append("service-interfaces").toFile();
                        ServiceInterfaceSelectionDialog.this.validateAndCopy(sourceSIFile, destinationDirectory);
                        ServiceInterfaceSelectionDialog.this.refreshWorkspaceFolder();
                        ++i;
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.service.composeinterface");
        return compDialogArea;
    }

    private void validateAndCopy(File sourceSIFile, File destinationDirectory) {
        try {
            File newFile = new File(String.valueOf(this.serviceProjectController.getServiceModel().getServiceProject().getLocation()) + File.separator + "service-interfaces" + File.separator + sourceSIFile.getName());
            if (!newFile.equals(sourceSIFile)) {
                if (newFile.exists()) {
                    MessageBox yesNoBox = new MessageBox(this.btnWorkspace.getShell(), 196);
                    yesNoBox.setText(Xlat.label((String)"SERVICEEDIT_TITLE_IMPORT_CONFIRM_OVERWRITE"));
                    yesNoBox.setMessage(Xlat.label((String)"SERVICEEDIT_LABEL_IMPORT_CONFIRM_OVERWRITE", (String[])new String[]{sourceSIFile.getName()}));
                    int response = yesNoBox.open();
                    if (response == 64) {
                        newFile.delete();
                        FileUtils.copyFileToDirectory((File)sourceSIFile, (File)destinationDirectory);
                    }
                } else {
                    FileUtils.copyFileToDirectory((File)sourceSIFile, (File)destinationDirectory);
                }
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    private void refreshWorkspaceFolder() {
        try {
            this.serviceProjectController.getProject().refreshLocal(2, null);
            this.listServiceInterfaces.setItems(this.getImportedServiceInterfaceNames());
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getButton(1);
        this.btnOk = this.getButton(0);
        if (!this.isContextMenu) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.btnOk.setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isContextMenu) {
            newShell.setText(Xlat.label((String)"SERVICEEDIT_TITLE_IMPORTSERVICEINTERFACE"));
        } else {
            newShell.setText(Xlat.label((String)"SERVICEEDIT_TITLE_IMPORTSERVICEINTERFACE"));
        }
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (!XSwt.isOK((IStatus)status)) {
            ZCeeUILogger.error((IStatus)status);
        }
    }

    public String[] getImportedServiceInterfaceNames() throws Exception {
        IResource[] members;
        ArrayList<String> retVal = new ArrayList<String>();
        IResource[] iResourceArray = members = this.serviceProjectController.getFolder("service-interfaces").members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray[n2];
            if (iResource instanceof IFile) {
                IFile file = (IFile)iResource;
                String serviceName = file.getName();
                retVal.add(serviceName);
            }
            ++n2;
        }
        return retVal.toArray(new String[retVal.size()]);
    }
}

