/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.dialogs;

import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionWidgetManager;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.IConnectionStateViewer;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionStatus;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ZCeeProjectConstants;
import com.ibm.zosconnect.ui.common.util.SimpleLock;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectService;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import com.ibm.zosconnect.ui.service.controllers.ServiceDeployController;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.jobs.DeployServicesJob;
import com.ibm.zosconnect.ui.service.jobs.RefreshServicesJob;
import com.ibm.zosconnect.ui.util.Images;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DeployServiceDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = DeployServiceDialog.class.getName();
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Composite mainComposite;
    private ConnectionWidgetManager connectionWidgetManager;
    private Label labelTable1;
    private Label labelTable2;
    private Button okButton;
    private Table tableNewService;
    private Table tableOverwriteService;
    private TableColumn table1Col1;
    private TableColumn table1Col2;
    private TableColumn table1Col3;
    private TableColumn table2Col1;
    private TableColumn table2Col2;
    private TableColumn table2Col3;
    private Button buttonUpdateServices;
    private ProgressIndicator progressIndicator;
    private Composite compProgress;
    private Label labelProgress;
    private RefreshServicesJob refreshJob;
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private static final int COMPOSITE_WIDTH = 500;
    private static final int NUM_ROWS_DISPLAYED = 7;
    private ServiceDeployController controller;
    private ConnectionServiceListener connectionServiceListener;
    private IConnectable selectedConnectable;
    private ConnectionProfile selectedConnProfile;
    private HashMap<String, ZosConnectService> servicesOnServerMap = new HashMap();
    private ArrayList<ServiceModelController> servicesToCreate = new ArrayList();
    private ArrayList<ServiceModelController> servicesToOverwrite = new ArrayList();
    private boolean canReachServer;
    private boolean initial;
    private boolean projectsProblems = false;
    private IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
    private SimpleLock refreshLock = new SimpleLock(TAG);

    public DeployServiceDialog(Shell parentShell, ServiceDeployController controller) {
        super(parentShell);
        this.controller = controller;
        this.initial = true;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            try {
                retVal = this.createDialogAreaBody(parent);
            }
            catch (Exception e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
                this.initial = false;
            }
        }
        finally {
            this.initial = false;
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) throws CoreException {
        this.mainComposite = parent;
        this.mainComposite.setBackground(this.formToolkit.getColors().getBackground());
        this.mainComposite.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(this.mainComposite);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(3, false);
        gl_compContents.marginTop = 5;
        gl_compContents.marginLeft = 2;
        gl_compContents.marginRight = 2;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.widthHint = 500;
        this.compContents.setLayoutData((Object)gridData);
        this.createConnectableArea(this.compContents);
        this.refreshServiceTables();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.servicedeploydialog");
        return compDialogArea;
    }

    private void disposeTables() {
        XSwt.dispose((Control)this.labelTable1);
        XSwt.dispose((TableColumn)this.table1Col1);
        XSwt.dispose((TableColumn)this.table1Col2);
        XSwt.dispose((TableColumn)this.table1Col3);
        XSwt.dispose((Control)this.tableNewService);
        XSwt.dispose((Control)this.labelTable2);
        XSwt.dispose((TableColumn)this.table2Col1);
        XSwt.dispose((TableColumn)this.table2Col2);
        XSwt.dispose((TableColumn)this.table2Col3);
        XSwt.dispose((Control)this.tableOverwriteService);
        XSwt.dispose((Control)this.buttonUpdateServices);
    }

    private void putAllServicesInOneTable() {
        this.disposeTables();
        ArrayList serviceModelControllers = this.controller.getServiceModelControllers();
        if (!serviceModelControllers.isEmpty()) {
            this.labelTable1 = new Label(this.compContents, 0);
            this.labelTable1.setText(Xlat.label((String)"DEPLOY_NEW_SERVICE_TABLE_TITLE") + Xlat.colon());
            GridData gridData = new GridData(4, 0x1000000, true, false, 3, 1);
            this.labelTable1.setLayoutData((Object)gridData);
            this.tableNewService = new Table(this.compContents, 2560);
            this.table1Col1 = new TableColumn(this.tableNewService, 0);
            this.table1Col1.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL1"));
            this.table1Col2 = new TableColumn(this.tableNewService, 0);
            this.table1Col2.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL2"));
            this.table1Col3 = new TableColumn(this.tableNewService, 0);
            this.table1Col3.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL3"));
            int newApiRowNum = 0;
            int i = 0;
            while (i < serviceModelControllers.size()) {
                ServiceModelController currController = (ServiceModelController)serviceModelControllers.get(i);
                TableItem tableItem = new TableItem(this.tableNewService, 0);
                tableItem.setText(0, currController.getServiceTitle());
                tableItem.setText(1, currController.getServiceVersion());
                tableItem.setText(2, currController.getServiceTypeLabel());
                Image overlay = this.getOverlayImage(currController.getServiceProject());
                if (overlay != null) {
                    tableItem.setImage(0, overlay);
                }
                ++newApiRowNum;
                ++i;
            }
            this.tableNewService.setHeaderVisible(true);
            this.tableNewService.setLinesVisible(true);
            gridData = new GridData(4, 0x1000000, true, false, 3, 1);
            if (newApiRowNum > 7) {
                int tableHeight;
                gridData.heightHint = tableHeight = this.tableNewService.getItemHeight() * 7 + this.tableNewService.getHeaderHeight();
            }
            this.tableNewService.setLayoutData((Object)gridData);
            this.tableNewService.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = DeployServiceDialog.this.compContents.getClientArea();
                    int width = area.width - 2 - 2 - 2 * DeployServiceDialog.this.tableNewService.getBorderWidth() - 10;
                    TableColumn[] tableColumns = DeployServiceDialog.this.tableNewService.getColumns();
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            this.tableNewService.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeployServiceDialog.this.tableNewService.setSelection(new int[0]);
                }
            });
        }
        this.validateInput();
        XSwt.layout((Composite)this.compContents, (boolean)true);
        XSwt.centerInWorkbench((Shell)this.getShell());
    }

    private void refreshServiceTables() {
        try {
            this.refreshServiceTables_1();
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            this.refreshLock.releaseLock(false);
        }
    }

    private void refreshServiceTables_1() {
        IConnectionState connectionState;
        this.canReachServer = false;
        ConnectionProfile connProfile = this.selectedConnProfile;
        IConnectable connectable = this.connectionService.getConnectable("com.ibm.zosconnect.ui.connections.category.adminapi");
        this.canReachServer = connProfile != null ? (connectable != null && !connProfile.getName().equals(connectable.getConnection().getName()) ? false : connectable != null && connectable.isConnected()) : (connectionState = this.connectionService.getConnectionState("com.ibm.zosconnect.ui.connections.category.adminapi")) instanceof ConnectedState && connectable != null && connectable.isConnected();
        if (!this.canReachServer) {
            try {
                try {
                    this.putAllServicesInOneTable();
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                    this.refreshLock.releaseLock(false);
                }
            }
            finally {
                this.refreshLock.releaseLock(false);
            }
        } else {
            try {
                this.refreshServiceTables_2();
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                this.refreshLock.releaseLock(false);
            }
        }
    }

    private void refreshServiceTables_2() {
        this.disposeTables();
        IConnectable connectable = this.connectionService.getConnectable("com.ibm.zosconnect.ui.connections.category.adminapi");
        IConnection connection = connectable.getConnection();
        final ZosConnectServerNav nav = ZosConnectServerNav.getView();
        final ZosConnectServerNode server = nav.getServer(connection);
        if (this.initial) {
            Map services = nav.getServices(server);
            for (Map.Entry service : services.entrySet()) {
                this.servicesOnServerMap.put(((ZosConnectService)service.getKey()).getServiceName(), (ZosConnectService)service.getKey());
            }
            try {
                try {
                    this.refreshServiceTables_3();
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                    this.refreshLock.releaseLock(false);
                }
            }
            finally {
                this.refreshLock.releaseLock(false);
            }
        } else {
            this.servicesOnServerMap.clear();
            this.updateStatus(null);
            this.compProgress = new Composite(this.compContents, 0);
            this.compProgress.setLayout((Layout)new GridLayout(1, false));
            this.compProgress.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
            this.progressIndicator = new ProgressIndicator(this.compProgress, 2);
            GridData progress_gd = new GridData(4, 0x1000000, true, false, 1, 1);
            this.progressIndicator.setLayoutData((Object)progress_gd);
            this.progressIndicator.beginAnimatedTask();
            this.labelProgress = new Label(this.compProgress, 320);
            GridData labelProgress_gd = new GridData(16384, 0x1000000, true, true, 1, 1);
            this.labelProgress.setLayoutData((Object)labelProgress_gd);
            XSwt.disable((Control[])new Control[]{this.okButton});
            XSwt.layout((Composite)this.compContents, (boolean)true);
            XSwt.packAndCenterInWorkbench((Shell)this.getShell());
            this.refreshJob = new RefreshServicesJob(server);
            this.refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (XSwt.isDisposed((Control)DeployServiceDialog.this.getShell())) {
                                    return;
                                }
                                try {
                                    Map services = nav.getServices(server);
                                    for (Map.Entry service : services.entrySet()) {
                                        (this).DeployServiceDialog.this.servicesOnServerMap.put(((ZosConnectService)service.getKey()).getServiceName(), (ZosConnectService)service.getKey());
                                    }
                                    XSwt.dispose((Control)(this).DeployServiceDialog.this.compProgress);
                                    DeployServiceDialog.this.refreshServiceTables_3();
                                    DeployServiceDialog.this.validateInput();
                                }
                                catch (Exception e) {
                                    ZCeeUILogger.error((Throwable)e);
                                }
                            }
                            finally {
                                (this).DeployServiceDialog.this.refreshLock.releaseLock(false);
                            }
                        }
                    });
                }

                public void running(final IJobChangeEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (XSwt.isDisposed((Control)DeployServiceDialog.this.getShell())) {
                                    return;
                                }
                                XSwt.setText((Label)(this).DeployServiceDialog.this.labelProgress, (String)event.getJob().getName());
                                XSwt.layout((Composite)(this).DeployServiceDialog.this.compContents, (boolean)true);
                                XSwt.packAndCenterInWorkbench((Shell)DeployServiceDialog.this.getShell());
                            }
                            catch (Exception e) {
                                ZCeeUILogger.error((Throwable)e);
                            }
                        }
                    });
                }
            });
            this.refreshJob.schedule();
        }
    }

    private void refreshServiceTables_3() {
        Image overlay;
        TableItem tableItem;
        ServiceModelController currController;
        this.servicesToCreate.clear();
        this.servicesToOverwrite.clear();
        ArrayList apiModelControllers = this.controller.getServiceModelControllers();
        int i = 0;
        while (i < apiModelControllers.size()) {
            ServiceModelController currController2 = (ServiceModelController)apiModelControllers.get(i);
            if (!this.servicesOnServerMap.containsKey(currController2.getServiceName())) {
                this.servicesToCreate.add(currController2);
                try {
                    currController2.getServiceProject().setSessionProperty(ZCeeProjectConstants.PROP_SERVICE_EXISTS_ON_SERVER, (Object)Boolean.FALSE);
                }
                catch (CoreException e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            } else {
                this.servicesToOverwrite.add(currController2);
                try {
                    currController2.getServiceProject().setSessionProperty(ZCeeProjectConstants.PROP_SERVICE_EXISTS_ON_SERVER, (Object)Boolean.TRUE);
                }
                catch (CoreException e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            }
            ++i;
        }
        if (!this.servicesToCreate.isEmpty()) {
            this.labelTable1 = new Label(this.compContents, 0);
            this.labelTable1.setText(Xlat.label((String)"DEPLOY_NEW_SERVICE_TABLE_TITLE") + Xlat.colon());
            GridData gridData = new GridData(4, 0x1000000, true, false, 3, 1);
            this.labelTable1.setLayoutData((Object)gridData);
            this.tableNewService = new Table(this.compContents, 2560);
            this.table1Col1 = new TableColumn(this.tableNewService, 0);
            this.table1Col1.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL1"));
            this.table1Col2 = new TableColumn(this.tableNewService, 0);
            this.table1Col2.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL2"));
            this.table1Col3 = new TableColumn(this.tableNewService, 0);
            this.table1Col3.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL3"));
            int newApiRowNum = 0;
            int i2 = 0;
            while (i2 < this.servicesToCreate.size()) {
                currController = this.servicesToCreate.get(i2);
                tableItem = new TableItem(this.tableNewService, 0);
                tableItem.setText(0, currController.getServiceName());
                tableItem.setText(1, currController.getServiceVersion());
                tableItem.setText(2, currController.getServiceTypeLabel());
                overlay = this.getOverlayImage(currController.getServiceProject());
                if (overlay != null) {
                    tableItem.setImage(0, overlay);
                }
                ++newApiRowNum;
                ++i2;
            }
            this.tableNewService.setHeaderVisible(true);
            this.tableNewService.setLinesVisible(true);
            gridData = new GridData(4, 0x1000000, true, false, 3, 1);
            if (newApiRowNum > 7) {
                int tableHeight;
                gridData.heightHint = tableHeight = this.tableNewService.getItemHeight() * 7 + this.tableNewService.getHeaderHeight();
            }
            this.tableNewService.setLayoutData((Object)gridData);
            this.tableNewService.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = DeployServiceDialog.this.compContents.getClientArea();
                    int width = area.width - 2 - 2 - 2 * DeployServiceDialog.this.tableNewService.getBorderWidth() - 10;
                    TableColumn[] tableColumns = DeployServiceDialog.this.tableNewService.getColumns();
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            this.tableNewService.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeployServiceDialog.this.tableNewService.setSelection(new int[0]);
                }
            });
        }
        if (!this.servicesToOverwrite.isEmpty()) {
            this.labelTable2 = new Label(this.compContents, 0);
            this.labelTable2.setSize(186, 15);
            this.labelTable2.setText(Xlat.label((String)"DEPLOY_OVERWRITE_SERVICE_TABLE_TITLE") + Xlat.colon());
            GridData gridData = new GridData(4, 0x1000000, true, false, 3, 1);
            this.labelTable2.setLayoutData((Object)gridData);
            this.tableOverwriteService = new Table(this.compContents, 2048);
            this.table2Col1 = new TableColumn(this.tableOverwriteService, 0);
            this.table2Col1.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL1"));
            this.table2Col2 = new TableColumn(this.tableOverwriteService, 0);
            this.table2Col2.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL2"));
            this.table2Col3 = new TableColumn(this.tableOverwriteService, 0);
            this.table2Col3.setText(Xlat.label((String)"DEPLOY_SERVICE_TABLE_COL3"));
            int overwriteServiceRowNum = 0;
            int i3 = 0;
            while (i3 < this.servicesToOverwrite.size()) {
                currController = this.servicesToOverwrite.get(i3);
                tableItem = new TableItem(this.tableOverwriteService, 0);
                tableItem.setText(0, currController.getServiceName());
                tableItem.setText(1, currController.getServiceVersion());
                tableItem.setText(2, currController.getServiceTypeLabel());
                overlay = this.getOverlayImage(currController.getServiceProject());
                if (overlay != null) {
                    tableItem.setImage(0, overlay);
                }
                ++overwriteServiceRowNum;
                ++i3;
            }
            this.tableOverwriteService.setHeaderVisible(true);
            this.tableOverwriteService.setLinesVisible(true);
            gridData = new GridData(4, 0x1000000, true, false, 3, 1);
            if (overwriteServiceRowNum > 7) {
                int tableHeight;
                gridData.heightHint = tableHeight = this.tableOverwriteService.getItemHeight() * 7 + this.tableOverwriteService.getHeaderHeight();
            }
            this.tableOverwriteService.setLayoutData((Object)gridData);
            this.tableOverwriteService.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = DeployServiceDialog.this.compContents.getClientArea();
                    int width = area.width - 2 - 2 - 2 * DeployServiceDialog.this.tableOverwriteService.getBorderWidth() - 10;
                    TableColumn[] tableColumns = DeployServiceDialog.this.tableOverwriteService.getColumns();
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            this.tableOverwriteService.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeployServiceDialog.this.tableOverwriteService.setSelection(new int[0]);
                }
            });
            this.buttonUpdateServices = new Button(this.compContents, 32);
            this.buttonUpdateServices.setText(Xlat.label((String)"DEPLOY_SERVICE_OVERWRITE"));
            gridData = new GridData(16384, 0x1000000, false, false, 3, 1);
            this.buttonUpdateServices.setLayoutData((Object)gridData);
            this.buttonUpdateServices.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeployServiceDialog.this.validateInput();
                }
            });
        }
        this.validateInput();
        XSwt.layout((Composite)this.compContents, (boolean)true);
        XSwt.centerInWorkbench((Shell)this.getShell());
    }

    private Image getOverlayImage(IProject project) {
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int highestSeverity = -1;
            int j = 0;
            while (j < markers.length) {
                Object severity = markers[j].getAttribute("severity");
                if ((Integer)severity == 1) {
                    highestSeverity = 1;
                } else if ((Integer)severity == 2) {
                    highestSeverity = 2;
                    break;
                }
                ++j;
            }
            if (highestSeverity == 2) {
                this.projectsProblems = true;
                return Images.getErrorOverlayImage();
            }
            if (highestSeverity == 1) {
                this.projectsProblems = true;
                return Images.getWarningOverlayImage();
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return null;
    }

    private void createConnectableArea(Composite c) {
        Label l = new Label(c, 0);
        l.setText(Xlat.label((String)"DEPLOY_API_SERVER") + Xlat.colon());
        this.connectionWidgetManager = new ConnectionWidgetManager(this.connectionService, true);
        ConnectionStatus connectionStatus = new ConnectionStatus(c, 0, this.connectionWidgetManager.getConnectionStatusController());
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        connectionStatus.setLayoutData((Object)data);
        this.connectionWidgetManager.setConnectionStateViewer((IConnectionStateViewer)connectionStatus);
        this.connectionWidgetManager.setCurrentCategory("com.ibm.zosconnect.ui.connections.category.adminapi");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        if (this.connectionServiceListener == null) {
            this.connectionServiceListener = new ConnectionServiceListener(){

                public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                    if (event.getConnectionCategoryId().equals("com.ibm.zosconnect.ui.connections.category.adminapi") && XSwt.isNotDisposed((Control)DeployServiceDialog.this.mainComposite)) {
                        DeployServiceDialog.this.mainComposite.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                                        XSwt.disable((Control[])new Control[]{(this).DeployServiceDialog.this.okButton});
                                        Exception e = ((ConnectionServiceListener.ExceptionEvent)event).getException();
                                        ZCeeUILogger.error((Throwable)e);
                                        if (e instanceof AuthenticationException) {
                                            XSwt.dispose((Control)DeployServiceDialog.this.getShell());
                                        }
                                    } else if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                        (this).DeployServiceDialog.this.refreshLock.acquireLock();
                                        (this).DeployServiceDialog.this.selectedConnProfile = event.getConnectionProfile();
                                        DeployServiceDialog.this.updateBasedOnConnectable(event.getConnectable());
                                        XSwt.enable((Control[])new Control[]{(this).DeployServiceDialog.this.buttonUpdateServices});
                                        DeployServiceDialog.this.refreshServiceTables();
                                    } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                        (this).DeployServiceDialog.this.canReachServer = false;
                                        XSwt.disable((Control[])new Control[]{(this).DeployServiceDialog.this.buttonUpdateServices});
                                        (this).DeployServiceDialog.this.selectedConnProfile = null;
                                        DeployServiceDialog.this.updateBasedOnConnectable(event.getConnectable());
                                    }
                                }
                                catch (Exception e) {
                                    (this).DeployServiceDialog.this.refreshLock.releaseLock(false);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.connectionServiceListener;
    }

    private void updateBasedOnConnectable(IConnectable connectable) {
        ConnectionProfile connProfile = this.selectedConnProfile;
        if (connProfile != null) {
            if (connectable != null && !connProfile.getName().equals(connectable.getConnection().getName())) {
                XSwt.disable((Control[])new Control[]{this.okButton});
            } else {
                if (connectable != null && connectable.isConnected()) {
                    XSwt.enable((Control[])new Control[]{this.okButton});
                } else {
                    XSwt.disable((Control[])new Control[]{this.okButton});
                }
                this.selectedConnectable = connectable;
            }
        } else {
            IConnectionState connectionState = this.connectionService.getConnectionState("com.ibm.zosconnect.ui.connections.category.adminapi");
            if (connectionState instanceof ConnectedState && connectable != null && connectable.isConnected()) {
                XSwt.enable((Control[])new Control[]{this.okButton});
                this.selectedConnectable = connectable;
            } else {
                XSwt.disable((Control[])new Control[]{this.okButton});
                this.selectedConnectable = null;
            }
        }
    }

    private void validateInput() {
        this.updateStatus(null);
        if (!this.canReachServer) {
            Status status = new Status(4, "com.ibm.zosconnect.ui", Xlat.error((String)"DEPLOY_SERVER_DISCONNECT"));
            this.updateStatus((IStatus)status);
        } else if (!this.servicesToOverwrite.isEmpty() && !this.buttonUpdateServices.getSelection()) {
            Status status = new Status(4, "com.ibm.zosconnect.ui", Xlat.error((String)"DEPLOY_EXISTING_SERVICE"));
            this.updateStatus((IStatus)status);
        } else if (this.projectsProblems) {
            Status status = new Status(1, "com.ibm.zosconnect.ui", Xlat.error((String)"DEPLOY_WARNING_SERVICES_PROBLEMS"));
            this.updateStatus((IStatus)status);
        }
        XSwt.pack((Control)this.getShell());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
        this.connectionService.addConnectionServiceListener(this.getConnectionServiceListener());
        IConnectable connectable = this.connectionService.getConnectable("com.ibm.zosconnect.ui.connections.category.adminapi");
        this.updateBasedOnConnectable(connectable);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (DeployServiceDialog.this.connectionServiceListener != null) {
                    DeployServiceDialog.this.connectionServiceListener.makeStale();
                }
            }
        });
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (status != null) {
            if (status.getSeverity() == 4) {
                XSwt.disable((Control[])new Control[]{this.okButton});
            } else {
                XSwt.enable((Control[])new Control[]{this.okButton});
            }
        } else if (this.canReachServer) {
            XSwt.enable((Control[])new Control[]{this.okButton});
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Xlat.label((String)"DEPLOY_SERVICE_TITLE"));
    }

    protected void okPressed() {
        try {
            IZCeeAdminApiConnection connection = (IZCeeAdminApiConnection)this.selectedConnectable.getConnection();
            ZosConnectServerNode server = ZosConnectServerNav.getView().getServer((IConnection)connection);
            DeployServicesJob deployJob = new DeployServicesJob(server, this.controller.getProjects(), connection, this.controller);
            deployJob.setUser(true);
            deployJob.schedule();
            super.okPressed();
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public void create() {
        super.create();
        this.validateInput();
        XSwt.centerInWorkbench((Shell)this.getShell());
    }

    protected void cancelPressed() {
        try {
            if (this.refreshJob != null) {
                this.refreshJob.cancel();
                this.refreshJob = null;
            }
            super.cancelPressed();
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }
}

