/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.dialogs;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.programinterface.common.ui.EAMessageControl;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.service.controllers.AdvancedDataConversionOptionsController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.dialogs.AdvancedDataConversionOptionsDialog;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AdvancedDataConversionOptionsComposite
extends Composite
implements ModifyListener,
VerifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TSW_TRIM_OUTPUT_LEADING_WHITESPACE = Xlat.label((String)"TSW_TRIM_OUTPUT_LEADING_WHITESPACE");
    public static final String TSW_TRIM_OUTPUT_TRAILING_WHITESPACE = Xlat.label((String)"TSW_TRIM_OUTPUT_TRAILING_WHITESPACE");
    public static final String TSW_ESCAPE_CONTROL_CHARACTERS = Xlat.label((String)"TSW_ESCAPE_CONTROL_CHARACTERS");
    public static final String TSW_INITIALIZE_INPUT_FIELDS = Xlat.label((String)"TSW_INITIALIZE_INPUT_FIELDS");
    public static final String TSW_ENFORCE_MIN_ARRAY_OCCURRENCE = Xlat.label((String)"TSW_ENFORCE_MIN_ARRAY_OCCURRENCE");
    public static final String TSW_OMIT_FIELDS_BY_VALUE = Xlat.label((String)"TSW_OMIT_FIELDS_BY_VALUE");
    public static final String TSW_OMIT_FIELDS_BY_VALUE_BYTE = Xlat.label((String)"TSW_OMIT_FIELDS_BY_VALUE_BYTE");
    public static final String TSW_OMIT_EMPTY_FIELDS = Xlat.label((String)"TSW_OMIT_EMPTY_FIELDS");
    public static final String TSW_LDS_STARTS_LLZZTRANCODE = Xlat.label((String)"TSW_LDS_STARTS_LLZZTRANCODE");
    public static final String TSW_LDS_STARTS_LLZZ = Xlat.label((String)"TSW_LDS_STARTS_LLZZ");
    public static final String TSW_LDS_TRUNC_INPUT_LAST_CHAR_FIELD = Xlat.label((String)"TSW_LDS_TRUNC_INPUT_LAST_CHAR_FIELD");
    public static final String TSW_IMS_TRUNC_INPUT_LAST_CHAR_FIELD = Xlat.label((String)"TSW_IMS_TRUNC_INPUT_LAST_CHAR_FIELD");
    public static final String TSW_TRIM_OUTPUT_LEADING_WHITESPACE_HOVERTEXT = Xlat.description((String)"TSW_TRIM_OUTPUT_LEADING_WHITESPACE_HOVERTEXT");
    public static final String TSW_TRIM_OUTPUT_TRAILING_WHITESPACE_HOVERTEXT = Xlat.description((String)"TSW_TRIM_OUTPUT_TRAILING_WHITESPACE_HOVERTEXT");
    public static final String TSW_ESCAPE_CONTROL_CHARACTERS_HOVERTEXT = Xlat.description((String)"TSW_ESCAPE_CONTROL_CHARACTERS_HOVERTEXT");
    public static final String TSW_INITIALIZE_INPUT_FIELDS_HOVERTEXT = Xlat.description((String)"TSW_INITIALIZE_INPUT_FIELDS_HOVERTEXT");
    public static final String TSW_ENFORCE_MIN_ARRAY_OCCURRENCE_HOVERTEXT = Xlat.description((String)"TSW_ENFORCE_MIN_ARRAY_OCCURRENCE_HOVERTEXT");
    public static final String TSW_OMIT_FIELDS_BY_VALUE_HOVERTEXT = Xlat.description((String)"TSW_OMIT_FIELDS_BY_VALUE_HOVERTEXT");
    public static final String TSW_OMIT_FIELDS_BY_VALUE_BYTE_HOVERTEXT = Xlat.description((String)"TSW_OMIT_FIELDS_BY_VALUE_BYTE_HOVERTEXT");
    public static final String TSW_OMIT_EMPTY_FIELDS_HOVERTEXT = Xlat.description((String)"TSW_OMIT_EMPTY_FIELDS_HOVERTEXT");
    public static final String TSW_ENFORCE_MIN_ARRAY_OCCURRENCE_RESPONSE_HOVERTEXT = Xlat.description((String)"TSW_ENFORCE_MIN_ARRAY_OCCURRENCE_RESPONSE_HOVERTEXT");
    public static final String TSW_LDS_STARTS_LLZZTRANCODE_HOVERTEXT = Xlat.description((String)"TSW_LDS_STARTS_LLZZTRANCODE_HOVERTEXT");
    public static final String TSW_LDS_STARTS_LLZZ_HOVERTEXT = Xlat.description((String)"TSW_LDS_STARTS_LLZZ_HOVERTEXT");
    public static final String TSW_LDS_TRUNC_INPUT_LAST_CHAR_FIELD_HOVERTEXT = Xlat.description((String)"TSW_LDS_TRUNC_INPUT_LAST_CHAR_FIELD_HOVERTEXT");
    public static final String TSW_IMS_TRUNC_INPUT_LAST_CHAR_FIELD_HOVERTEXT = Xlat.description((String)"TSW_IMS_TRUNC_INPUT_LAST_CHAR_FIELD_HOVERTEXT");
    private static Logger logger;
    private EAMessageControl msgControl = null;
    private HashMap<Control, String> errorMessages = new HashMap();
    private Button trimOutLead;
    private Button trimOutTrail;
    private Button escControlChars;
    private Button initInputFields;
    private Button enforceMinArray;
    private Button ldsStartsLLZZTRANCODE;
    private Button omitFields;
    private Button omitEmptyFields;
    private Text omitFieldBytes;
    private Button enforceMinArrayResponse;
    private Button ldsStartsLLZZ;
    private Button truncateInputLastCharField;
    private Control currentControl = null;
    private AdvancedDataConversionOptionsController controller;
    private AdvancedDataConversionOptionsDialog parentDialog;
    private boolean canUseLds;

    public AdvancedDataConversionOptionsComposite(AdvancedDataConversionOptionsDialog parentDialog, Composite parent, AdvancedDataConversionOptionsController selectAdvMobDataConvOpController) {
        super(parent, 0);
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.controller = selectAdvMobDataConvOpController;
        this.parentDialog = parentDialog;
        this.createControl();
    }

    private void createControl() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)");
        try {
            GridLayout gl_this = new GridLayout(1, false);
            gl_this.marginBottom = XSwt.getFontHeight((Control)this);
            this.setLayout((Layout)gl_this);
            this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
            Group inputGroup = new Group((Composite)this, 0);
            inputGroup.setText(Xlat.label((String)"MDCO_INPUT_GROUP"));
            GridLayout gl_inputGroup = new GridLayout(1, false);
            gl_inputGroup.marginTop = 5;
            gl_inputGroup.marginBottom = 5;
            inputGroup.setLayout((Layout)gl_inputGroup);
            inputGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.initInputFields = new Button((Composite)inputGroup, 32);
            this.initInputFields.setText(TSW_INITIALIZE_INPUT_FIELDS);
            this.initInputFields.setToolTipText(TSW_INITIALIZE_INPUT_FIELDS_HOVERTEXT);
            this.enforceMinArray = new Button((Composite)inputGroup, 32);
            this.enforceMinArray.setText(TSW_ENFORCE_MIN_ARRAY_OCCURRENCE);
            this.enforceMinArray.setToolTipText(TSW_ENFORCE_MIN_ARRAY_OCCURRENCE_HOVERTEXT);
            IServiceModelController serviceModelController = this.controller.getServiceModelController();
            String serviceType = serviceModelController.getValue("servicetype");
            if (serviceType.equals("imsLargeDataStructure") || serviceType.equals("imsMessageSegment")) {
                this.canUseLds = true;
            }
            if (this.canUseLds) {
                this.ldsStartsLLZZTRANCODE = new Button((Composite)inputGroup, 32);
                this.ldsStartsLLZZTRANCODE.setText(TSW_LDS_STARTS_LLZZTRANCODE);
                this.ldsStartsLLZZTRANCODE.setToolTipText(TSW_LDS_STARTS_LLZZTRANCODE_HOVERTEXT);
            }
            if (serviceType.equals("imsLargeDataStructure")) {
                this.truncateInputLastCharField = new Button((Composite)inputGroup, 32);
                this.truncateInputLastCharField.setText(TSW_LDS_TRUNC_INPUT_LAST_CHAR_FIELD);
                this.truncateInputLastCharField.setToolTipText(TSW_LDS_TRUNC_INPUT_LAST_CHAR_FIELD_HOVERTEXT);
            } else if (serviceType.equals("imsMessageSegment")) {
                this.truncateInputLastCharField = new Button((Composite)inputGroup, 32);
                this.truncateInputLastCharField.setText(TSW_IMS_TRUNC_INPUT_LAST_CHAR_FIELD);
                this.truncateInputLastCharField.setToolTipText(TSW_IMS_TRUNC_INPUT_LAST_CHAR_FIELD_HOVERTEXT);
            }
            Group outputGroup = new Group((Composite)this, 0);
            outputGroup.setText(Xlat.label((String)"MDCO_OUTPUT_GROUP"));
            GridLayout gl_outputGroup = new GridLayout(2, false);
            gl_outputGroup.marginTop = 5;
            gl_outputGroup.marginBottom = 5;
            outputGroup.setLayout((Layout)gl_outputGroup);
            outputGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.trimOutLead = new Button((Composite)outputGroup, 32);
            this.trimOutLead.setText(TSW_TRIM_OUTPUT_LEADING_WHITESPACE);
            this.trimOutLead.setToolTipText(TSW_TRIM_OUTPUT_LEADING_WHITESPACE_HOVERTEXT);
            this.trimOutLead.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            this.trimOutTrail = new Button((Composite)outputGroup, 32);
            this.trimOutTrail.setText(TSW_TRIM_OUTPUT_TRAILING_WHITESPACE);
            this.trimOutTrail.setToolTipText(TSW_TRIM_OUTPUT_TRAILING_WHITESPACE_HOVERTEXT);
            this.trimOutTrail.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            this.escControlChars = new Button((Composite)outputGroup, 32);
            this.escControlChars.setText(TSW_ESCAPE_CONTROL_CHARACTERS);
            this.escControlChars.setToolTipText(TSW_ESCAPE_CONTROL_CHARACTERS_HOVERTEXT);
            this.escControlChars.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            this.omitFields = new Button((Composite)outputGroup, 32);
            this.omitFields.setText(TSW_OMIT_FIELDS_BY_VALUE);
            this.omitFields.setToolTipText(TSW_OMIT_FIELDS_BY_VALUE_HOVERTEXT);
            this.omitFields.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            Composite omitFieldComp = new Composite((Composite)outputGroup, 0);
            GridLayout gl_omitFieldComp = new GridLayout(2, false);
            omitFieldComp.setLayout((Layout)gl_omitFieldComp);
            omitFieldComp.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            Label omitFieldsLabel = new Label(omitFieldComp, 0);
            omitFieldsLabel.setText(Xlat.label((String)"TSW_OMIT_FIELDS_BY_VALUE_BYTE"));
            omitFieldsLabel.setToolTipText(TSW_OMIT_FIELDS_BY_VALUE_BYTE_HOVERTEXT);
            GridData gd_omitFieldsLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_omitFieldsLabel.horizontalIndent = 20;
            omitFieldsLabel.setLayoutData((Object)gd_omitFieldsLabel);
            this.omitFieldBytes = new Text(omitFieldComp, 2048);
            this.omitFieldBytes.setTextLimit(2);
            this.omitFieldBytes.setToolTipText(TSW_OMIT_FIELDS_BY_VALUE_BYTE_HOVERTEXT);
            this.omitFieldBytes.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            this.omitEmptyFields = new Button((Composite)outputGroup, 32);
            this.omitEmptyFields.setText(TSW_OMIT_EMPTY_FIELDS);
            this.omitEmptyFields.setToolTipText(TSW_OMIT_EMPTY_FIELDS_HOVERTEXT);
            this.omitEmptyFields.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            this.enforceMinArrayResponse = new Button((Composite)outputGroup, 32);
            this.enforceMinArrayResponse.setText(TSW_ENFORCE_MIN_ARRAY_OCCURRENCE);
            this.enforceMinArrayResponse.setToolTipText(TSW_ENFORCE_MIN_ARRAY_OCCURRENCE_RESPONSE_HOVERTEXT);
            this.enforceMinArrayResponse.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            if (this.canUseLds) {
                this.ldsStartsLLZZ = new Button((Composite)outputGroup, 32);
                this.ldsStartsLLZZ.setText(TSW_LDS_STARTS_LLZZ);
                this.ldsStartsLLZZ.setToolTipText(TSW_LDS_STARTS_LLZZ_HOVERTEXT);
            }
            this.initialize();
            this.addListeners();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            EclipseLogger.logError((Throwable)e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)");
    }

    public void initialize() {
        if (this.msgControl != null) {
            this.createErrorMessageControl();
        }
        if (this.controller != null) {
            this.trimOutLead.setSelection(this.controller.getTrimOutputLeadingWhitespace());
            this.trimOutTrail.setSelection(this.controller.getTrimOutputTrailingWhitespace());
            this.escControlChars.setSelection(this.controller.getEscapeControlCharacters());
            this.initInputFields.setSelection(this.controller.getInitializeInputField());
            this.enforceMinArray.setSelection(this.controller.getEnforceMinArrayOccurrence());
            this.omitFields.setSelection(this.controller.getOmitFieldsByValue());
            String omitOutputFieldsByValueByte = this.controller.getOmitFieldsByValueByte();
            this.omitFieldBytes.setText(omitOutputFieldsByValueByte);
            if (this.omitFields.getSelection()) {
                this.omitFieldBytes.setEnabled(true);
            } else {
                this.omitFieldBytes.setEnabled(false);
            }
            this.omitEmptyFields.setSelection(this.controller.getOmitOutputEmptyTags());
            this.enforceMinArrayResponse.setSelection(this.controller.getEnforceMinArrayOccurrenceResponse());
            if (this.canUseLds) {
                this.ldsStartsLLZZTRANCODE.setSelection(this.controller.getLdsStartsWithLLZZTRANCODE());
                this.ldsStartsLLZZ.setSelection(this.controller.getLdsStartsWithLLZZ());
                this.truncateInputLastCharField.setSelection(this.controller.getTruncateInputLastCharField());
            }
        }
    }

    private void createErrorMessageControl() {
        this.msgControl.removeControl((Control)this.omitFieldBytes);
        this.msgControl.removeControl((Control)this.omitFields);
    }

    private void removeErrorMessageControl() {
        this.msgControl.removeControl((Control)this.omitFieldBytes);
        this.msgControl.removeControl((Control)this.omitFields);
    }

    private void addListeners() {
        this.initInputFields.addSelectionListener((SelectionListener)this);
        this.enforceMinArray.addSelectionListener((SelectionListener)this);
        this.trimOutLead.addSelectionListener((SelectionListener)this);
        this.trimOutTrail.addSelectionListener((SelectionListener)this);
        this.escControlChars.addSelectionListener((SelectionListener)this);
        this.omitFields.addSelectionListener((SelectionListener)this);
        this.omitFieldBytes.addVerifyListener((VerifyListener)this);
        this.omitFieldBytes.addModifyListener((ModifyListener)this);
        this.omitEmptyFields.addSelectionListener((SelectionListener)this);
        this.enforceMinArrayResponse.addSelectionListener((SelectionListener)this);
        if (this.canUseLds) {
            this.ldsStartsLLZZTRANCODE.addSelectionListener((SelectionListener)this);
            this.ldsStartsLLZZ.addSelectionListener((SelectionListener)this);
            this.truncateInputLastCharField.addSelectionListener((SelectionListener)this);
        }
    }

    private void removeListeners() {
        this.initInputFields.removeSelectionListener((SelectionListener)this);
        this.trimOutLead.removeSelectionListener((SelectionListener)this);
        this.trimOutTrail.removeSelectionListener((SelectionListener)this);
        this.escControlChars.removeSelectionListener((SelectionListener)this);
        this.omitFields.removeSelectionListener((SelectionListener)this);
        this.omitFieldBytes.removeVerifyListener((VerifyListener)this);
        this.omitFieldBytes.removeModifyListener((ModifyListener)this);
        this.omitEmptyFields.removeSelectionListener((SelectionListener)this);
        if (this.canUseLds) {
            this.ldsStartsLLZZTRANCODE.removeSelectionListener((SelectionListener)this);
            this.ldsStartsLLZZ.removeSelectionListener((SelectionListener)this);
            this.truncateInputLastCharField.removeSelectionListener((SelectionListener)this);
        }
    }

    private void disposeWidgets() {
        this.trimOutLead.dispose();
        this.trimOutTrail.dispose();
        this.escControlChars.dispose();
        this.initInputFields.dispose();
        this.enforceMinArray.dispose();
        this.omitFields.dispose();
        this.omitEmptyFields.dispose();
        this.omitFieldBytes.dispose();
        this.enforceMinArrayResponse.dispose();
        if (this.canUseLds) {
            this.ldsStartsLLZZTRANCODE.dispose();
            this.ldsStartsLLZZ.dispose();
            this.truncateInputLastCharField.dispose();
        }
    }

    public void dispose() {
        this.removeListeners();
        if (this.msgControl != null) {
            this.removeErrorMessageControl();
        }
        this.disposeWidgets();
        super.dispose();
    }

    public void modifyText(ModifyEvent event) {
        try {
            String errorMessage = null;
            this.currentControl = (Control)event.widget;
            if (event.widget == this.omitFieldBytes && this.omitFields.getSelection()) {
                String omitFieldBytesText = this.omitFieldBytes.getText().trim();
                if (omitFieldBytesText.isEmpty()) {
                    errorMessage = Xlat.error((String)"TSW_MISSING_BYTE");
                } else if (omitFieldBytesText.length() == 1) {
                    errorMessage = !omitFieldBytesText.matches("^[0-9a-fA-F]+$") ? Xlat.error((String)"TSW_INVALID_BYTE") : Xlat.error((String)"TSW_MISSING_BYTE");
                } else if (!omitFieldBytesText.matches("^[0-9a-fA-F]+$")) {
                    errorMessage = Xlat.error((String)"TSW_INVALID_BYTE");
                } else {
                    this.controller.setOmitFieldsByValueByte(omitFieldBytesText);
                }
            }
            this.parentDialog.setOptionsErrorMessage(errorMessage);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent event)", e);
            EclipseLogger.logError((Throwable)e);
        }
    }

    public String getErrorMessage() {
        String retVal = null;
        int numberOfErrors = this.errorMessages.size();
        if (numberOfErrors > 0) {
            if (this.currentControl != null) {
                retVal = this.errorMessages.get(this.currentControl);
            }
            if (retVal == null) {
                retVal = this.errorMessages.entrySet().iterator().next().getValue();
            }
        }
        return retVal;
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.widget == this.omitFieldBytes && event.character >= 'a' && event.character <= 'f') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            EclipseLogger.logError((Throwable)e);
        }
    }

    public void addChildListener(Control control, ModifyListener modifyListener) {
        if (control instanceof Combo || control instanceof Text) {
            if (control instanceof Combo) {
                ((Combo)control).addModifyListener(modifyListener);
            } else {
                ((Text)control).addModifyListener(modifyListener);
            }
        } else if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                this.addChildListener(childControl, modifyListener);
                ++n2;
            }
        }
    }

    public void widgetSelected(SelectionEvent event) {
        try {
            if (event.widget == this.initInputFields) {
                this.controller.setInitializeInputField(this.initInputFields.getSelection());
            } else if (event.widget == this.enforceMinArray) {
                this.controller.setEnforceMinArrayOccurrence(this.enforceMinArray.getSelection());
            } else if (event.widget == this.trimOutLead) {
                this.controller.setTrimOutputLeadingWhitespace(this.trimOutLead.getSelection());
            } else if (event.widget == this.trimOutTrail) {
                this.controller.setTrimOutputTrailingWhitespace(this.trimOutTrail.getSelection());
            } else if (event.widget == this.escControlChars) {
                this.controller.setEscapeControlCharacters(this.escControlChars.getSelection());
            } else if (event.widget == this.omitFields) {
                if (this.omitFields.getSelection()) {
                    this.controller.setOmitFieldsByValue(true);
                    this.omitFieldBytes.setEnabled(true);
                } else {
                    this.controller.setOmitFieldsByValue(false);
                    this.omitFieldBytes.setEnabled(false);
                }
            } else if (event.widget == this.omitEmptyFields) {
                this.controller.setOmitOutputEmptyTags(this.omitEmptyFields.getSelection());
            } else if (event.widget == this.enforceMinArrayResponse) {
                this.controller.setEnforceMinArrayOccurrenceResponse(this.enforceMinArrayResponse.getSelection());
            } else if (event.widget == this.ldsStartsLLZZTRANCODE) {
                this.controller.setLdsStartsWithLLZZTRANCODE(this.ldsStartsLLZZTRANCODE.getSelection());
            } else if (event.widget == this.ldsStartsLLZZ) {
                this.controller.setLdsStartsWithLLZZ(this.ldsStartsLLZZ.getSelection());
            } else if (event.widget == this.truncateInputLastCharField) {
                this.controller.setTruncateInputLastCharField(this.truncateInputLastCharField.getSelection());
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent event)", e);
            EclipseLogger.logError((Throwable)e);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
}

