/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.builders;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceBuilder;
import com.ibm.zosconnect.wv.sar.generator.WVArtifactGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WVBuilderImpl
implements IServiceBuilder {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String c = this.getClass().getName();

    public void build(ServiceProjectController serviceProjectController) {
        String methodName = "build";
        ZCeeUILogger.entering((String)this.c, (String)"build", (Object[])new Object[0]);
        try {
            serviceProjectController.getFolder("bin").delete(true, (IProgressMonitor)new NullProgressMonitor());
            WVArtifactGenerator.generateBinArtifacts((String)serviceProjectController.getProject().getLocation().toOSString(), (boolean)true);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)this.c, (String)"build", (Object[])new Object[0]);
    }

    public Set<String> getNewProjectFolderNames() {
        HashSet<String> names = new HashSet<String>();
        names.add("service-interfaces");
        names.add("bin");
        return names;
    }

    public List<IPath> getBuildOutputFolderPaths() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        paths.add((IPath)new Path("bin"));
        paths.add(new Path("bin").append("schemas"));
        return paths;
    }
}

