/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.builders;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.common.validation.ValidationUtil;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceBuilder;
import com.ibm.zosconnect.ui.service.validation.ServiceProjectValidator;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ServiceProjectBuilder
extends IncrementalProjectBuilder {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = ((Object)((Object)this)).getClass().getName();
    private ServiceProjectValidator serviceProjectValidator = null;
    private ServiceProjectController serviceProjectController = null;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        String methodName = "build";
        ZCeeUILogger.entering((String)this.className, (String)"build", (Object[])new Object[]{kind, args});
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (MessageWalkerException | IOException | JAXBException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.zosconnect.ui.service", e.getMessage(), e));
        }
        ZCeeUILogger.exiting((String)this.className, (String)"build", (Object[])new Object[]{kind, args});
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException, JAXBException, MessageWalkerException, IOException {
        this.fullBuild(monitor);
    }

    private void fullBuild(IProgressMonitor monitor) throws CoreException, JAXBException, MessageWalkerException, IOException {
        String methodName = "fullBuild";
        ZCeeUILogger.entering((String)this.className, (String)"fullBuild", (Object[])new Object[0]);
        this.validateProject(this.getProject());
        if (this.getProject().findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2) < 2) {
            this.buildProject();
        }
        ZCeeUILogger.exiting((String)this.className, (String)"fullBuild", (Object[])new Object[0]);
    }

    private void buildProject() throws CoreException, JAXBException, MessageWalkerException, IOException {
        String methodName = "buildProject";
        ZCeeUILogger.entering((String)this.className, (String)"buildProject", (Object[])new Object[0]);
        try {
            IServiceBuilder builderImpl = this.serviceProjectController.getServiceModel().getServiceExtension().getBuilderClass();
            if (builderImpl != null) {
                builderImpl.build(this.serviceProjectController);
            } else {
                ZCeeUILogger.info((String)"No builder class provided for the current service type.", (Object[])new Object[0]);
            }
        }
        catch (CoreException ce) {
            ZCeeUILogger.error((Throwable)ce);
            ZCeeErrorDialog.openError((Exception)((Object)ce));
        }
        this.serviceProjectController.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        ZCeeUILogger.exiting((String)this.className, (String)"buildProject", (Object[])new Object[0]);
    }

    private void validateProject(IProject project) throws CoreException, IOException {
        String methodName = "validateProject";
        ZCeeUILogger.entering((String)this.className, (String)"validateProject", (Object[])new Object[]{project});
        project.deleteMarkers(ServiceProjectMarkerTypes.PROJECT_PROBLEM.toString(), true, 2);
        this.validateServicePropertiesFile();
        this.validateCapabilities();
        ZCeeUILogger.exiting((String)this.className, (String)"validateProject", (Object[])new Object[]{project});
    }

    private void validateCapabilities() throws CoreException, IOException {
        String methodName = "validateCapabilities";
        ZCeeUILogger.entering((String)this.className, (String)"validateCapabilities", (Object[])new Object[0]);
        this.getValidator();
        if (this.serviceProjectValidator != null) {
            List<ServiceProjectValidationError> errors = this.serviceProjectValidator.validateCapabilitiesFile();
            if (errors.isEmpty()) {
                this.serviceProjectValidator.updateProjectCapabilities();
            } else {
                this.addMarkersFor(errors);
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateCapabilities", (Object[])new Object[0]);
    }

    private void validateServicePropertiesFile() throws CoreException {
        String methodName = "validateServicePropertiesFile";
        ZCeeUILogger.entering((String)this.className, (String)"validateServicePropertiesFile", (Object[])new Object[0]);
        this.getValidator();
        if (this.serviceProjectValidator != null) {
            this.addMarkersFor(this.serviceProjectValidator.validateServicePropertiesFile());
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateServicePropertiesFile", (Object[])new Object[0]);
    }

    private void addMarkersFor(List<ServiceProjectValidationError> errors) {
        String methodName = "addMarkersFor";
        ZCeeUILogger.entering((String)this.className, (String)"addMarkersFor", (Object[])new Object[0]);
        for (ServiceProjectValidationError error : errors) {
            try {
                ValidationUtil.createMarker((String)error.getMarkerType(), (IResource)error.getResource(), (String)error.getBareMessage(), (Integer)error.getLineNumber(), (Integer)error.getColumnNumber(), (int)error.getSeverity(), (Map)error.getAttributes());
                ZCeeUILogger.info((String)"Created new error marker", (Object[])new Object[]{error.getMarkerType(), error.getResource(), error.getBareMessage(), error.getSeverity()});
            }
            catch (CoreException e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"addMarkersFor", (Object[])new Object[0]);
    }

    protected void startupOnInitialize() {
        try {
            this.getValidator();
        }
        catch (CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void getValidator() throws CoreException {
        IProject project = this.getProject();
        if (this.serviceProjectValidator == null && project != null) {
            this.serviceProjectController = new ServiceProjectController(project);
            this.serviceProjectValidator = new ServiceProjectValidator(project, this.serviceProjectController);
        }
    }

    protected void clean(IProgressMonitor monitor) {
        String methodName = "clean";
        ZCeeUILogger.entering((String)this.className, (String)"clean", (Object[])new Object[0]);
        try {
            this.serviceProjectController.getFolder("bin").delete(true, monitor);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        try {
            this.serviceProjectController.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"clean", (Object[])new Object[0]);
    }
}

