/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ServiceProjectNature;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.editors.listeners.ServiceProjectImportListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ZCeeUIServicePluginEarlyStartup
implements IStartup {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ZCeeUIServicePluginEarlyStartup.class.getName();

    public void earlyStartup() {
        ZCeeUILogger.entering((String)TAG, (String)"earlyStartup()", (Object[])new Object[0]);
        ZCeeUILogger.info((String)"Register ServiceProjectImportListener...", (Object[])new Object[0]);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ServiceProjectImportListener serviceProjectImportListener = new ServiceProjectImportListener();
        workspace.addResourceChangeListener((IResourceChangeListener)serviceProjectImportListener);
        ZCeeUILogger.info((String)"Migrate and build all service projects to detect errors...", (Object[])new Object[0]);
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject currProject = iProjectArray[n2];
            try {
                if (currProject.isOpen() && ServiceProjectNature.hasNature((IProject)currProject)) {
                    new WorkspaceJob(Xlat.description((String)"STATUS_UPDATING_SERVICE_PROJECT", (String[])new String[]{currProject.getName()})){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            try {
                                currProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                currProject.build(6, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                ZCeeUILogger.error((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            ++n2;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ZCeeUILogger.info((String)"Activating service and service interface editor instances that were left open when the workbench closed...", (Object[])new Object[0]);
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editor = iEditorReferenceArray[n6];
                            if ("com.ibm.zosconnect.ui.service.serviceprojecteditor".equals(editor.getId()) || "com.ibm.zosconnect.editors.programinterface".equals(editor.getId())) {
                                editor.getEditor(true);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        ZCeeUILogger.exiting((String)TAG, (String)"earlyStartup()", (Object[])new Object[0]);
    }
}

