/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.util;

import com.ibm.zcc.etools.wrd.extensions.WRDExtensionPlugin;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelAnnotationTagHandlerRegistry;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.PlatformURLMetaPluginConnection;
import com.ibm.zcc.etools.wrd.model.extensions.WRDExtensionsFactory;
import com.ibm.zcc.etools.wrd.model.extensions.WsEMFLinker;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emf.utilities.IDUtil;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.osgi.framework.Bundle;

public class AnnotationUtil {
    private static final String MARKER_SUFFIX = "_MARKER";
    private static final String RANGE_SUFFIX = "_RANGE";
    public static final AnnotationUtil INSTANCE = new AnnotationUtil();
    public static final String ANNOTATION_TO_MODEL_ADAPTER_KEY = "ANNOTATION_TO_MODEL_ADAPTER_KEY";
    public static final String ANNOTATION_OLD_CONTAINER_ADAPTER_KEY = "ANNOTATION_OLD_CONTAINER_KEY";
    private Map saveMetaOptions;
    public static final String JAVA_IDENTIFIER = "id";
    public static final String SOURCE_LINE_NUMBER = "line";

    protected AnnotationUtil() {
    }

    public String getJavaElementIDFromDoclet(EObject docletObject) {
        return this.getJavaElementIDFromAnnotation(this.getEAnnotationFromDoclet(docletObject));
    }

    private String getJavaElementIDFromAnnotation(EAnnotation eAnnotation) {
        if (eAnnotation == null) {
            return null;
        }
        return (String)eAnnotation.getDetails().get((Object)JAVA_IDENTIFIER);
    }

    public IJavaElement getJavaElement(EModelElement javaClass, String annotationID) {
        String id = this.getJavaElementIDFromClass(javaClass, annotationID);
        return id == null ? null : JavaCore.create((String)id);
    }

    private String getJavaElementIDFromClass(EModelElement javaClass, String annotationID) {
        return this.getJavaElementIDFromAnnotation(javaClass.getEAnnotation(annotationID));
    }

    private EAnnotation getEAnnotationFromDoclet(EObject docletObject) {
        return (EAnnotation)this.getContainerFromDoclet(docletObject, EcorePackage.eINSTANCE.getEAnnotation());
    }

    private EObject getContainerFromDoclet(EObject docletObject, EClass containerType) {
        if (docletObject == null) {
            return null;
        }
        EObject parent = docletObject;
        while (parent != null && parent.eClass() != containerType) {
            parent = this.getExistingOrOldContainer(parent);
        }
        return parent;
    }

    public EObject getExistingOrOldContainer(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EObject container = eObject.eContainer();
        return container == null ? this.getOldContainer(eObject) : container;
    }

    private EObject getOldContainer(EObject eObject) {
        OldContainerInfo info = (OldContainerInfo)EcoreUtil.getExistingAdapter((Notifier)eObject, (Object)ANNOTATION_OLD_CONTAINER_ADAPTER_KEY);
        if (info != null) {
            return info.getOldContainer();
        }
        return null;
    }

    public void delete(EObject eObject) {
        if (this.preDelete(eObject)) {
            this.doDelete(eObject);
        }
    }

    public boolean preDelete(EObject eObject) {
        if (eObject == null) {
            return false;
        }
        Resource res = eObject.eResource();
        if (res == null) {
            return false;
        }
        ExtendedEcoreUtil.becomeProxy((EObject)eObject, (Resource)res);
        this.cacheOldContainer(eObject);
        return true;
    }

    public boolean simplePreDelete(EObject eObject) {
        if (this.simpleBecomeProxy(eObject)) {
            this.cacheOldContainer(eObject);
            return true;
        }
        return false;
    }

    public boolean simpleBecomeProxy(EObject eObject) {
        if (eObject == null) {
            return false;
        }
        Resource res = eObject.eResource();
        if (res == null) {
            return false;
        }
        String id = res.getURIFragment(eObject);
        if (id != null) {
            ((InternalEObject)eObject).eSetProxyURI(res.getURI().appendFragment(id));
            if (res instanceof XMLResource) {
                ((XMLResource)res).getIDToEObjectMap().remove(id);
                ((XMLResource)res).getEObjectToIDMap().remove(eObject);
            }
        }
        return true;
    }

    private void doDelete(EObject eObject) {
        EObject container = eObject.eContainer();
        if (container == null) {
            return;
        }
        EStructuralFeature sf = eObject.eContainingFeature();
        if (sf.isMany()) {
            ((List)container.eGet(sf)).remove(eObject);
        } else {
            container.eUnset(sf);
        }
    }

    public EClass getJavaClassFromDoclet(EObject docletObject) {
        return (EClass)this.getContainerFromDoclet(docletObject, EcorePackage.eINSTANCE.getEClass());
    }

    public IResource getResourceFromDoclet(EObject docletObject) {
        IJavaElement element = this.getJavaElementFromDoclet(docletObject);
        try {
            return element == null || !element.exists() ? null : element.getUnderlyingResource();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IFile getFileFromDoclet(EObject docletObject) {
        IJavaElement element = this.getJavaElementFromDoclet(docletObject);
        try {
            return element == null ? null : (IFile)element.getUnderlyingResource();
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
            return null;
        }
    }

    public IJavaElement getJavaElementFromDoclet(EObject docletObject) {
        String id = this.getJavaElementIDFromDoclet(docletObject);
        return id == null ? null : JavaCore.create((String)id);
    }

    public void linkDomains(EObject docletObject, EObject modelObject) {
        if (docletObject == null || modelObject == null) {
            return;
        }
        WsEMFLinker linker = WRDExtensionsFactory.eINSTANCE.getOrCreateRightLinker(modelObject, ANNOTATION_TO_MODEL_ADAPTER_KEY);
        linker.getLeftDomain().add((Object)docletObject);
        this.cacheLinker(linker);
    }

    public void linkDomains(EObject docletObject, EObject modelObject, boolean createID) {
        if (createID) {
            IDUtil.assignID((EObject)modelObject);
        }
        this.linkDomains(docletObject, modelObject);
    }

    public void linkDomains(EObject docletObject, EObject oldModelObject, EObject newModelObject) {
        if (docletObject == null || oldModelObject == null || newModelObject == null) {
            return;
        }
        this.linkDomains(docletObject, newModelObject);
        WsEMFLinker linker = (WsEMFLinker)EcoreUtil.getExistingAdapter((Notifier)docletObject, (Object)ANNOTATION_TO_MODEL_ADAPTER_KEY);
        if (linker != null) {
            linker.getLeftDomain().add((Object)docletObject);
            linker.setRightDomain(newModelObject);
        }
    }

    private void cacheLinker(WsEMFLinker linker) {
        IProject proj;
        if (linker.eResource() == null && (proj = this.getProject(linker.getRightDomain())) != null) {
            try {
                Resource res = this.getOrCreateMetaResource(DynamicModelAnnotationTagHandlerRegistry.ANNOTATION_LINKERS_RES_URI, proj, WRDExtensionPlugin.getDefault().getBundle());
                res.getContents().add((Object)linker);
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    public List getDocletObjects(EObject modelObject) {
        WsEMFLinker linker = (WsEMFLinker)EcoreUtil.getExistingAdapter((Notifier)modelObject, (Object)ANNOTATION_TO_MODEL_ADAPTER_KEY);
        return linker == null ? null : linker.getLeftDomain();
    }

    public EObject getModelObject(EObject docletObject) {
        WsEMFLinker linker = (WsEMFLinker)EcoreUtil.getExistingAdapter((Notifier)docletObject, (Object)ANNOTATION_TO_MODEL_ADAPTER_KEY);
        return linker == null ? null : linker.getRightDomain();
    }

    public boolean hasAnyEAnnotationsForDoclet(EClass javaClass, String annotationSource) {
        if (javaClass == null) {
            return false;
        }
        return this.hasEAnnotation((EModelElement)javaClass, annotationSource) || this.hasEAnnotation(javaClass.getEOperations(), annotationSource) || this.hasEAnnotation(javaClass.getEAttributes(), annotationSource);
    }

    private boolean hasEAnnotation(EList modelElements, String annotationSource) {
        if (modelElements.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < modelElements.size()) {
            EModelElement element = (EModelElement)modelElements.get(i);
            if (this.hasEAnnotation(element, annotationSource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasEAnnotation(EModelElement element, String annotationSource) {
        return element.getEAnnotation(annotationSource) != null;
    }

    public void cacheDocletRange(EAnnotation eAnnotation, EObject docletObject, TagData tagData) {
        if (docletObject == null || eAnnotation == null) {
            return;
        }
        String range = String.valueOf(tagData.getTagStart()) + "-" + tagData.getTagEnd();
        String rangeKey = this.getEAnnotationDetailsRangeKey(docletObject);
        if (rangeKey == null) {
            return;
        }
        eAnnotation.getDetails().put((Object)rangeKey, (Object)range);
    }

    private String getEAnnotationDetailsRangeKey(EObject docletObject) {
        String frag = this.getURIFragment(docletObject);
        if (frag != null) {
            frag = String.valueOf(frag) + RANGE_SUFFIX;
        }
        return frag;
    }

    private String getEAnnotationDetailsMarkerKey(EObject docletObject) {
        String frag = this.getURIFragment(docletObject);
        if (frag != null) {
            frag = String.valueOf(frag) + MARKER_SUFFIX;
        }
        return frag;
    }

    private String getURIFragment(EObject docletObject) {
        if (docletObject.eIsProxy()) {
            URI proxyURI = ((InternalEObject)docletObject).eProxyURI();
            return proxyURI.fragment();
        }
        Resource res = docletObject.eResource();
        if (res != null) {
            return res.getURIFragment(docletObject);
        }
        return null;
    }

    public void createDocletErrorMarker(String markerId, String message, EObject docletObject) {
        this.createDocletProblemMarker(markerId, 2, message, docletObject);
    }

    public void createDocletWarningMarker(String markerId, String message, EObject docletObject) {
        this.createDocletProblemMarker(markerId, 1, message, docletObject);
    }

    public void createDocletInfoMarker(String markerId, String message, EObject docletObject) {
        this.createDocletProblemMarker(markerId, 0, message, docletObject);
    }

    public void createProblemMarker(String markerId, int severity, String message, TagData tagData) {
        this.createDocletProblemMarker(markerId, severity, message, (IResource)tagData.getResource(), tagData.getTagStart(), tagData.getTagEnd());
    }

    private void createDocletProblemMarker(String markerId, int severity, String message, EObject docletObject) {
        if (docletObject == null || message == null) {
            return;
        }
        IResource resourceFile = this.getResourceFromDoclet(docletObject);
        if (resourceFile == null) {
            return;
        }
        EAnnotation annotation = this.getEAnnotationFromDoclet(docletObject);
        if (annotation == null) {
            return;
        }
        String objectKey = this.getEAnnotationDetailsRangeKey(docletObject);
        String range = (String)annotation.getDetails().get((Object)objectKey);
        if (range == null) {
            return;
        }
        int index = range.indexOf(45);
        int start = Integer.parseInt(range.substring(0, index));
        int end = Integer.parseInt(range.substring(index + 1));
        IMarker marker = this.createDocletProblemMarker(markerId, severity, message, resourceFile, start, end);
        this.cacheMarkerID(marker, docletObject, annotation);
    }

    private void cacheMarkerID(IMarker marker, EObject docletObject, EAnnotation annotation) {
        if (marker == null || annotation == null) {
            return;
        }
        String markerKey = this.getEAnnotationDetailsMarkerKey(docletObject);
        if (markerKey == null) {
            return;
        }
        String markersString = this.getEncodedMarkerIDs(markerKey, annotation);
        markersString = this.appendMarkerID(markersString, marker);
        annotation.getDetails().put((Object)markerKey, (Object)markersString);
    }

    private String appendMarkerID(String markersString, IMarker marker) {
        String encodedMarkerID = Long.toString(marker.getId());
        if (markersString == null) {
            return encodedMarkerID;
        }
        StringBuffer b = new StringBuffer(markersString);
        b.append(' ').append(encodedMarkerID);
        return b.toString();
    }

    public void deleteMarkers(String markerId, EObject docletObject) {
        if (docletObject != null && docletObject.eClass().getEPackage() != EcorePackage.eINSTANCE) {
            boolean deleteUsingRange;
            IResource resourceFile = this.getResourceFromDoclet(docletObject);
            if (resourceFile == null) {
                return;
            }
            EAnnotation annotation = this.getEAnnotationFromDoclet(docletObject);
            if (annotation == null) {
                return;
            }
            String markerKey = this.getEAnnotationDetailsMarkerKey(docletObject);
            String markerIDs = this.getEncodedMarkerIDs(markerKey, annotation);
            boolean bl = deleteUsingRange = markerIDs == null;
            if (!deleteUsingRange) {
                deleteUsingRange = !this.deleteMarkersFromIDs(markerIDs, resourceFile);
                annotation.getDetails().removeKey((Object)markerKey);
            }
            if (deleteUsingRange) {
                String objectKey = this.getEAnnotationDetailsRangeKey(docletObject);
                if (objectKey == null) {
                    return;
                }
                String range = (String)annotation.getDetails().get((Object)objectKey);
                if (range == null) {
                    return;
                }
                int index = range.indexOf(45);
                int start = Integer.parseInt(range.substring(0, index));
                this.deleteMarkers(markerId, resourceFile, start);
            }
        }
    }

    private boolean deleteMarkersFromIDs(String markerIDs, IResource resourceFile) {
        boolean result = true;
        StringTokenizer tok = new StringTokenizer(markerIDs);
        while (tok.hasMoreTokens()) {
            String id = tok.nextToken();
            result &= this.deleteMarkerFromID(id, resourceFile);
        }
        return result;
    }

    private boolean deleteMarkerFromID(String id, IResource resourceFile) {
        Long longId = Long.valueOf(id);
        try {
            IMarker marker = resourceFile.findMarker(longId.longValue());
            if (marker != null) {
                marker.delete();
                return true;
            }
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return false;
    }

    private String getEncodedMarkerIDs(String key, EAnnotation annotation) {
        if (key != null) {
            return (String)annotation.getDetails().get((Object)key);
        }
        return null;
    }

    private IMarker createDocletProblemMarker(String markerId, int severity, String message, IResource resourceFile, int start, int end) {
        try {
            IMarker m = resourceFile.createMarker(markerId);
            m.setAttribute("charStart", start);
            m.setAttribute("charEnd", end);
            m.setAttribute("message", (Object)message);
            m.setAttribute("severity", severity);
            return m;
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
            return null;
        }
    }

    private void deleteMarkers(String markerId, IResource resourceFile, int start) {
        IMarker[] markers = null;
        try {
            markers = resourceFile.findMarkers(markerId, false, 0);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                try {
                    if (start == (Integer)marker.getAttribute("charStart")) {
                        marker.delete();
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
    }

    public void cacheOldContainer(EObject eObject) {
        if (eObject != null && eObject.eContainer() != null) {
            new OldContainerInfo(eObject);
        }
    }

    public String toUpperCaseWordSplit(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return "";
        }
        return this.format(identifier, '_').toUpperCase();
    }

    private String format(String name, char separator) {
        ArrayList parsedName = new ArrayList();
        if (name.length() != 0) {
            parsedName.addAll(this.parseName(name, '_'));
        }
        StringBuffer result = new StringBuffer();
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(nameComponent);
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append(separator);
        }
        return result.length() != 0 ? result.toString() : name;
    }

    private List parseName(String sourceName, char sourceSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        int length = sourceName.length();
        boolean lastIsLower = false;
        int index = 0;
        while (index < length) {
            char curChar = sourceName.charAt(index);
            if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == sourceSeparator) {
                if (lastIsLower || curChar == sourceSeparator) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                lastIsLower = false;
            } else {
                int currentWordLength;
                if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                    char lastChar = currentWord.charAt(--currentWordLength);
                    currentWord.setLength(currentWordLength);
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                    currentWord.append(lastChar);
                }
                lastIsLower = true;
            }
            if (curChar != sourceSeparator) {
                currentWord.append(curChar);
            }
            ++index;
        }
        result.add(currentWord.toString());
        return result;
    }

    public boolean canGenerate(EObject modelObject) {
        return this.getExistingOrOldContainer(modelObject) != null;
    }

    public IProject getProject(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource res = this.getResource(eObject);
        return ProjectUtilities.getProject((Resource)res);
    }

    private Resource getResource(EObject eObject) {
        EObject root = this.getRootContainer(eObject);
        if (root != null) {
            return root.eResource();
        }
        return null;
    }

    private EObject getRootContainer(EObject eObject) {
        EObject current = eObject;
        EObject root = null;
        while (current != null) {
            root = current;
            current = this.getExistingOrOldContainer(root);
        }
        return root;
    }

    public Resource getOrCreateMetaResource(URI uri, IProject project, Bundle bundle) throws IOException {
        if (project == null || uri == null) {
            return null;
        }
        ResourceSet rs = WorkbenchResourceHelper.getResourceSet((IProject)project);
        if (rs == null) {
            return null;
        }
        URI resolvedURI = this.getMetaResolvedURI(uri, project, bundle);
        Resource resource = WorkbenchResourceHelper.getExistingOrCreateResource((URI)resolvedURI, (ResourceSet)rs);
        this.loadResourceIfNecessary(resource);
        return resource;
    }

    public void resolveMetaResourceAnnotationProxiesOnLoad(URI uri, IProject project, Bundle bundle) throws IOException {
        if (project == null || uri == null) {
            return;
        }
        ResourceSet rs = WorkbenchResourceHelper.getResourceSet((IProject)project);
        if (rs == null) {
            return;
        }
        URI resolvedURI = this.getMetaResolvedURI(uri, project, bundle);
        Resource resource = WorkbenchResourceHelper.getExistingOrCreateResource((URI)resolvedURI, (ResourceSet)rs);
        if (this.loadResourceIfNecessary(resource)) {
            this.resolveAnnotationProxies(resource);
        }
    }

    private void resolveAnnotationProxies(Resource resource) {
        String annotationFileName = DynamicModelAnnotationTagHandlerRegistry.ANNOTATION_RES_URI.lastSegment();
        EList topLevels = resource.getContents();
        int size = topLevels.size();
        int i = 0;
        while (i < size) {
            EObject eObject = (EObject)topLevels.get(i);
            this.resolveAnnotationProxies((InternalEObject)eObject, annotationFileName);
            ++i;
        }
    }

    private void resolveAnnotationProxies(InternalEObject eObject, String annotationFileName) {
        if (eObject != null) {
            this.resolveNonContainedAnnotationProxies(eObject, annotationFileName);
            this.resolveContainedAnnotationProxies(eObject, annotationFileName);
        }
    }

    private void resolveNonContainedAnnotationProxies(InternalEObject eObject, String annotationFileName) {
        EList references = eObject.eClass().getEAllReferences();
        int i = 0;
        while (i < references.size()) {
            Object value;
            EReference reference = (EReference)references.get(i);
            if (!reference.isContainment() && !reference.isContainer() && eObject.eIsSet((EStructuralFeature)reference) && (value = eObject.eGet((EStructuralFeature)reference, false)) != null) {
                if (reference.isMany()) {
                    InternalEObject proxy;
                    if (!((List)value).isEmpty() && this.shouldResolve(proxy = (InternalEObject)((InternalEList)value).get(0), annotationFileName)) {
                        Iterator iter = ((Collection)value).iterator();
                        while (iter.hasNext()) {
                            iter.next();
                        }
                    }
                } else if (this.shouldResolve((InternalEObject)value, annotationFileName)) {
                    eObject.eGet((EStructuralFeature)reference);
                }
            }
            ++i;
        }
    }

    private void resolveContainedAnnotationProxies(InternalEObject eObject, String annotationFileName) {
        EList contained = eObject.eContents();
        int i = 0;
        while (i < contained.size()) {
            InternalEObject obj = (InternalEObject)contained.get(i);
            this.resolveAnnotationProxies(obj, annotationFileName);
            ++i;
        }
    }

    private boolean shouldResolve(InternalEObject eObject, String annotationFileName) {
        return eObject.eIsProxy() && annotationFileName.equals(eObject.eProxyURI().lastSegment());
    }

    private boolean loadResourceIfNecessary(Resource resource) throws IOException {
        if (resource != null && !resource.isLoaded()) {
            try {
                PlatformURLMetaPluginConnection.startup();
                resource.load(null);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return false;
    }

    public URI getMetaResolvedURI(URI uri, IProject project, Bundle bundle) {
        if (uri != null && uri.isRelative()) {
            if (bundle == null) {
                return null;
            }
            StringBuffer b = this.populateStateLocation(project, bundle, true);
            b.append(uri.toString());
            return URI.createURI((String)b.toString());
        }
        return uri;
    }

    private StringBuffer populateStateLocation(IProject project, Bundle bundle, boolean usePlatformURL) {
        if (bundle == null) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        if (usePlatformURL) {
            b.append("platform:/meta/");
            b.append(bundle.getSymbolicName());
        } else {
            b.append(Platform.getStateLocation((Bundle)bundle).toString());
        }
        b.append('/');
        b.append(project.getName());
        b.append('/');
        return b;
    }

    public void deleteAllMetaInformation(IProject project, Bundle bundle) {
        StringBuffer b = this.populateStateLocation(project, bundle, false);
        if (b != null) {
            File dir = new File(b.toString());
            if (dir == null) {
                return;
            }
            File[] files = dir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    files[i].delete();
                    ++i;
                }
            }
            dir.delete();
        }
    }

    public IType getJavaType(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                return (IType)element;
            }
            case 8: 
            case 9: {
                return ((IMember)element).getDeclaringType();
            }
        }
        return null;
    }

    public String getAnnotationJavaClassQualifiedName(EObject docletObject) {
        EClass eClass = this.getJavaClassFromDoclet(docletObject);
        return eClass == null ? null : eClass.getName();
    }

    public void saveResourceToMetaLocation(URI uri, IProject project, Bundle bundle, ResourceSet resourceSet) throws IOException {
        if (project == null || uri == null || bundle == null) {
            return;
        }
        URI resolvedURI = this.getMetaResolvedURI(uri, project, bundle);
        Resource res = resourceSet.getResource(resolvedURI, false);
        if (res == null) {
            throw new IOException("Failed to find resource to save with uri " + resolvedURI);
        }
        res.save(this.getMetaSaveOptions());
    }

    private Map getMetaSaveOptions() {
        if (this.saveMetaOptions == null) {
            this.saveMetaOptions = new HashMap();
            this.saveMetaOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        }
        return this.saveMetaOptions;
    }

    public void deleteMarkers(String markerID, TagData tagData) {
        this.deleteMarkers(markerID, (IResource)tagData.getSourceFile(), tagData.getTagStart());
    }

    public String[] parseStringToArray(String inSpacedStr) {
        if (inSpacedStr == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(inSpacedStr);
        String[] result = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            result[i] = tok.nextToken();
            ++i;
        }
        return result;
    }

    public List parseStringToList(String inSpacedStr) {
        if (inSpacedStr == null) {
            return Collections.EMPTY_LIST;
        }
        StringTokenizer tok = new StringTokenizer(inSpacedStr);
        ArrayList<String> result = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            result.add(tok.nextToken());
        }
        return result;
    }

    private class OldContainerInfo
    extends AdapterImpl {
        private EObject oldContainer;

        OldContainerInfo(EObject eObject) {
            this.oldContainer = eObject.eContainer();
            eObject.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object type) {
            return AnnotationUtil.ANNOTATION_OLD_CONTAINER_ADAPTER_KEY.equals(type);
        }

        EObject getOldContainer() {
            return this.oldContainer;
        }
    }
}

