/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.transform;

import com.ibm.zcc.etools.wrd.extensions.dynamic.model.AnnotationChangeRecorder;
import com.ibm.zcc.etools.wrd.extensions.transform.DeferredLinker;
import com.ibm.zcc.etools.wrd.extensions.transform.ModelContentHandler;
import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;

public class AnnotationModelTransformer {
    private List linkers;
    private ModelContentHandler handler;
    private AnnotationChangeRecorder changeRecorder;
    private String markerTypeID;
    private Set clearedMarkerDoclets;

    public AnnotationModelTransformer(String markerTypeID) {
        this.markerTypeID = markerTypeID;
    }

    public void addDeferredLinker(DeferredLinker linker) {
        if (linker == null) {
            return;
        }
        if (this.linkers == null) {
            this.linkers = new ArrayList();
        }
        this.linkers.add(linker);
    }

    public final void transform(AnnotationChangeRecorder aRecorder, ModelContentHandler aHandler) {
        if (aRecorder == null || aHandler == null) {
            return;
        }
        this.handler = aHandler;
        this.changeRecorder = aRecorder;
        this.handler.startModel(this);
        try {
            this.processAdds();
            this.processDeletes();
            this.processChanges();
            this.resolveLinks();
        }
        finally {
            this.handler.endModel();
            if (this.linkers != null) {
                this.linkers.clear();
            }
            if (this.clearedMarkerDoclets != null) {
                this.clearedMarkerDoclets.clear();
            }
        }
    }

    private void processAdds() {
        List added = this.changeRecorder.getAddedObjects();
        this.handler.setState(0);
        this.transformObjects(added);
    }

    private void transformObjects(List objects) {
        if (objects.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < objects.size()) {
            Object obj = objects.get(i);
            if (obj instanceof EObject) {
                this.transform((EObject)obj);
            }
            ++i;
        }
    }

    private void transform(EObject eObject) {
        try {
            this.clearMarkers(eObject);
            Object target = this.handler.doSwitch(eObject);
            this.recordLink(eObject, target);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    private void processDeletes() {
        List deleted = this.changeRecorder.getDeletedObjects();
        this.handler.setState(1);
        this.transformObjects(deleted);
    }

    private void processChanges() {
        Map changes = this.changeRecorder.getAllChanges();
        if (changes.isEmpty()) {
            return;
        }
        this.handler.setState(2);
        for (Map.Entry entry : changes.entrySet()) {
            List featureChanges;
            Object obj = entry.getKey();
            if (!(obj instanceof EObject) || this.changeRecorder.isNew((EObject)obj) || (featureChanges = (List)entry.getValue()).isEmpty()) continue;
            this.clearMarkers((EObject)obj);
            this.handler.processUpdatedFeatures((EObject)obj, featureChanges);
        }
    }

    public void createDocletErrorMarker(String markerId, String message, EObject doclet) {
        this.clearMarkers(doclet);
        AnnotationUtil.INSTANCE.createDocletErrorMarker(markerId, message, doclet);
    }

    public void createDocletWarningMarker(String markerId, String message, EObject doclet) {
        this.clearMarkers(doclet);
        AnnotationUtil.INSTANCE.createDocletWarningMarker(markerId, message, doclet);
    }

    public void clearMarkers(EObject eObject) {
        if (eObject == null) {
            return;
        }
        if (this.clearedMarkerDoclets == null) {
            this.clearedMarkerDoclets = new HashSet();
        } else if (this.clearedMarkerDoclets.contains(eObject)) {
            return;
        }
        if (this.shouldClearMarkers()) {
            AnnotationUtil.INSTANCE.deleteMarkers(this.markerTypeID, eObject);
        }
        this.clearedMarkerDoclets.add(eObject);
    }

    protected void recordLink(EObject source, Object target) {
        if (source == null || target == null || source == target) {
            return;
        }
        if (target instanceof EObject) {
            AnnotationUtil.INSTANCE.linkDomains(source, (EObject)target);
        }
    }

    protected void resolveLinks() {
        if (this.linkers == null || this.linkers.isEmpty()) {
            return;
        }
        for (Runnable runnable : this.linkers) {
            runnable.run();
        }
    }

    private boolean shouldClearMarkers() {
        return this.markerTypeID != null;
    }
}

