/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.dynamic.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PlatformURLMetaPluginConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    public static final String META = "meta";

    public PlatformURLMetaPluginConnection(URL url) {
        super(url);
    }

    protected boolean allowCaching() {
        return true;
    }

    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith(META)) {
            throw new IOException(Messages.bind((String)"url.badVariant", (Object)this.url.toString()));
        }
        int ix = spec.indexOf("/", META.length() + 1);
        String ref = ix == -1 ? spec.substring(META.length() + 1) : spec.substring(META.length() + 1, ix);
        String id = PlatformURLMetaPluginConnection.getId((String)ref);
        this.target = InternalPlatform.getDefault().getBundle(id);
        if (this.target == null) {
            throw new IOException(Messages.bind((String)"url.resolvePlugin", (Object)this.url.toString()));
        }
        IPath metaPath = Platform.getStateLocation((Bundle)this.target);
        if (ix != -1 || ix + 1 <= spec.length()) {
            metaPath = metaPath.append(spec.substring(ix + 1));
        }
        return new URL("file", null, metaPath.toString());
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        PlatformURLHandler.register((String)META, PlatformURLMetaPluginConnection.class);
        isRegistered = true;
    }

    public OutputStream getOutputStream() throws IOException {
        String fileString;
        URL resolved = this.getResolvedURL();
        if (resolved != null && (fileString = resolved.getFile()) != null) {
            File file = new File(fileString);
            String parent = file.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            return new FileOutputStream(file);
        }
        return null;
    }
}

