/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.dynamic.model;

import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelTagAttribSpec;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelTagSetRegistrationOptions;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelTagSpec;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicTagsetDescriptor;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationHandlerRegistry;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationTagHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagRegistry;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagsetRegistry;
import org.eclipse.jst.common.internal.annotations.registry.TagAttribSpec;
import org.eclipse.jst.common.internal.annotations.registry.TagSpec;
import org.eclipse.jst.common.internal.annotations.registry.TagsetDescriptor;

public class DynamicModelTagRegistationManager {
    public static final DynamicModelTagRegistationManager INSTANCE = new DynamicModelTagRegistationManager();
    private Map tagEPackages = new HashMap();
    private Map tagOptions = new HashMap();

    private DynamicModelTagRegistationManager() {
    }

    public void registerTags(DynamicModelTagSetRegistrationOptions options, AnnotationTagHandler tagHandler) {
        EPackage ePackage = options.getEPackage();
        if (!this.tagEPackages.containsValue(ePackage)) {
            this.tagEPackages.put(ePackage.getNsPrefix(), ePackage);
            this.tagOptions.put(ePackage, options);
            this.doRegisterTagsFromEPackage(ePackage, tagHandler, options);
        }
    }

    public DynamicModelTagSetRegistrationOptions getOptions(EPackage ePackage) {
        return (DynamicModelTagSetRegistrationOptions)this.tagOptions.get(ePackage);
    }

    public EPackage getEPackage(String tagName) {
        return (EPackage)this.tagEPackages.get(tagName);
    }

    protected void doRegisterTagsFromEPackage(EPackage ePackage, AnnotationTagHandler tagHandler, DynamicModelTagSetRegistrationOptions options) {
        this.registerTagSet(ePackage, options);
        this.registerTagHandler(ePackage, tagHandler, options);
        this.registerTags(ePackage, tagHandler, options, 1);
        this.registerTags(ePackage, tagHandler, options, 0);
        this.registerTags(ePackage, tagHandler, options, 2);
    }

    private void registerTagSet(EPackage ePackage, DynamicModelTagSetRegistrationOptions options) {
        DynamicTagsetDescriptor desc = new DynamicTagsetDescriptor(options);
        AnnotationTagsetRegistry.INSTANCE.registerTagset((TagsetDescriptor)desc);
    }

    private void registerTagHandler(EPackage ePackage, AnnotationTagHandler tagHandler, DynamicModelTagSetRegistrationOptions options) {
        AnnotationHandlerRegistry.INSTANCE.registerTagHandler(tagHandler, ePackage.getNsPrefix(), options.getParentTagSet(), options.shouldDisableWithParentTagSet());
    }

    protected void registerTags(EPackage ePackage, AnnotationTagHandler tagHandler, DynamicModelTagSetRegistrationOptions options, int scope) {
        EClass schemaClass = (EClass)ePackage.getEClassifier(options.getTypeName(scope));
        if (schemaClass != null) {
            String prefix = ePackage.getNsPrefix();
            if (prefix.length() != 0) {
                prefix = String.valueOf(prefix) + '.';
            }
            for (EStructuralFeature feature : schemaClass.getEAllStructuralFeatures()) {
                TagSpec tagSpec = this.createTagSpec(options, scope, prefix, feature);
                ArrayList<TagAttribSpec> attribSpecs = new ArrayList<TagAttribSpec>();
                EClass tagClass = (EClass)feature.getEType();
                for (EStructuralFeature attribFeature : tagClass.getEAllStructuralFeatures()) {
                    TagAttribSpec attribSpec = null;
                    if (!feature.isChangeable() || (attribSpec = this.createTagAttribSpec(attribFeature)) == null) continue;
                    this.setFeatureOptions(attribSpec, options.getFeatureOptions(attribFeature));
                    attribSpecs.add(attribSpec);
                }
                if (!attribSpecs.isEmpty()) {
                    tagSpec.setAttributes(attribSpecs);
                }
                AnnotationTagRegistry.getAllTagSpecs().add(tagSpec);
            }
        }
    }

    private TagSpec createTagSpec(DynamicModelTagSetRegistrationOptions options, int scope, String prefix, EStructuralFeature feature) {
        DynamicModelTagSpec tagSpec = new DynamicModelTagSpec(feature, prefix, scope);
        tagSpec.setResourceBundle(options.getHelpBundle());
        tagSpec.setValidValuesHelper(options.getAttributeValuesHelper());
        return tagSpec;
    }

    private void setFeatureOptions(TagAttribSpec attribSpec, DynamicModelTagSetRegistrationOptions.FeatureOptions featureOptions) {
        if (featureOptions == null) {
            return;
        }
        if (featureOptions.isJavaType) {
            attribSpec.setType(2);
        }
        if (featureOptions.isUnique) {
            attribSpec.setUnique();
            attribSpec.getUnique().setScope(featureOptions.uniqueScope);
        }
    }

    protected TagAttribSpec createTagAttribSpec(EStructuralFeature attribFeature) {
        return new DynamicModelTagAttribSpec(attribFeature);
    }
}

