/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.dynamic.model;

import com.ibm.zcc.etools.wrd.extensions.WRDExtensionPlugin;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.DynamicModelAnnotationTagHandler;
import com.ibm.zcc.etools.wrd.extensions.dynamic.model.PlatformURLMetaPluginConnection;
import com.ibm.zcc.etools.wrd.extensions.transform.ModelDependencyTracker;
import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.osgi.framework.Bundle;

public class DynamicModelAnnotationTagHandlerRegistry {
    public static final DynamicModelAnnotationTagHandlerRegistry INSTANCE = new DynamicModelAnnotationTagHandlerRegistry();
    public static final URI ANNOTATION_RES_URI = URI.createURI((String)"annotations.dyn_annotModel");
    public static final URI ANNOTATION_LINKERS_RES_URI = URI.createURI((String)"annotations.wrd_linkers");
    private Map handlersMap = new HashMap();
    private Map danglingTrackers;
    private List handlersInBuild = new ArrayList();
    private IProject buildProject;
    private List modifiedHandlers = new ArrayList();
    private boolean isFirstBuild = true;
    private Set cleanedProjects = new HashSet();

    private DynamicModelAnnotationTagHandlerRegistry() {
        this.initialize();
    }

    private void initialize() {
        PlatformURLMetaPluginConnection.startup();
        this.initializeResourceChangeListener();
    }

    private void scanForDeletedProjects() {
        File[] metaProjDirs = this.getAnnotationMetaProjectDirectories();
        if (metaProjDirs == null) {
            return;
        }
        ArrayList<IProject> missingProjects = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < metaProjDirs.length) {
            IProject project = root.getProject(metaProjDirs[i].getName());
            if (!project.exists()) {
                if (missingProjects == null) {
                    missingProjects = new ArrayList<IProject>();
                }
                missingProjects.add(project);
            }
            ++i;
        }
        if (missingProjects != null) {
            this.deleteMetaInformation(missingProjects);
        }
    }

    private void deleteMetaInformation(List missingProjects) {
        int i = 0;
        while (i < missingProjects.size()) {
            IProject project = (IProject)missingProjects.get(i);
            this.deleteMetaInformation(project);
            ++i;
        }
    }

    private File[] getAnnotationMetaProjectDirectories() {
        IPath stateLocation = WRDExtensionPlugin.getDefault().getStateLocation();
        File dir = stateLocation.toFile();
        if (dir != null) {
            return dir.listFiles();
        }
        return null;
    }

    private void initializeResourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                DynamicModelAnnotationTagHandlerRegistry.this.deleteMetaInformation((IProject)event.getResource());
            }
        }, 4);
    }

    private Bundle getWRDExtBundle() {
        return Platform.getBundle((String)"com.ibm.zcc.etools.wrd.extensions");
    }

    public void deleteMetaInformation(IProject project) {
        this.deleteAnnotationMetaInformation(project);
        this.deleteHandlerMetaInformation(project);
    }

    private void deleteAnnotationMetaInformation(IProject project) {
        AnnotationUtil.INSTANCE.deleteAllMetaInformation(project, this.getWRDExtBundle());
    }

    private void deleteHandlerMetaInformation(IProject project) {
        if (this.handlersMap.isEmpty()) {
            return;
        }
        Iterator it = this.handlersMap.values().iterator();
        while (it.hasNext()) {
            this.deleteHandlerMetaInformation((DynamicModelAnnotationTagHandler)it.next(), project);
        }
    }

    private void deleteHandlerMetaInformation(DynamicModelAnnotationTagHandler handler, IProject project) {
        handler.deleteMetaInformation(project);
    }

    void registerHandler(DynamicModelAnnotationTagHandler handler) {
        if (this.handlersMap == null) {
            this.handlersMap = new HashMap();
        }
        this.handlersMap.put(handler.getEAnnotationSource(), handler);
        this.processDanglingTrackers(handler);
    }

    private void processDanglingTrackers(DynamicModelAnnotationTagHandler handler) {
        if (this.danglingTrackers == null || this.danglingTrackers.isEmpty()) {
            return;
        }
        List trackers = (List)this.danglingTrackers.get(handler.getEAnnotationSource());
        if (trackers != null) {
            int i = 0;
            while (i < trackers.size()) {
                ModelDependencyTracker tracker = (ModelDependencyTracker)trackers.get(i);
                handler.registerModelDependencyTracker(tracker);
                ++i;
            }
            this.danglingTrackers.remove(handler.getEAnnotationSource());
        }
    }

    public void registerDependencyTracker(ModelDependencyTracker tracker, String eAnnotationSource) {
        if (tracker == null || eAnnotationSource == null) {
            return;
        }
        if (this.handlersMap == null) {
            this.addDanglingTracker(tracker, eAnnotationSource);
        } else {
            DynamicModelAnnotationTagHandler handler = (DynamicModelAnnotationTagHandler)this.handlersMap.get(eAnnotationSource);
            if (handler == null) {
                this.addDanglingTracker(tracker, eAnnotationSource);
            } else {
                handler.registerModelDependencyTracker(tracker);
            }
        }
    }

    private void addDanglingTracker(ModelDependencyTracker tracker, String annotationSource) {
        ArrayList<ModelDependencyTracker> trackers;
        if (this.danglingTrackers == null) {
            this.danglingTrackers = new HashMap();
        }
        if ((trackers = (ArrayList<ModelDependencyTracker>)this.danglingTrackers.get(annotationSource)) == null) {
            trackers = new ArrayList<ModelDependencyTracker>();
            this.danglingTrackers.put(annotationSource, trackers);
        }
        trackers.add(tracker);
    }

    void beginBuildCalled(DynamicModelAnnotationTagHandler handler, IProject project) {
        this.cleanedProjects.clear();
        if (this.handlersInBuild.isEmpty()) {
            this.modifiedHandlers.clear();
        }
        this.handlersInBuild.add(handler);
        if (this.buildProject == null) {
            this.buildProject = project;
        } else if (this.buildProject != project) {
            System.out.println("[DynamicModelAnnotationTagHandlerRegistry] The project should not be different.");
        }
    }

    void endBuildCalled(DynamicModelAnnotationTagHandler handler, IProject project) {
        if (this.buildProject != project) {
            System.out.println("[DynamicModelAnnotationTagHandlerRegistry] The project should not be different.");
        }
        this.removeBuildHandler(handler);
        if (handler.requiresInMemoryModel() && handler.hasAnyChanges()) {
            this.modifiedHandlers.add(handler);
        }
        if (this.handlersInBuild.isEmpty()) {
            try {
                if (this.isFirstBuild) {
                    this.scanForDeletedProjects();
                }
                this.saveMetaInformation();
            }
            finally {
                this.isFirstBuild = false;
                this.modifiedHandlers.clear();
                this.buildProject = null;
            }
        }
    }

    private void removeBuildHandler(DynamicModelAnnotationTagHandler handler) {
        if (this.handlersInBuild.isEmpty()) {
            return;
        }
        Object test = null;
        Iterator it = this.handlersInBuild.iterator();
        while (test != handler && it.hasNext()) {
            test = it.next();
            it.remove();
        }
    }

    private void saveMetaInformation() {
        if (this.modifiedHandlers.isEmpty()) {
            return;
        }
        ResourceSet set = WorkbenchResourceHelper.getResourceSet((IProject)this.buildProject);
        Bundle wrdBundle = this.getWRDExtBundle();
        this.saveDocletLinkersMetaInformation(set, wrdBundle);
        this.saveDocletMetaInformation(set, wrdBundle);
        this.saveHandlerMetaInformation(set);
    }

    private void saveDocletLinkersMetaInformation(ResourceSet set, Bundle wrdBundle) {
        try {
            AnnotationUtil.INSTANCE.saveResourceToMetaLocation(ANNOTATION_LINKERS_RES_URI, this.buildProject, wrdBundle, set);
        }
        catch (IOException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private void saveDocletMetaInformation(ResourceSet set, Bundle wrdBundle) {
        try {
            AnnotationUtil.INSTANCE.saveResourceToMetaLocation(ANNOTATION_RES_URI, this.buildProject, wrdBundle, set);
        }
        catch (IOException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private void saveHandlerMetaInformation(ResourceSet set) {
        int i = 0;
        while (i < this.modifiedHandlers.size()) {
            DynamicModelAnnotationTagHandler handler = (DynamicModelAnnotationTagHandler)this.modifiedHandlers.get(i);
            try {
                handler.saveSymanticMetaInformation(this.buildProject, set);
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            ++i;
        }
    }

    void clean(IProject project) {
        if (!this.cleanedProjects.contains(project)) {
            this.cleanedProjects.add(project);
            this.buildProject = project;
            try {
                this.preCleanHandlers(project);
                this.deleteMetaInformation(project);
                this.removeMetaResources();
            }
            finally {
                this.buildProject = null;
            }
        }
    }

    private void preCleanHandlers(IProject project) {
        if (this.handlersMap.isEmpty()) {
            return;
        }
        for (DynamicModelAnnotationTagHandler handler : this.handlersMap.values()) {
            this.removeHandlerMarkers(handler, project);
            try {
                handler.preClean(project);
            }
            catch (Exception e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    private void removeHandlerMarkers(DynamicModelAnnotationTagHandler handler, IProject project) {
        String markerID = handler.getMarkerTypeID();
        if (markerID != null && !"com.ibm.zcc.ws.rapiddeploy.annotations.core.AnnotationProblemMarker".equals(markerID)) {
            try {
                project.deleteMarkers(markerID, true, 2);
            }
            catch (CoreException coreException) {}
        }
    }

    private void removeMetaResources() {
        ResourceSet set = WorkbenchResourceHelper.getResourceSet((IProject)this.buildProject);
        Bundle wrdBundle = this.getWRDExtBundle();
        this.removeDocletLinkersMetaResource(set, wrdBundle);
        this.removeDocletMetaResource(set, wrdBundle);
        this.removeHandlerMetaResource(set);
    }

    private void removeDocletLinkersMetaResource(ResourceSet set, Bundle wrdBundle) {
        this.removeResource(ANNOTATION_LINKERS_RES_URI, wrdBundle, set);
    }

    private void removeResource(URI resolved, ResourceSet set) {
        if (resolved == null) {
            return;
        }
        Resource res = set.getResource(resolved, false);
        if (res != null) {
            set.getResources().remove((Object)res);
        }
    }

    private void removeResource(URI relative, Bundle bundle, ResourceSet set) {
        URI resolved = AnnotationUtil.INSTANCE.getMetaResolvedURI(relative, this.buildProject, bundle);
        this.removeResource(resolved, set);
    }

    private void removeDocletMetaResource(ResourceSet set, Bundle wrdBundle) {
        this.removeResource(ANNOTATION_RES_URI, wrdBundle, set);
    }

    private void removeHandlerMetaResource(ResourceSet set) {
        if (this.handlersMap.isEmpty()) {
            return;
        }
        for (DynamicModelAnnotationTagHandler handler : this.handlersMap.values()) {
            this.removeResource(handler.getMetaURI(), handler.getMetaBundle(), set);
        }
    }

    public Resource getAnnotationState(IProject project) throws IOException {
        Bundle bundle = Platform.getBundle((String)"com.ibm.zcc.etools.wrd.extensions");
        Resource resource = AnnotationUtil.INSTANCE.getOrCreateMetaResource(ANNOTATION_RES_URI, project, bundle);
        AnnotationUtil.INSTANCE.getOrCreateMetaResource(ANNOTATION_LINKERS_RES_URI, project, bundle);
        return resource;
    }
}

