/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.dynamic.model;

import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EObjectEList;

public class AnnotationChangeRecorder
extends ChangeRecorder {
    private static final EClass STRING_TO_STRING_MAP_ENTRY_ECLASS = EcorePackage.eINSTANCE.getEStringToStringMapEntry();
    private static EAttribute TOUCH_FEATURE;
    private String eAnnotationSource;
    protected List initialTargetObjects = new BasicEList.FastCompare();

    public AnnotationChangeRecorder(String eAnnotationSource) {
        this.eAnnotationSource = eAnnotationSource;
    }

    public void beginRecording() {
        this.changeDescription = this.createChangeDescription();
        this.initialTargetObjects.clear();
        this.initialTargetObjects.addAll(this.targetObjects);
        this.recording = true;
    }

    public void add(EObject eObject) {
        this.loadingTargets = true;
        try {
            this.addAdapter((Notifier)eObject);
        }
        finally {
            this.loadingTargets = false;
        }
    }

    public ChangeDescription endRecording() {
        if (this.recording) {
            this.recording = false;
            EList orphanedObjects = this.changeDescription.getObjectsToAttach();
            for (Object target : this.targetObjects) {
                EObject eObject;
                if (!(target instanceof EObject) || (eObject = (EObject)target).eResource() != null) continue;
                orphanedObjects.add(eObject);
            }
            this.targetObjects.removeAll((Collection<?>)orphanedObjects);
            ArrayList newObjects = new ArrayList(this.targetObjects.size());
            newObjects.addAll(this.targetObjects);
            newObjects.removeAll(this.initialTargetObjects);
            this.changeDescription.getObjectsToDetach().addAll(newObjects);
            Iterator iter = this.changeDescription.getObjectChanges().iterator();
            while (iter.hasNext()) {
                Map.Entry mapEntry = (Map.Entry)iter.next();
                EObject eObject = (EObject)mapEntry.getKey();
                List changes = (List)mapEntry.getValue();
                Iterator featureChangeIter = changes.iterator();
                while (featureChangeIter.hasNext()) {
                    if (this.filterFinalizeChange((FeatureChange)featureChangeIter.next(), eObject)) continue;
                    featureChangeIter.remove();
                }
                if (!changes.isEmpty()) continue;
                iter.remove();
            }
            for (ResourceChange resourceChange : this.changeDescription.getResourceChanges()) {
                this.finalizeChange(resourceChange);
            }
            return this.changeDescription;
        }
        return null;
    }

    private boolean filterFinalizeChange(FeatureChange change, EObject eObject) {
        EStructuralFeature sf = change.getFeature();
        if (AnnotationChangeRecorder.isAnnotationTouchFeature(sf) || this.shouldIgnoreChangeFor(eObject)) {
            return false;
        }
        if (sf.isMany()) {
            super.finalizeChange(change, eObject);
            return true;
        }
        Object newValue = eObject.eGet(sf);
        Object oldValue = change.getValue();
        if (oldValue != newValue && (oldValue == null ^ newValue == null || oldValue == null || !oldValue.equals(newValue))) {
            super.finalizeChange(change, eObject);
            return true;
        }
        return false;
    }

    private boolean shouldIgnoreChangeFor(EObject eObject) {
        EClass eClass = eObject.eClass();
        return eClass == STRING_TO_STRING_MAP_ENTRY_ECLASS;
    }

    public boolean isDeleted(EObject eObject) {
        if (eObject == null || this.changeDescription == null) {
            return false;
        }
        return this.changeDescription.getObjectsToAttach().contains((Object)eObject);
    }

    public boolean isNew(EObject eObject) {
        if (eObject == null || this.changeDescription == null) {
            return false;
        }
        return this.changeDescription.getObjectsToDetach().contains((Object)eObject);
    }

    public boolean isChanged(EObject eObject) {
        if (eObject == null || this.changeDescription == null) {
            return false;
        }
        return this.changeDescription.getObjectChanges().containsKey((Object)eObject);
    }

    public List getFeatureChanges(EObject eObject) {
        if (eObject == null || this.changeDescription == null) {
            return Collections.EMPTY_LIST;
        }
        return super.getFeatureChanges(eObject);
    }

    public List getChangedStructuralFeatures(EObject eObject) {
        List featureChanges = this.getFeatureChanges(eObject);
        if (featureChanges.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>(featureChanges.size());
        int i = 0;
        while (i < featureChanges.size()) {
            FeatureChange change = (FeatureChange)featureChanges.get(i);
            features.add(change.getFeature());
            ++i;
        }
        return features;
    }

    public Map getAllChanges() {
        if (this.changeDescription == null) {
            return Collections.EMPTY_MAP;
        }
        return this.changeDescription.getObjectChanges().map();
    }

    public List getDeletedObjects() {
        if (this.changeDescription == null) {
            return Collections.EMPTY_LIST;
        }
        return this.changeDescription.getObjectsToAttach();
    }

    public List getAddedObjects() {
        if (this.changeDescription == null) {
            return Collections.EMPTY_LIST;
        }
        return this.changeDescription.getObjectsToDetach();
    }

    void unsetNonVisitedAnnotations(EClass javaClass) {
        if (javaClass == null) {
            return;
        }
        this.unsetNonVisitedAnnotations((List)javaClass.getEAttributes());
        this.unsetNonVisitedAnnotations((List)javaClass.getEOperations());
        this.unsetNonVisitedTagClassAnnotations((EModelElement)javaClass);
    }

    private void unsetNonVisitedAnnotations(List modelElements) {
        if (modelElements.isEmpty()) {
            return;
        }
        Iterator it = modelElements.iterator();
        while (it.hasNext()) {
            EModelElement eObject = (EModelElement)it.next();
            this.unsetNonVisitedTagClassAnnotations(eObject);
            if (!eObject.getEAnnotations().isEmpty()) continue;
            it.remove();
        }
    }

    private void unsetNonVisitedTagClassAnnotations(EModelElement modelElement) {
        EList contents;
        EAnnotation eAnnotation = modelElement.getEAnnotation(this.eAnnotationSource);
        if (eAnnotation != null && !(contents = eAnnotation.getContents()).isEmpty()) {
            EObject annotationTagObject = (EObject)contents.get(0);
            this.unsetNonVisitedAnnotations(annotationTagObject);
            if (annotationTagObject.eContents().isEmpty()) {
                modelElement.getEAnnotations().remove((Object)eAnnotation);
            }
        }
    }

    private void unsetNonVisitedAnnotations(EObject eObject) {
        if (this.isNewOrDeletedDuringRecording(eObject)) {
            return;
        }
        if (this.isChanged(eObject)) {
            this.doUnsetNonVisitedAnnotations(eObject);
        }
        this.unsetNonVisitedReferenceAnnotations(eObject);
    }

    private boolean isNewOrDeletedDuringRecording(EObject eObject) {
        return this.targetObjects.contains(eObject) && !this.initialTargetObjects.contains(eObject) || this.initialTargetObjects.contains(eObject) && !this.targetObjects.contains(eObject);
    }

    private void unsetNonVisitedReferenceAnnotations(EObject eObject) {
        EList references = eObject.eClass().getEAllReferences();
        int i = 0;
        while (i < references.size()) {
            EReference ref = (EReference)references.get(i);
            if (ref.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)ref);
                if (!list.isEmpty()) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        EObject refObj = (EObject)it.next();
                        if (!this.isChanged(refObj)) {
                            AnnotationUtil.INSTANCE.simplePreDelete(refObj);
                            it.remove();
                            continue;
                        }
                        this.unsetNonVisitedAnnotations(refObj);
                    }
                }
            } else {
                EObject refObj = (EObject)eObject.eGet((EStructuralFeature)ref);
                if (this.isNewOrDeletedDuringRecording(refObj)) break;
                if (this.isChanged(refObj)) {
                    this.unsetNonVisitedAnnotations(refObj);
                } else {
                    AnnotationUtil.INSTANCE.simplePreDelete(refObj);
                    eObject.eUnset((EStructuralFeature)ref);
                }
            }
            ++i;
        }
    }

    private void doUnsetNonVisitedAnnotations(EObject eObject) {
        EClass metaClass = eObject.eClass();
        EList attributes = metaClass.getEAllAttributes();
        List changedFeatures = this.getChangedStructuralFeatures(eObject);
        if (!attributes.isEmpty()) {
            for (EAttribute att : attributes) {
                if (changedFeatures.contains(att)) continue;
                eObject.eUnset((EStructuralFeature)att);
            }
        }
    }

    protected void handleFeature(EStructuralFeature feature, EReference containment, Notification notification, EObject arg3) {
        if (feature != null) {
            super.handleFeature(feature, containment, notification, arg3);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 8 && notification.getOldValue() == this) {
            this.targetObjects.remove(notification.getNotifier());
        } else {
            super.notifyChanged(notification);
        }
    }

    public void reset() {
        this.changeDescription = null;
    }

    public boolean hasAnyChanges() {
        return this.changeDescription != null && (!this.changeDescription.getObjectsToAttach().isEmpty() || !this.changeDescription.getObjectsToDetach().isEmpty() || !this.changeDescription.getObjectChanges().isEmpty());
    }

    public void touch(EObject eObject) {
        eObject.eNotify((Notification)new TouchNotification(eObject));
    }

    static EStructuralFeature getTouchFeature() {
        if (TOUCH_FEATURE == null) {
            TOUCH_FEATURE = EcoreFactory.eINSTANCE.createEAttribute();
            TOUCH_FEATURE.setName("Annotation_touch_feature");
            TOUCH_FEATURE.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        }
        return TOUCH_FEATURE;
    }

    public static boolean isAnnotationTouchFeature(EStructuralFeature feature) {
        return TOUCH_FEATURE == feature;
    }

    protected ChangeDescription createChangeDescription() {
        return new AnnotationChangeDescriptionImpl();
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        if (this.loadingTargets) {
            this.initialTargetObjects.add(target);
        }
    }

    private static class AnnotationChangeDescriptionImpl
    extends ChangeDescriptionImpl {
        private AnnotationChangeDescriptionImpl() {
        }

        public EList getObjectsToAttach() {
            if (this.objectsToAttach == null) {
                this.objectsToAttach = new EObjectEList(EObject.class, (InternalEObject)this, 2);
            }
            return this.objectsToAttach;
        }

        public EList getObjectsToDetach() {
            return super.getObjectsToDetachGen();
        }
    }

    private static class TouchNotification
    extends NotificationImpl {
        private EObject notifier;

        public TouchNotification(EObject notifier) {
            super(1, (Object)"", (Object)"");
            this.notifier = notifier;
        }

        public Object getFeature() {
            return AnnotationChangeRecorder.getTouchFeature();
        }

        public Object getNotifier() {
            return this.notifier;
        }

        public boolean isTouch() {
            return true;
        }
    }
}

