/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.annotationwriter.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;

public class JavaElementMapper
extends ASTVisitor {
    private IMember fElement;
    private int fStart;
    private int fLength;
    private ASTNode fResult;

    private JavaElementMapper(IMember element) throws JavaModelException {
        Assert.isNotNull((Object)element);
        this.fElement = element;
        ISourceRange sourceRange = this.fElement.getNameRange();
        this.fStart = sourceRange.getOffset();
        this.fLength = sourceRange.getLength();
    }

    public static ASTNode perform(IMember member, Class type, ASTNode root) throws JavaModelException {
        JavaElementMapper mapper = new JavaElementMapper(member);
        root.accept((ASTVisitor)mapper);
        ASTNode result = mapper.fResult;
        while (result != null && !type.isInstance(result)) {
            result = result.getParent();
        }
        return result;
    }

    public void preVisit(ASTNode node) {
        if (this.fResult != null) {
            return;
        }
        int nodeStart = node.getStartPosition();
        int nodeLength = node.getLength();
        if (nodeStart == this.fStart && nodeLength == this.fLength) {
            this.fResult = node;
        }
    }
}

