/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.annotationwriter.internal;

import com.ibm.zcc.etools.wrd.extensions.annotationwriter.internal.JavaElementMapper;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class AnnotationWriterUtils {
    public static final String TAG_CONSTANT = "@";
    public static final String EQUAL = "=";

    public static TagElement createNewTagElement(AST ast, String tagNamespace, String tagName) {
        TagElement tagElement = ast.newTagElement();
        tagElement.setTagName(TAG_CONSTANT + tagNamespace + tagName);
        return tagElement;
    }

    public static TextElement createNewFragment(AST ast, String name, String value) {
        TextElement textElement = ast.newTextElement();
        textElement.setText(String.valueOf('\"') + name + EQUAL + value + '\"');
        return textElement;
    }

    public static Javadoc getJavadoc(IMember member, ASTNode root) {
        BodyDeclaration bodyDeclaration = null;
        try {
            switch (member.getElementType()) {
                case 7: {
                    bodyDeclaration = (BodyDeclaration)JavaElementMapper.perform(member, TypeDeclaration.class, root);
                    break;
                }
                case 9: {
                    bodyDeclaration = (BodyDeclaration)JavaElementMapper.perform(member, MethodDeclaration.class, root);
                    break;
                }
                case 8: {
                    bodyDeclaration = (BodyDeclaration)JavaElementMapper.perform(member, FieldDeclaration.class, root);
                }
            }
        }
        catch (Exception exception) {}
        return bodyDeclaration == null ? null : bodyDeclaration.getJavadoc();
    }

    public static TagElement findMatchingTagElement(Javadoc javaDoc, String tagNamespace, String tagName) {
        List tagElements = javaDoc.tags();
        String fullTagName = TAG_CONSTANT + tagNamespace + tagName;
        int i = 0;
        int size = tagElements.size();
        while (i < size) {
            TagElement tagElement = (TagElement)tagElements.get(i);
            if (tagElement.getTagName().equals(fullTagName)) {
                return tagElement;
            }
            ++i;
        }
        return null;
    }

    public static List getAttributesForEObject(EObject eObject) {
        EClass eClass = eObject.eClass();
        ExtendedMetaData emd = ExtendedMetaData.INSTANCE;
        return emd.getAttributes(eClass);
    }

    public static String getEStructuralFeatureName(EStructuralFeature eStructuralFeature) {
        ExtendedMetaData emd = ExtendedMetaData.INSTANCE;
        return emd.getName(eStructuralFeature);
    }

    public static String getTagElementNamespace(EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        return ePackage.getNsPrefix();
    }

    public static TagElement findMatchingTagElement(EObject tagEObject, EReference reference, Javadoc javaDoc) {
        String tagName = AnnotationWriterUtils.getEStructuralFeatureName((EStructuralFeature)reference);
        String tagNamespace = AnnotationWriterUtils.getTagElementNamespace(tagEObject);
        String tagFullName = TAG_CONSTANT + tagNamespace + tagName;
        List tagElements = javaDoc.tags();
        TagElement returnTagElement = null;
        int i = 0;
        int size = tagElements.size();
        while (i < size && returnTagElement == null) {
            TagElement tagElement = (TagElement)tagElements.get(i);
            if (tagElement.getTagName().equals(tagFullName)) {
                returnTagElement = tagElement;
            }
            ++i;
        }
        return returnTagElement;
    }

    public static TextElement findMatchingFragment(EObject annotationEObject, EAttribute attribute, TagElement tagElement) {
        TextElement returnTextElement = null;
        String oldValue = (String)annotationEObject.eGet((EStructuralFeature)attribute);
        String featureName = AnnotationWriterUtils.getEStructuralFeatureName((EStructuralFeature)attribute);
        List fragments = tagElement.fragments();
        boolean found = false;
        int j = 0;
        int size = fragments.size();
        while (j < size && !found) {
            TextElement textElement;
            Object fragment = fragments.get(j);
            if (fragment instanceof TextElement && (textElement = (TextElement)fragment).getText().equals(String.valueOf(featureName) + EQUAL + oldValue)) {
                returnTextElement = textElement;
                found = true;
            }
            ++j;
        }
        return returnTextElement;
    }

    public static TagElement spitToTagElement(EObject tagEObject, EReference reference, AST ast) {
        String tagName = AnnotationWriterUtils.getEStructuralFeatureName((EStructuralFeature)reference);
        String tagNamespace = AnnotationWriterUtils.getTagElementNamespace(tagEObject);
        TagElement tagElementToAdd = AnnotationWriterUtils.createNewTagElement(ast, tagNamespace, tagName);
        List attributes = AnnotationWriterUtils.getAttributesForEObject(tagEObject);
        int j = 0;
        int attributesSize = attributes.size();
        while (j < attributesSize) {
            EAttribute attribute = (EAttribute)attributes.get(j);
            if (tagEObject.eIsSet((EStructuralFeature)attribute) && !attribute.isMany()) {
                String attributeName = AnnotationWriterUtils.getEStructuralFeatureName((EStructuralFeature)attribute);
                Object value = tagEObject.eGet((EStructuralFeature)attribute);
                TextElement textElement = AnnotationWriterUtils.createNewFragment(ast, attributeName, (String)value);
                tagElementToAdd.fragments().add(textElement);
            }
            ++j;
        }
        return tagElementToAdd;
    }
}

