/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.wrd.extensions.annotationwriter.internal;

import com.ibm.zcc.etools.wrd.extensions.annotationwriter.internal.AnnotationWriterUtils;
import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class AnnotationWriter {
    private static AnnotationWriter INSTANCE = null;
    public static final int ADD = 1;
    public static final int DELETE = 2;

    private AnnotationWriter() {
    }

    public static AnnotationWriter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnnotationWriter();
        }
        return INSTANCE;
    }

    public void process(ChangeDescription changeDescription, IProgressMonitor monitor) {
        EList deletedObjects;
        this.processChange(changeDescription, monitor);
        EList addedObjects = changeDescription.getObjectsToDetach();
        if (addedObjects.size() > 0) {
            this.processAdd((List)addedObjects, monitor);
        }
        if ((deletedObjects = changeDescription.getObjectsToAttach()).size() > 0) {
            this.processDelete((List)deletedObjects, monitor);
        }
    }

    public void processAdd(List addedObjects, IProgressMonitor monitor) {
        if (addedObjects.isEmpty()) {
            return;
        }
        int i = 0;
        int size = addedObjects.size();
        while (i < size) {
            Object annotationEObject = addedObjects.get(i);
            if (annotationEObject instanceof EObject) {
                this.processAdd((EObject)annotationEObject, monitor);
            }
            ++i;
        }
    }

    public void processAdd(EObject annotationEObject, IProgressMonitor monitor) {
        if (annotationEObject == null) {
            return;
        }
        IJavaElement javaElement = AnnotationUtil.INSTANCE.getJavaElementFromDoclet(annotationEObject);
        EClass eClass = AnnotationUtil.INSTANCE.getJavaClassFromDoclet(annotationEObject);
        if (!eClass.eIsProxy()) {
            try {
                this.addOrDeleteTagsFromDoclet(annotationEObject, (IMember)javaElement, monitor, 1);
            }
            catch (CoreException ce) {
                Logger.getLogger().logError((Throwable)ce);
            }
        }
    }

    public void processDelete(List deletedObjects, IProgressMonitor monitor) {
        if (deletedObjects.isEmpty()) {
            return;
        }
        int i = 0;
        int size = deletedObjects.size();
        while (i < size) {
            Object obj = deletedObjects.get(i);
            if (obj instanceof EObject) {
                this.processDelete((EObject)obj, monitor);
            }
            ++i;
        }
    }

    public void processDelete(EObject theEObject, IProgressMonitor monitor) {
        if (theEObject == null) {
            return;
        }
        IJavaElement javaElement = AnnotationUtil.INSTANCE.getJavaElementFromDoclet(theEObject);
        EClass eClass = AnnotationUtil.INSTANCE.getJavaClassFromDoclet(theEObject);
        if (!eClass.eIsProxy()) {
            try {
                this.addOrDeleteTagsFromDoclet(theEObject, (IMember)javaElement, monitor, 2);
            }
            catch (CoreException ce) {
                Logger.getLogger().logError((Throwable)ce);
            }
        }
    }

    public void processChange(ChangeDescription changeDescription, IProgressMonitor monitor) {
        Map changes = changeDescription.getObjectChanges().map();
        if (changes.isEmpty()) {
            return;
        }
        try {
            for (Map.Entry entry : changes.entrySet()) {
                List featureChanges;
                Object eObject = entry.getKey();
                boolean isNew = changeDescription.getObjectsToDetach().contains(eObject);
                if (!(eObject instanceof EObject) || isNew || (featureChanges = (List)entry.getValue()).isEmpty()) continue;
                this.updateTagsFromDoclet((EObject)eObject, featureChanges, monitor);
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().logError((Throwable)ce);
        }
    }

    private void addOrDeleteTagsFromDoclet(EObject annotationEObject, IMember member, IProgressMonitor monitor, int whatToDo) throws CoreException {
        if (member == null || annotationEObject == null) {
            return;
        }
        ICompilationUnit compUnit = member.getCompilationUnit();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = compUnit.getPath();
        manager.connect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        try {
            try {
                ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(path);
                IDocument document = textFileBuffer.getDocument();
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(document.get().toCharArray());
                CompilationUnit cu = (CompilationUnit)parser.createAST(monitor);
                ASTRewrite rewriter = ASTRewrite.create((AST)cu.getAST());
                Javadoc javaDoc = AnnotationWriterUtils.getJavadoc(member, (ASTNode)cu);
                if (whatToDo == 1) {
                    this.addToJavadoc(javaDoc, rewriter, annotationEObject);
                } else if (whatToDo == 2) {
                    this.deleteFromJavadoc(javaDoc, rewriter, annotationEObject);
                }
                TextEdit textEdit = rewriter.rewriteAST(document, null);
                monitor.worked(1);
                textEdit.apply(document);
                textFileBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
            }
            catch (BadLocationException e) {
                Logger.getLogger().logError((Throwable)e);
                manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private void updateTagsFromDoclet(EObject annotationEObject, List featureChanges, IProgressMonitor monitor) throws CoreException {
        IMember member = (IMember)AnnotationUtil.INSTANCE.getJavaElementFromDoclet(annotationEObject);
        if (member == null) {
            return;
        }
        ICompilationUnit compUnit = member.getCompilationUnit();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = compUnit.getPath();
        manager.connect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        try {
            try {
                ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(path);
                IDocument document = textFileBuffer.getDocument();
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(document.get().toCharArray());
                CompilationUnit cu = (CompilationUnit)parser.createAST(monitor);
                ASTRewrite rewriter = ASTRewrite.create((AST)cu.getAST());
                Javadoc javaDoc = AnnotationWriterUtils.getJavadoc(member, (ASTNode)cu);
                this.changeJavadoc(annotationEObject, featureChanges, javaDoc, rewriter);
                TextEdit textEdit = rewriter.rewriteAST(document, null);
                monitor.worked(1);
                textEdit.apply(document);
                textFileBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
            }
            catch (BadLocationException e) {
                Logger.getLogger().logError((Throwable)e);
                manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private void addToJavadoc(Javadoc javaDoc, ASTRewrite rewriter, EObject annotationEObject) {
        AST ast = javaDoc.getAST();
        ListRewrite lrw = rewriter.getListRewrite((ASTNode)javaDoc, Javadoc.TAGS_PROPERTY);
        EObject container = AnnotationUtil.INSTANCE.getExistingOrOldContainer(annotationEObject);
        TagElement tagElementToAdd = null;
        if (container.eClass().equals(EcorePackage.eINSTANCE.getEAnnotation())) {
            List references = AnnotationWriterUtils.getAttributesForEObject(annotationEObject);
            int i = 0;
            int referencesSize = references.size();
            while (i < referencesSize) {
                EReference reference = (EReference)references.get(i);
                if (annotationEObject.eIsSet((EStructuralFeature)reference)) {
                    if (!reference.isMany()) {
                        EObject tagEObject = (EObject)annotationEObject.eGet((EStructuralFeature)reference);
                        tagElementToAdd = AnnotationWriterUtils.spitToTagElement(tagEObject, reference, ast);
                    }
                    if (tagElementToAdd != null) {
                        lrw.insertLast((ASTNode)tagElementToAdd, null);
                    }
                }
                ++i;
            }
        } else {
            EReference reference = (EReference)annotationEObject.eContainingFeature();
            tagElementToAdd = AnnotationWriterUtils.spitToTagElement(annotationEObject, reference, ast);
            if (tagElementToAdd != null) {
                lrw.insertLast((ASTNode)tagElementToAdd, null);
            }
        }
    }

    private void deleteFromJavadoc(Javadoc javaDoc, ASTRewrite rewriter, EObject annotationEObject) {
        ListRewrite lrw = rewriter.getListRewrite((ASTNode)javaDoc, Javadoc.TAGS_PROPERTY);
        EObject container = AnnotationUtil.INSTANCE.getExistingOrOldContainer(annotationEObject);
        TagElement tagElementToRemove = null;
        if (container.eClass().equals(EcorePackage.eINSTANCE.getEAnnotation())) {
            List references = AnnotationWriterUtils.getAttributesForEObject(annotationEObject);
            int i = 0;
            int referencesSize = references.size();
            while (i < referencesSize) {
                EReference reference = (EReference)references.get(i);
                if (annotationEObject.eIsSet((EStructuralFeature)reference)) {
                    if (!reference.isMany()) {
                        EObject tagEObject = (EObject)annotationEObject.eGet((EStructuralFeature)reference);
                        tagElementToRemove = AnnotationWriterUtils.findMatchingTagElement(tagEObject, reference, javaDoc);
                    }
                    if (tagElementToRemove != null) {
                        lrw.remove((ASTNode)tagElementToRemove, null);
                    }
                }
                ++i;
            }
        } else {
            EReference reference = (EReference)annotationEObject.eContainingFeature();
            tagElementToRemove = AnnotationWriterUtils.findMatchingTagElement(annotationEObject, reference, javaDoc);
            if (tagElementToRemove != null) {
                lrw.remove((ASTNode)tagElementToRemove, null);
            }
        }
    }

    private void changeJavadoc(EObject annotationEObject, List featureChanges, Javadoc javaDoc, ASTRewrite rewriter) {
        if (!annotationEObject.eClass().equals(EcorePackage.eINSTANCE.getEAnnotation())) {
            EReference reference = (EReference)annotationEObject.eContainingFeature();
            TagElement tagElement = AnnotationWriterUtils.findMatchingTagElement(annotationEObject, reference, javaDoc);
            int i = 0;
            while (i < featureChanges.size()) {
                FeatureChange change = (FeatureChange)featureChanges.get(i);
                EAttribute attribute = (EAttribute)change.getFeature();
                if (attribute != null) {
                    TextElement fragmentToChange = AnnotationWriterUtils.findMatchingFragment(annotationEObject, attribute, tagElement);
                    String featureName = AnnotationWriterUtils.getEStructuralFeatureName((EStructuralFeature)attribute);
                    String dataValue = change.getDataValue();
                    TextElement replacedNode = AnnotationWriterUtils.createNewFragment(javaDoc.getAST(), featureName, dataValue);
                    rewriter.replace((ASTNode)fragmentToChange, (ASTNode)replacedNode, null);
                }
                ++i;
            }
        }
    }
}

