/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.annotations.gen;

import com.ibm.zcc.etools.annotations.gen.Annotation;
import com.ibm.zcc.etools.annotations.gen.AnnotationAdapterImpl;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationASTVisitor;
import com.ibm.zcc.ws.rd.annotations.core.ResourceTagRegistry;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import com.ibm.zcc.ws.rd.resource.javautil.DisabledTagSets;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jem.util.logger.proxy.Logger;

public class MergingAnnotationAdapter
extends AnnotationAdapterImpl {
    private String keyAttribute;

    public MergingAnnotationAdapter(ISourceReference member, ICompilationUnit compUnit, Annotation annotation, String keyName) {
        super(member, compUnit, annotation);
        this.keyAttribute = keyName;
    }

    @Override
    public int injectAnnotation() {
        IFile sourceFile = null;
        sourceFile = (IFile)this.icu.getResource();
        if (sourceFile == null || !sourceFile.exists()) {
            Logger.getLogger().logError("Unable to add annotation because the source file was null.  ICU = " + this.icu);
            return 0;
        }
        DisabledTagSets dts = new DisabledTagSets();
        AnnotationASTVisitor visitor = new AnnotationASTVisitor(sourceFile, this.icu, dts);
        ASTParser jParser = ASTParser.newParser((int)3);
        jParser.setSource(this.icu);
        jParser.setKind(8);
        ASTNode cunode = jParser.createAST(null);
        cunode.accept((ASTVisitor)visitor);
        ResourceTagRegistry registry = visitor.getTagRegistry();
        TypeTagData tagData = this.findTagData(registry);
        if (tagData == null) {
            return super.injectAnnotation();
        }
        return this.injectAnnotation(tagData);
    }

    private TypeTagData findTagData(ResourceTagRegistry registry) {
        for (TypeTagData data : registry.getTypes()) {
            if (!this.shouldMerge(data)) continue;
            return data;
        }
        return null;
    }

    private boolean shouldMerge(TypeTagData data) {
        if (data.getTagName().equals(this.annotation.getTagName())) {
            if (this.keyAttribute == null) {
                return true;
            }
            String value = data.get(this.keyAttribute);
            if (value == null) {
                return false;
            }
            return value.equals(this.annotation.getAttributeValue(this.keyAttribute));
        }
        return false;
    }

    private int injectAnnotation(TypeTagData tagData) {
        this.mergeAttributes(tagData);
        StringBuffer sb = this.getAnnotationStringBuffer();
        int start = tagData.getTagStart();
        int end = tagData.getTagEnd();
        int oldSize = end - start;
        this.buffer.replace(start, oldSize, sb.toString());
        return sb.length() - oldSize;
    }

    private void mergeAttributes(TypeTagData tagData) {
        for (String key : tagData) {
            String oldValue = tagData.get(key);
            this.annotation.mergeAttribute(key, oldValue);
        }
    }

    public void setKeyAttribute(String keyAttribute) {
        this.keyAttribute = keyAttribute;
    }
}

