/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.annotations.gen;

import com.ibm.zcc.etools.annotations.gen.AbstractAnnotationAdapterImpl;
import com.ibm.zcc.etools.annotations.gen.Annotation;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.ITerminalSymbols;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jem.util.logger.proxy.Logger;

public class AnnotationAdapterImpl
extends AbstractAnnotationAdapterImpl
implements ITerminalSymbols,
Comparable {
    private boolean hasJavaDoc;
    private ISourceReference member;
    private int nextInsertPos = -1;
    private int javaDocBegin = -1;
    private static final String NL = System.getProperty("line.separator");
    private char[] tabChars = new char[]{' '};

    public AnnotationAdapterImpl(ISourceReference member, ICompilationUnit compUnit, Annotation annotation) {
        super(compUnit, annotation);
        this.member = member;
        this.init();
    }

    private void init() {
        try {
            this.computeNextInsertPos();
        }
        catch (JavaModelException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
    }

    private void computeNextInsertPos() throws JavaModelException {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        char[] chars = this.member.getSource().toCharArray();
        scanner.setSource(chars);
        int currentTok = -1;
        boolean done = false;
        do {
            try {
                currentTok = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            switch (currentTok) {
                case 158: {
                    done = true;
                    break;
                }
                case 1003: {
                    int beginRange = this.member.getSourceRange().getOffset();
                    this.javaDocBegin = scanner.getCurrentTokenStartPosition() + beginRange;
                    this.nextInsertPos = this.javaDocBegin + 3;
                    this.tabChars = this.computeTabCharacters(scanner);
                    this.hasJavaDoc = true;
                    done = true;
                    break;
                }
                case 165: 
                case 180: {
                    done = true;
                }
            }
        } while (!done);
    }

    private char[] computeTabCharacters(IScanner scanner) {
        int docIndex;
        char[] source = scanner.getRawTokenSource();
        String sourceString = new String(source);
        int index = sourceString.indexOf(NL);
        if (index > -1 && (docIndex = sourceString.indexOf(42, index)) > -1 && docIndex > (index += NL.length())) {
            char[] result = new char[docIndex - index];
            System.arraycopy(source, index, result, 0, result.length);
            return result;
        }
        return new char[]{' '};
    }

    @Override
    public int injectAnnotation() {
        StringBuffer sb = this.getAnnotationStringBuffer();
        this.buffer.replace(this.nextInsertPos, 0, sb.toString());
        return sb.length();
    }

    @Override
    public void offset(int i) {
        if (this.nextInsertPos != -1) {
            this.nextInsertPos += i;
        }
    }

    protected StringBuffer getAnnotationStringBuffer() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasJavaDoc) {
            sb.append("/**");
        }
        sb.append(NL);
        this.insertTabs(sb);
        sb.append("* @");
        sb.append(this.annotation.getTagName());
        this.appendAttributes(sb);
        if (!this.hasJavaDoc) {
            sb.append("*/");
        }
        return sb;
    }

    private void insertTabs(StringBuffer sb) {
        sb.append(this.tabChars);
    }

    private void appendAttributes(StringBuffer sb) {
        Iterator iter = this.annotation.getAttributeIterator();
        Map.Entry entry = null;
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            sb.append(NL);
            this.insertTabs(sb);
            sb.append("* \t");
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(entry.getValue());
            sb.append('\"');
        }
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AnnotationAdapterImpl)) {
            return -1;
        }
        return this.nextInsertPos - ((AnnotationAdapterImpl)o).nextInsertPos;
    }
}

