/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.annotations.gen;

import com.ibm.zcc.etools.wrd.extensions.util.AnnotationUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class Annotation {
    private String tagName;
    private Map attributes;

    public Annotation(String tagName) {
        this(tagName, 5);
    }

    public Annotation(String tagName, int attributeListSize) {
        this.tagName = tagName;
        this.attributes = new LinkedHashMap(attributeListSize);
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttributeValue(String key) {
        return (String)this.attributes.get(key);
    }

    public void mergeAttribute(String key, String oldValue) {
        if (oldValue == null) {
            return;
        }
        String newValue = (String)this.attributes.get(key);
        if (newValue == null) {
            this.setAttribute(key, oldValue);
            return;
        }
        LinkedHashSet<String> allValues = new LinkedHashSet<String>();
        allValues.addAll(Arrays.asList(AnnotationUtil.INSTANCE.parseStringToArray(oldValue)));
        allValues.addAll(Arrays.asList(AnnotationUtil.INSTANCE.parseStringToArray(newValue)));
        StringBuffer sb = new StringBuffer();
        for (String next : allValues) {
            sb.append(next);
            sb.append(' ');
        }
        this.setAttribute(key, sb.toString().trim());
    }

    public Iterator getAttributeIterator() {
        return this.attributes.entrySet().iterator();
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }
}

