/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.etools.annotations.gen;

import com.ibm.zcc.etools.annotations.gen.Annotation;
import com.ibm.zcc.etools.annotations.gen.AnnotationAdapter;
import com.ibm.zcc.etools.annotations.gen.AnnotationAdapterImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyManager;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyManagerFactory;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class AbstractAnnotationOperation
extends AbstractDataModelOperation {
    private boolean isNested;
    protected WorkingCopyManager workingCopyMgr;
    protected ICompilationUnit workingCopy;

    public AbstractAnnotationOperation(IDataModel operationDataModel) {
        super(operationDataModel);
    }

    public WorkingCopyManager getWorkingCopyManager() {
        if (this.workingCopyMgr == null) {
            this.workingCopyMgr = WorkingCopyManagerFactory.newRegisteredInstance();
        }
        return this.workingCopyMgr;
    }

    public void setWorkingCopyManager(WorkingCopyManager in) {
        this.workingCopyMgr = in;
    }

    protected boolean isNested() {
        return this.isNested;
    }

    protected void setNested(boolean in) {
        this.isNested = in;
    }

    protected abstract Annotation createPrimaryTypeAnnotation();

    protected abstract ICompilationUnit getCompilationUnit();

    public final IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        ArrayList allAnnotations = new ArrayList();
        try {
            allAnnotations.addAll(this.getTypeLevelAnnotationAdapters());
            allAnnotations.addAll(this.getMethodLevelAnnotationAdapters());
            this.injectAnnotations(allAnnotations);
            this.executeNested(monitor);
            if (!this.isNested() && this.workingCopyMgr != null) {
                Set files = this.workingCopyMgr.getAffectedFiles();
                this.workingCopyMgr.saveCompilationUnits(monitor);
                this.processResources(files);
            }
        }
        catch (Exception e) {
            throw new ExecutionException("", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    protected List getTypeLevelAnnotationAdapters() throws CoreException {
        this.getWorkingCopy();
        if (this.workingCopy != null) {
            IType member = this.workingCopy.findPrimaryType();
            AnnotationAdapter adapter = this.createPrimaryTypeLevelAdapter((ISourceReference)member);
            return Collections.singletonList(adapter);
        }
        return Collections.EMPTY_LIST;
    }

    protected AnnotationAdapter createPrimaryTypeLevelAdapter(ISourceReference member) {
        return new AnnotationAdapterImpl(member, this.workingCopy, this.createPrimaryTypeAnnotation());
    }

    protected List getMethodLevelAnnotationAdapters() throws CoreException {
        return Collections.EMPTY_LIST;
    }

    protected void executeNested(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
    }

    protected void processResources(Set affectedFiles) throws CoreException {
        IResource[] resources;
        IResource[] iResourceArray = resources = affectedFiles == null ? null : affectedFiles.toArray(new IResource[affectedFiles.size()]);
        if (resources == null || resources.length == 0) {
            return;
        }
        IProject project = resources[0].getProject();
        AnnotationsController controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(project);
        if (controller != null) {
            controller.process(resources);
        }
    }

    protected ICompilationUnit getWorkingCopy() throws CoreException {
        if (this.workingCopy == null) {
            this.workingCopy = this.getWorkingCopyManager().getWorkingCopy(this.getCompilationUnit(), false);
        }
        return this.workingCopy;
    }

    protected void injectAnnotations(List annotationAdapters) {
        if (annotationAdapters == null || annotationAdapters.isEmpty()) {
            return;
        }
        Collections.sort(annotationAdapters);
        int offset = 0;
        int i = 0;
        while (i < annotationAdapters.size()) {
            AnnotationAdapter adapter = (AnnotationAdapter)annotationAdapters.get(i);
            if (offset > 0) {
                adapter.offset(offset);
            }
            offset += adapter.injectAnnotation();
            ++i;
        }
    }
}

