/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.cobol.preference.ui.common;

import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;

public class CobolCodePageFinder {
    public static final String copyright = "Licensed Material - Property of IBM <<com.ibm.etools.cobol.preference.ui>> (C) Copyright IBM Corp. 2003,2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public Object[] findCCodePages() {
        SortedMap<String, Charset> csMap = Charset.availableCharsets();
        Set<String> keySet = csMap.keySet();
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
        TreeSet<String> allCodepages = new TreeSet<String>(c);
        allCodepages.addAll(keySet);
        for (String canonicalCP : keySet) {
            Charset aCs = Charset.forName(canonicalCP);
            Set<String> aliasSet = aCs.aliases();
            if (aliasSet.isEmpty()) continue;
            for (String aliasCP : aliasSet) {
                allCodepages.add(aliasCP);
            }
        }
        return allCodepages.toArray();
    }
}

