/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.impl;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import com.ibm.zosconnect.ui.service.imsdb.ImsDbXlat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

public class ImsDbPropertiesValidator
implements IServicePropertiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public final String className = this.getClass().getName();
    public static final String CONNECTIONNAME = "connectionName";
    public static final String SQL_COMMAND = "sqlCommand";
    public static final String PSB_NAME = "psbName";
    public static final String METADATA = "metadata";
    public static final String PROPERTY_KEY_ARRAY = "arraySupport";
    public static final String REQUEST_SI_NAME = "requestSIName";
    public static final String RESPONSE_SI_NAME = "responseSIName";

    public List<ServiceProjectValidationError> validateDefinitionProperty(IResource resource, String key, String value) {
        ZCeeUILogger.entering((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{resource, key, value});
        ArrayList<ServiceProjectValidationError> result = new ArrayList<ServiceProjectValidationError>();
        if (value == null & !key.equals(PROPERTY_KEY_ARRAY)) {
            String msg = ImsDbXlat.label("REQUIRED_SERVICE_PROPERTY_MISSING", key);
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
            return result;
        }
        switch (key) {
            case "connectionName": {
                if (!value.isEmpty()) break;
                String msg = ImsDbXlat.label("REQUIRED_SERVICE_PROPERTY_MISSING", ImsDbXlat.label("SERVICEEDIT_LABEL_CONNECTIONNAME", new String[0]));
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                break;
            }
            case "sqlCommand": {
                value = value.replace("\n", "").replace("\r", "");
                if (value.isEmpty()) {
                    String msg = ImsDbXlat.label("MUST_CONTAIN_1_CHARACTER", new String[0]);
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                    break;
                }
                if (!value.toUpperCase().matches("(SELECT).*")) {
                    String msg = ImsDbXlat.label("ONLY_SELECT_IS_SUPPORTED", new String[0]);
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                    break;
                }
                if (!value.toUpperCase().matches("(SELECT \\*).*")) break;
                String msg = ImsDbXlat.label("SELECT_STAR", new String[0]);
                ServiceProjectValidationError selectstar = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                selectstar.setSeverity(Integer.valueOf(1));
                result.add(selectstar);
                break;
            }
            case "psbName": {
                if (!value.isEmpty()) break;
                String msg = ImsDbXlat.label("REQUIRED_SERVICE_PROPERTY_MISSING", ImsDbXlat.label("SERVICEEDIT_LABEL_PSBNAME", new String[0]));
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                break;
            }
            case "metadata": {
                if (value.equals("false") || value.equals("")) {
                    String msg = ImsDbXlat.label("METADATA_IS_NOT_GENERATED", new String[0]);
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, msg));
                    break;
                }
                if (!value.equals("dirty")) break;
                String msg = ImsDbXlat.label("METADATA_IS_NOT_REFRESHED", new String[0]);
                ServiceProjectValidationError dirtyschema = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, msg);
                dirtyschema.setSeverity(Integer.valueOf(1));
                result.add(dirtyschema);
                break;
            }
            default: {
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"UNKNOWN_PROPERTY", (String[])new String[]{key})));
            }
            case "responseSIName": 
            case "arraySupport": 
            case "requestSIName": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
        return result;
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IResource resource, String key, String value, boolean isRequired, String propertyType) {
        ServiceProjectValidationError result = null;
        if (isRequired && (value == null || value.isEmpty())) {
            return ImsDbPropertiesValidator.getMissingRequiredPropertyError(resource, key);
        }
        return result;
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IMessageManager messageMgr, HashMap<String, Control> configurationControls, IResource resource, ServiceExtensionProperty extensionProperty, String value) {
        ServiceProjectValidationError result = null;
        boolean isRequired = extensionProperty.isRequired();
        String propertyType = extensionProperty.getPropertyType();
        String key = extensionProperty.getPropertyName();
        result = this.validateConfigurationProperty(serviceController, resource, key, value, isRequired, propertyType);
        return result;
    }

    private static ServiceProjectValidationError getMissingRequiredPropertyError(IResource resource, String key) {
        return new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"MISSING_REQUIRED_PROPERTY", (String[])new String[]{key}));
    }
}

