/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.impl;

import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.service.imsdb.ImsDbXlat;
import com.ibm.zosconnect.ui.service.imsdb.connections.utils.ImsDbUtils;
import com.ibm.zosconnect.ui.service.imsdb.dialogs.SqlSelectionDialog;
import com.ibm.zosconnect.ui.service.imsdb.impl.ImsDbConnectionManagerListener;
import com.ibm.zosconnect.ui.service.imsdb.impl.ImsDbPropertiesValidator;
import com.ibm.zosconnect.ui.service.imsdb.jobs.ImsDbLoadSchemaJob;
import com.ibm.zosconnect.ui.service.interfaces.IServiceOverviewComposite;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImsDbCompositeImpl
implements IServiceOverviewComposite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = this.getClass().getName();
    private FormToolkit formToolkit;
    private Composite parent;
    private IServiceProjectEditor spe;
    private Text txtSqlCommand;
    private Text txtPSBName;
    private Button btnSchemaConn;
    private Combo comboConnections;
    private Button checkBoxArray;
    private String schema = "false";
    private boolean sqlerror = true;
    private String previousSelection;
    private String sqlCommand;
    private String psbName;
    private Boolean arraySupport;
    private IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private ImsDbConnectionManagerListener IMSConnListener;
    private List<ConnectionProfile> conn;

    public List<String> getCustomActions() {
        ArrayList<String> listOfActions = new ArrayList<String>();
        listOfActions.add(ImsDbXlat.label("SERVICEEDIT_ACTIONS_SQL_COMMAND", new String[0]));
        listOfActions.add(ImsDbXlat.label("SERVICEEDIT_ACTIONS_SERVICE_INTERFACE", new String[0]));
        return listOfActions;
    }

    public LinkedHashMap<Composite, String> getComposites(FormToolkit formToolkit, Composite parent, IServiceProjectEditor serviceProjectEditor) {
        this.formToolkit = formToolkit;
        this.parent = parent;
        this.spe = serviceProjectEditor;
        LinkedHashMap<Composite, String> listOfComposites = new LinkedHashMap<Composite, String>();
        listOfComposites.put(this.getSqlSectionComposite(), ImsDbXlat.label("SERVICEEDIT_SECTION_SQL_COMMAND", new String[0]));
        listOfComposites.put(this.getGenerateSchemaServiceInterfaceComposite(), ImsDbXlat.label("SERVICEEDIT_SECTION_GENERATESERVICEINTERFACE", new String[0]));
        this.IMSConnListener = new ImsDbConnectionManagerListener(this);
        this.connectionManager.addListener((ConnectionManagerListener)this.IMSConnListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ImsDbCompositeImpl.this.IMSConnListener.makeStale();
            }
        });
        return listOfComposites;
    }

    private Composite getSqlSectionComposite() {
        ZCeeUILogger.entering((String)this.className, (String)"getSqlSectionComposite", (Object[])new Object[0]);
        Composite composite = this.formToolkit.createComposite(this.parent, 0);
        this.formToolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.formToolkit.createLabel(composite, ImsDbXlat.label("SERVICEEDIT_LABEL_SQL_COMMAND", new String[0]) + Xlat.colon(), 0);
        this.txtSqlCommand = this.formToolkit.createText(composite, "", 578);
        this.txtSqlCommand.setToolTipText(ImsDbXlat.label("SERVICEEDIT_SQLTEXT_TOOLTIP", new String[0]));
        GridData gd_sqlText = new GridData(4, 4, true, true, 1, 3);
        gd_sqlText.widthHint = XSwt.getAverageCharWidth((Control)this.txtSqlCommand) * 40;
        gd_sqlText.heightHint = XSwt.getFontHeight((Control)this.txtSqlCommand) * 5;
        gd_sqlText.horizontalIndent = 5;
        this.txtSqlCommand.setLayoutData((Object)gd_sqlText);
        this.txtSqlCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String newSqlCommand = ImsDbCompositeImpl.this.txtSqlCommand.getText();
                if (!newSqlCommand.equals(ImsDbCompositeImpl.this.sqlCommand)) {
                    ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceSQL(newSqlCommand);
                    ImsDbCompositeImpl.this.sqlCommand = newSqlCommand;
                    ImsDbCompositeImpl.this.validateSql(newSqlCommand);
                    if (ImsDbCompositeImpl.this.schema.equals("true")) {
                        ImsDbCompositeImpl.this.schema = "dirty";
                    }
                    ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceMetadata(ImsDbCompositeImpl.this.schema);
                    ImsDbCompositeImpl.this.updateGenerateSchemaButton();
                    ImsDbCompositeImpl.this.spe.setDirty(true);
                }
            }
        });
        Button btnImportSQL = this.formToolkit.createButton(composite, ImsDbXlat.label("SERVICEEDIT_BUTTON_BROWSE", new String[0]), 0);
        btnImportSQL.setToolTipText(ImsDbXlat.label("SERVICEEDIT_BUTTON_IMPORTSQL_TOOLTIP", new String[0]));
        btnImportSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String sqlText = ImsDbCompositeImpl.this.sqlSelection();
                    if (sqlText != null) {
                        ImsDbCompositeImpl.this.txtSqlCommand.setText(sqlText);
                    }
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                }
            }
        });
        this.formToolkit.createLabel(composite, "", 0);
        this.formToolkit.createLabel(composite, "", 0);
        this.formToolkit.createLabel(composite, "", 0);
        this.formToolkit.createLabel(composite, "", 0);
        this.formToolkit.createLabel(composite, "", 0);
        this.checkBoxArray = this.formToolkit.createButton(composite, ImsDbXlat.label("SERVICEEDIT_LABEL_ARRAY", new String[0]), 32);
        GridData gd_checkBox = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.checkBoxArray.setLayoutData((Object)gd_checkBox);
        this.checkBoxArray.setToolTipText(ImsDbXlat.label("SERVICEEDIT_LABEL_ARRAY_TOOLTIP", new String[0]));
        boolean isChecked = this.checkBoxArray();
        this.checkBoxArray.setSelection(isChecked);
        this.checkBoxArray.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                boolean isChecked = ((Button)event.getSource()).getSelection();
                ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setArraySupport(Boolean.valueOf(isChecked));
                if (ImsDbCompositeImpl.this.schema.equals("true")) {
                    ImsDbCompositeImpl.this.schema = "dirty";
                }
                ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceMetadata(ImsDbCompositeImpl.this.schema);
                ImsDbCompositeImpl.this.updateGenerateSchemaButton();
                ImsDbCompositeImpl.this.spe.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        ZCeeUILogger.exiting((String)this.className, (String)"getSqlSectionComposite", (Object[])new Object[]{composite});
        return composite;
    }

    public void addOrUpdateIMSConnection(ConnectionProfile profile) {
        ZCeeUILogger.entering((String)this.className, (String)"updateIMSConnection()", (Object[])new Object[0]);
        this.updateConnections(profile, false, false);
        ZCeeUILogger.exiting((String)this.className, (String)"updateIMSConnection()", (Object[])new Object[0]);
    }

    public void removeIMSConnection(ConnectionProfile profile) {
        ZCeeUILogger.entering((String)this.className, (String)"updateIMSConnection()", (Object[])new Object[0]);
        this.updateConnections(profile, false, true);
        ZCeeUILogger.exiting((String)this.className, (String)"updateIMSConnection()", (Object[])new Object[0]);
    }

    private String sqlSelection() {
        String sqlCommand = null;
        SqlSelectionDialog dialog = new SqlSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.spe.getServiceProjectController(), this.spe.getServiceProjectController().getServiceModel(), true);
        if (dialog.open() == 0) {
            sqlCommand = dialog.getSqlText();
        }
        return sqlCommand;
    }

    private Composite getGenerateSchemaServiceInterfaceComposite() {
        ZCeeUILogger.entering((String)this.className, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[0]);
        Composite composite = this.formToolkit.createComposite(this.parent, 0);
        this.formToolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(6, false));
        this.formToolkit.createLabel(composite, ImsDbXlat.label("SERVICEEDIT_LABEL_CONNECTIONNAME", new String[0]) + Xlat.colon(), 0);
        this.comboConnections = new Combo(composite, 8);
        this.comboConnections.setToolTipText(ImsDbXlat.label("SERVICEEDIT_CONNECTIONS_TOOLTIP", new String[0]));
        GridData gd_req = new GridData(4, 0x1000000, false, true, 1, 1);
        gd_req.widthHint = 150;
        gd_req.horizontalIndent = 10;
        this.comboConnections.setLayoutData((Object)gd_req);
        this.formToolkit.adapt((Composite)this.comboConnections);
        this.formToolkit.paintBordersFor((Composite)this.comboConnections);
        this.comboConnections.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ZCeeUILogger.info((String)"Gained focus", (Object[])new Object[0]);
                String currentSelection = ImsDbCompositeImpl.this.comboConnections.getText();
                for (ConnectionProfile connection : ImsDbCompositeImpl.this.conn) {
                    if (!connection.getName().equals(currentSelection)) continue;
                    ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceConnectionName(connection.getName());
                }
            }

            public void focusLost(FocusEvent e) {
                ZCeeUILogger.info((String)"Lost focus", (Object[])new Object[0]);
            }
        });
        this.comboConnections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ImsDbCompositeImpl.this.spe.isLoading()) {
                    String currentSelection = ImsDbCompositeImpl.this.comboConnections.getText();
                    for (ConnectionProfile connection : ImsDbCompositeImpl.this.conn) {
                        if (!connection.getName().equals(currentSelection)) continue;
                        ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceConnectionName(connection.getName());
                    }
                    ImsDbCompositeImpl.this.validateConnections();
                    if (!currentSelection.equals(ImsDbCompositeImpl.this.previousSelection)) {
                        if (ImsDbCompositeImpl.this.schema.equals("true")) {
                            ImsDbCompositeImpl.this.schema = "dirty";
                        }
                        ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceMetadata(ImsDbCompositeImpl.this.schema);
                        ImsDbCompositeImpl.this.spe.setDirty(true);
                    }
                    ImsDbCompositeImpl.this.updateGenerateSchemaButton();
                    ImsDbCompositeImpl.this.previousSelection = currentSelection;
                }
            }
        });
        this.formToolkit.createLabel(composite, "    ", 0);
        this.formToolkit.createLabel(composite, ImsDbXlat.label("SERVICEEDIT_LABEL_PSBNAME", new String[0]) + Xlat.colon(), 0);
        this.txtPSBName = this.formToolkit.createText(composite, "", 0);
        this.txtPSBName.setToolTipText(ImsDbXlat.label("SERVICEEDIT_PSBNAME_TOOLTIP", new String[0]));
        GridData gd_txtPSBName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtPSBName.horizontalIndent = 10;
        gd_txtPSBName.widthHint = 150;
        this.txtPSBName.setLayoutData((Object)gd_txtPSBName);
        this.txtPSBName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String newPSBName = ImsDbCompositeImpl.this.txtPSBName.getText();
                ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServicePSBName(newPSBName);
                List<ServiceProjectValidationError> errorValidation = new ImsDbPropertiesValidator().validateDefinitionProperty(ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().getResource(), "psbName", newPSBName);
                String key = "psbName";
                if (errorValidation.size() != 0) {
                    ImsDbCompositeImpl.this.spe.getServiceProjectValidator().setControlToError(ImsDbCompositeImpl.this.spe.getMessageManager(), key, errorValidation.get(0), (Control)ImsDbCompositeImpl.this.txtPSBName);
                } else {
                    ImsDbCompositeImpl.this.spe.getServiceProjectValidator().resetControlToError(ImsDbCompositeImpl.this.spe.getMessageManager(), key, (Control)ImsDbCompositeImpl.this.txtPSBName);
                }
                if (!newPSBName.equals(ImsDbCompositeImpl.this.psbName)) {
                    ImsDbCompositeImpl.this.spe.setDirty(true);
                    if (ImsDbCompositeImpl.this.schema.equals("true")) {
                        ImsDbCompositeImpl.this.schema = "dirty";
                    }
                    ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceMetadata(ImsDbCompositeImpl.this.schema);
                    ImsDbCompositeImpl.this.updateGenerateSchemaButton();
                    ImsDbCompositeImpl.this.psbName = newPSBName;
                }
            }
        });
        Label label = this.formToolkit.createLabel(composite, ImsDbXlat.label("GENERATE_SERVICE_INTERFACE", new String[0]) + Xlat.colon(), 0);
        GridData data = new GridData(4, 4, true, true);
        label.setLayoutData((Object)data);
        data.exclude = true;
        label.setVisible(false);
        this.btnSchemaConn = this.formToolkit.createButton(composite, ImsDbXlat.label("SERVICEEDIT_BUTTON_SCHEMA", new String[0]), 0);
        GridData gd_sch = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_sch.horizontalIndent = 10;
        this.btnSchemaConn.setLayoutData((Object)gd_sch);
        this.formToolkit.adapt((Control)this.btnSchemaConn, true, true);
        this.btnSchemaConn.getParent().setToolTipText(this.btnSchemaConn.getToolTipText());
        this.btnSchemaConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String currentSelection = ImsDbCompositeImpl.this.comboConnections.getText();
                    for (ConnectionProfile connection : ImsDbCompositeImpl.this.conn) {
                        if (!connection.getName().equals(currentSelection)) continue;
                        ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceConnectionName(connection.getName());
                    }
                    ImsDbCompositeImpl.this.generateSchema();
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                    ZCeeUILogger.error((Throwable)exception);
                    ZCeeErrorDialog.openError((Exception)exception);
                }
            }
        });
        ZCeeUILogger.exiting((String)this.className, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[]{composite});
        return composite;
    }

    private void updateGenerateSchemaButton() {
        if (this.sqlerror || this.spe.getServiceProjectController().getServiceModel().getServiceConnectionName().isEmpty() || this.spe.getServiceProjectController().getServiceModel().getServicePSBName().isEmpty()) {
            this.btnSchemaConn.setEnabled(false);
            this.btnSchemaConn.setToolTipText(ImsDbXlat.label("SERVICEEDIT_BUTTON_SCHEMA_ERROR_TOOLTIP", new String[0]));
        } else {
            this.btnSchemaConn.setEnabled(true);
            this.btnSchemaConn.setToolTipText(ImsDbXlat.label("SERVICEEDIT_BUTTON_SCHEMA_TOOLTIP", new String[0]));
        }
        String key = "metadata";
        List<ServiceProjectValidationError> errorValidation = new ImsDbPropertiesValidator().validateDefinitionProperty(this.spe.getServiceProjectController().getServiceModel().getResource(), key, this.schema);
        if (errorValidation.size() != 0) {
            if (errorValidation.get(0).getSeverity() == 2) {
                this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), key, errorValidation.get(0), (Control)this.btnSchemaConn);
            } else if (errorValidation.get(0).getSeverity() == 1) {
                this.spe.getServiceProjectValidator().setControlToWarning(this.spe.getMessageManager(), key, errorValidation.get(0), (Control)this.btnSchemaConn);
            }
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), key, (Control)this.btnSchemaConn);
        }
    }

    public void refreshPage(Properties properties) {
        ZCeeUILogger.entering((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
        for (Object keyObj : properties.keySet()) {
            String key;
            switch (key = (String)keyObj) {
                case "arraySupport": {
                    this.arraySupport = this.spe.getServiceProjectController().getServiceModel().getArraySupport();
                    this.checkBoxArray.setSelection(this.arraySupport.booleanValue());
                    break;
                }
                case "sqlCommand": {
                    this.sqlCommand = this.spe.getServiceProjectController().getServiceModel().getServiceSQL();
                    this.validateSql(this.sqlCommand);
                    this.txtSqlCommand.setText(this.sqlCommand);
                    break;
                }
                case "psbName": {
                    this.psbName = this.spe.getServiceProjectController().getServiceModel().getServicePSBName();
                    this.txtPSBName.setText(this.psbName);
                    break;
                }
                case "metadata": {
                    this.schema = this.spe.getServiceProjectController().getServiceModel().getServiceMetadata();
                    break;
                }
                case "connectionName": {
                    ConnectionProfile dcp = ImsDbUtils.getDefaultConnectionProfile();
                    if (dcp != null && this.spe.getServiceProjectController().getServiceModel().getServiceConnectionName().isEmpty()) {
                        this.updateConnections(dcp, true, false);
                    } else {
                        this.updateConnections(null, false, false);
                    }
                    this.validateConnections();
                    break;
                }
            }
        }
        this.updateGenerateSchemaButton();
        ZCeeUILogger.exiting((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
    }

    private void validateConnections() {
        List<ServiceProjectValidationError> errorValidation = new ImsDbPropertiesValidator().validateDefinitionProperty(this.spe.getServiceProjectController().getServiceModel().getResource(), "connectionName", this.comboConnections.getText());
        String key = "connectionName";
        if (errorValidation.size() != 0) {
            this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), key, errorValidation.get(0), (Control)this.comboConnections);
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), key, (Control)this.comboConnections);
        }
    }

    private void validateSql(String sql) {
        List<ServiceProjectValidationError> errorValidation = new ImsDbPropertiesValidator().validateDefinitionProperty(this.spe.getServiceProjectController().getServiceModel().getResource(), "sqlCommand", sql);
        String key = "sqlCommand";
        if (errorValidation.size() != 0) {
            if (errorValidation.get(0).getSeverity() == 1) {
                this.spe.getServiceProjectValidator().setControlToWarning(this.spe.getMessageManager(), key, errorValidation.get(0), (Control)this.txtSqlCommand);
                this.sqlerror = false;
            } else {
                this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), key, errorValidation.get(0), (Control)this.txtSqlCommand);
                this.sqlerror = true;
            }
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), key, (Control)this.txtSqlCommand);
            this.sqlerror = false;
        }
    }

    public List<String> getSiFileNameList() {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            IResource[] iResourceArray = this.spe.getServiceProjectController().getFolder("service-interfaces").members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getFileExtension().equalsIgnoreCase("si")) {
                    fileNames.add(resource.getName());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        return fileNames;
    }

    private void updateConnections(ConnectionProfile newConnection, boolean isDefault, boolean remove) {
        String connName;
        String currentConnectionName = this.spe.getServiceProjectController().getServiceModel().getServiceConnectionName();
        String newConnectionName = "";
        if (newConnection != null) {
            newConnectionName = newConnection.getName();
        }
        this.conn = ImsDbUtils.getAllConnections();
        this.comboConnections.removeAll();
        for (ConnectionProfile connection : this.conn) {
            this.comboConnections.add(connection.getName());
        }
        String[] items = this.comboConnections.getItems();
        Arrays.sort(items, new SortIgnoreCase());
        this.comboConnections.setItems(items);
        if (remove && newConnectionName.equals(currentConnectionName)) {
            this.spe.getServiceProjectController().getServiceModel().setServiceConnectionName("");
            this.btnSchemaConn.setEnabled(false);
            this.spe.setDirty(true);
            this.validateConnections();
            return;
        }
        if (isDefault && currentConnectionName.isEmpty()) {
            int index = 0;
            while (index < this.comboConnections.getItemCount()) {
                connName = this.comboConnections.getItem(index);
                if (newConnection.getName().equals(connName)) {
                    this.comboConnections.select(index);
                    this.spe.getServiceProjectController().getServiceModel().setServiceConnectionName(newConnectionName);
                    this.spe.setDirty(true);
                    return;
                }
                ++index;
            }
        }
        if (!isDefault && !currentConnectionName.isEmpty()) {
            int index = 0;
            while (index < this.comboConnections.getItemCount()) {
                connName = this.comboConnections.getItem(index);
                if (currentConnectionName.equals(connName)) {
                    this.comboConnections.select(index);
                    this.spe.getServiceProjectController().getServiceModel().setServiceConnectionName(currentConnectionName);
                    this.spe.setDirty(true);
                    return;
                }
                ++index;
            }
        }
        if (!this.spe.getServiceProjectController().getServiceModel().getServiceConnectionName().isEmpty()) {
            this.spe.setDirty(true);
        }
        this.spe.getServiceProjectController().getServiceModel().setServiceConnectionName("");
        this.btnSchemaConn.setEnabled(false);
    }

    private void generateSchema() throws Exception {
        String sqlCommand = this.spe.getServiceProjectController().getServiceModel().getServiceSQL();
        String connectionName = this.spe.getServiceProjectController().getServiceModel().getServiceConnectionName();
        String PSBName = this.spe.getServiceProjectController().getServiceModel().getServicePSBName();
        Boolean arraySupport = this.spe.getServiceProjectController().getServiceModel().getArraySupport();
        final ImsDbLoadSchemaJob imsDbLoadSchemaJob = new ImsDbLoadSchemaJob(this.conn, connectionName, sqlCommand, this.spe.getServiceProjectController().getProject().getName(), PSBName, arraySupport);
        imsDbLoadSchemaJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (imsDbLoadSchemaJob.getResult() == Status.OK_STATUS) {
                            (this).ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceRequestSIName("request.si");
                            (this).ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceResponseSIName("response.si");
                            List<String> newNames = imsDbLoadSchemaJob.getNewProps();
                            Object message = ImsDbXlat.label("SI_GENERATE_SUCCESS", new String[0]);
                            if (newNames.get(0).isEmpty() && newNames.get(1).isEmpty()) {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ImsDbXlat.label("GENERATE_SERVICE_INTERFACE", new String[0]), (String)message);
                            } else {
                                if (!newNames.get(1).isEmpty()) {
                                    message = (String)message + "\n\n" + ImsDbXlat.label("SI_RENAMED_COLUMNS", newNames.get(1));
                                }
                                if (!newNames.get(0).isEmpty()) {
                                    message = (String)message + "\n\n" + ImsDbXlat.label("SI_RENAMED_PROPERTIES", newNames.get(0));
                                }
                                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ImsDbXlat.label("GENERATE_SERVICE_INTERFACE", new String[0]), (String)message);
                            }
                            (this).ImsDbCompositeImpl.this.schema = "true";
                            (this).ImsDbCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setServiceMetadata((this).ImsDbCompositeImpl.this.schema);
                            (this).ImsDbCompositeImpl.this.spe.setDirty(true);
                            IEditorPart currentEditor = (IEditorPart)(this).ImsDbCompositeImpl.this.spe;
                            if (currentEditor != null && currentEditor.isDirty()) {
                                currentEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                                (this).ImsDbCompositeImpl.this.spe.setDirty(false);
                            }
                        }
                        ImsDbCompositeImpl.this.updateGenerateSchemaButton();
                    }
                });
            }
        });
        imsDbLoadSchemaJob.setUser(true);
        imsDbLoadSchemaJob.schedule();
    }

    public boolean checkBoxArray() {
        String value = this.spe.getServiceProjectController().getServiceModel().getValue("arraySupport");
        return value != null && value.contentEquals("true");
    }

    private class SortIgnoreCase
    implements Comparator<Object> {
        private SortIgnoreCase() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    }
}

