/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.dialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.dialogs.WorkspaceSingleFileSelectionDialog;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceProjectController;
import com.ibm.zosconnect.ui.service.imsdb.ImsDbXlat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SqlSelectionDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Composite compButtonBar;
    private Label lblSelectSql;
    private List listSql;
    private Button btnWorkspace;
    private Button btnFileSystem;
    private Button btnOk;
    private String sqlText;
    private boolean isContextMenu;
    private IServiceProjectController serviceProjectController;

    public SqlSelectionDialog(Shell parentShell, IServiceProjectController iServiceProjectController, IServiceModelController iServiceModelController, boolean isContextMenu) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.serviceProjectController = iServiceProjectController;
        this.isContextMenu = isContextMenu;
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) throws Exception {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblSelectSql = new Label(this.compContents, 0);
        this.lblSelectSql.setText(ImsDbXlat.label("SQL_IMPORT_DIALOG_TEXT_FILE", new String[0]));
        new Label(this.compContents, 0);
        this.listSql = new List(this.compContents, 2816);
        GridData gd_compResourceBrowser = new GridData(4, 128, false, false, 1, 1);
        gd_compResourceBrowser.widthHint = 400;
        gd_compResourceBrowser.heightHint = 250;
        this.listSql.setLayoutData((Object)gd_compResourceBrowser);
        this.listSql.setBounds(0, 0, 89, 89);
        this.listSql.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (SqlSelectionDialog.this.listSql.getSelectionCount() == 1) {
                    SqlSelectionDialog.this.btnOk.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        if (this.isContextMenu) {
            this.listSql.setEnabled(false);
        }
        this.compButtonBar = new Composite(this.compContents, 0);
        GridLayout gl_compButtonBar = new GridLayout(1, false);
        gl_compButtonBar.horizontalSpacing = 0;
        gl_compButtonBar.marginBottom = 5;
        gl_compButtonBar.marginHeight = 0;
        this.compButtonBar.setLayout((Layout)gl_compButtonBar);
        this.compButtonBar.setLayoutData((Object)new GridData(0x1000000, 128, false, true, 1, 1));
        this.btnWorkspace = new Button(this.compButtonBar, 0);
        this.btnWorkspace.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnWorkspace.setText(Xlat.label((String)"APIDLG_BUTTON_WORKSPACE"));
        this.btnWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkspaceSingleFileSelectionDialog dialog = new WorkspaceSingleFileSelectionDialog(null, ImsDbXlat.label("SQL_IMPORT_DIALOG_TITLE", new String[0]), ImsDbXlat.label("SQL_IMPORT_DIALOG_MESSAGE", new String[0]), "sql", true, SqlSelectionDialog.this.serviceProjectController.getProject());
                if (dialog.open() == 0) {
                    IResource sqlFile = dialog.getResult();
                    File sourceSQLFile = sqlFile.getLocation().toFile();
                    try {
                        byte[] encoded = Files.readAllBytes(sourceSQLFile.toPath());
                        SqlSelectionDialog.this.sqlText = new String(encoded);
                    }
                    catch (IOException exception) {
                        EclipseLogger.logError((Throwable)exception);
                    }
                    SqlSelectionDialog.this.listSql.add(sourceSQLFile.getName());
                }
            }
        });
        this.btnFileSystem = new Button(this.compButtonBar, 0);
        this.btnFileSystem.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnFileSystem.setText(Xlat.label((String)"APIDLG_BUTTON_FILE_SYSTEM"));
        this.btnFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(SqlSelectionDialog.this.btnFileSystem.getShell(), 4100);
                dialog.setFilterExtensions(new String[]{"*.sql"});
                dialog.setFilterPath("/");
                String firstFileName = dialog.open();
                if (firstFileName != null) {
                    String path = firstFileName.substring(0, firstFileName.lastIndexOf(File.separator) + 1);
                    String[] fileNames = dialog.getFileNames();
                    int i = 0;
                    while (i < fileNames.length) {
                        String name = path + fileNames[i];
                        File sourceSQLFile = new File(name);
                        try {
                            byte[] encoded = Files.readAllBytes(sourceSQLFile.toPath());
                            SqlSelectionDialog.this.sqlText = new String(encoded);
                        }
                        catch (IOException exception) {
                            EclipseLogger.logError((Throwable)exception);
                        }
                        SqlSelectionDialog.this.listSql.add(name);
                        ++i;
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.service.composeinterface");
        return compDialogArea;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.btnOk = this.getButton(0);
        if (!this.isContextMenu) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.btnOk.setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ImsDbXlat.label("SQL_IMPORT_DIALOG_TITLE", new String[0]));
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (!XSwt.isOK((IStatus)status)) {
            ZCeeUILogger.error((IStatus)status);
        }
    }
}

