/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.controllers;

import com.ibm.ims.dli.DLIException;
import com.ibm.ims.jdbc.ParameterMetaDataImpl;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.imsdb.ImsDbXlat;
import com.ibm.zosconnect.ui.service.imsdb.controllers.ImsdbFieldInfoPreservationVisitor;
import com.ibm.zosconnect.wv.metadata.transaction.AlignmentType;
import com.ibm.zosconnect.wv.metadata.transaction.ApplicationDatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MarshallerType;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.PhysicalDatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class ImsdbServiceSchemaController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String TAG = ImsdbServiceSchemaController.class.getName();
    private MessageWalker walker;
    private List<String> newNames = new ArrayList<String>();

    public ImsdbServiceSchemaController() {
        this.walker = new MessageWalker();
    }

    public IStatus loadSchema(Connection connection, String sqlCommand, final String projectName) throws JAXBException, CoreException, SQLException, ClassNotFoundException, MessageWalkerException, DLIException {
        Object newProps = "";
        Object newCols = "";
        MessageType requestMsgType = new MessageType();
        SegmentType requestSegment = new SegmentType();
        FieldType requestField = new FieldType();
        FieldType responseField = new FieldType();
        MessageType responseMsgType = new MessageType();
        SegmentType responseSegment = new SegmentType();
        ApplicationDatatypeType structType = new ApplicationDatatypeType();
        structType.setDatatype(DatatypeType.STRUCT);
        ApplicationDatatypeType arrayType = new ApplicationDatatypeType();
        arrayType.setDatatype(DatatypeType.ARRAY);
        requestSegment.setId(BigInteger.valueOf(1L));
        requestSegment.setName("Segment 1");
        requestSegment.setOriginalName("Segment 1");
        responseSegment.setId(BigInteger.valueOf(1L));
        responseSegment.setName("Segment 1");
        responseSegment.setOriginalName("Segment 1");
        requestField.setName("request");
        requestField.setOriginalName("Input Parameters");
        requestField.setIncluded(YesnoType.Y);
        requestField.setPath("request");
        requestField.setStartPos(Integer.valueOf(0));
        requestField.setBytes(Integer.valueOf(0));
        requestField.setApplicationDatatype(structType);
        responseField.setName("response");
        responseField.setOriginalName("Output Columns");
        responseField.setIncluded(YesnoType.Y);
        responseField.setPath("response");
        responseField.setStartPos(Integer.valueOf(0));
        responseField.setBytes(Integer.valueOf(0));
        responseField.setApplicationDatatype(structType);
        FieldType resultField = new FieldType();
        resultField.setName("result");
        resultField.setOriginalName("Result");
        resultField.setIncluded(YesnoType.Y);
        resultField.setPath("result");
        resultField.setStartPos(Integer.valueOf(0));
        resultField.setBytes(Integer.valueOf(0));
        resultField.setMinOccurs(Integer.valueOf(0));
        resultField.setMaxOccurs(Integer.valueOf(0));
        resultField.setApplicationDatatype(arrayType);
        responseField.getField().add(resultField);
        PreparedStatement statement = connection.prepareStatement(sqlCommand);
        ParameterMetaData parameterMetaData = statement.getParameterMetaData();
        int paramCount = parameterMetaData.getParameterCount();
        HashMap<Object, Integer> paramAndCount = new HashMap<Object, Integer>();
        Boolean popup = false;
        int param = 1;
        while (param <= paramCount) {
            String param_type = parameterMetaData.getParameterTypeName(param);
            if (!param_type.equals("ARRAY") && !param_type.equals("STRUCT")) {
                Integer count;
                Object paramName = ((ParameterMetaDataImpl)parameterMetaData).getParameterName(param);
                if (((String)paramName).isEmpty()) {
                    paramName = "parameter" + String.valueOf(param);
                    popup = true;
                }
                if ((count = (Integer)paramAndCount.get(paramName)) == null) {
                    paramAndCount.put(paramName, 0);
                } else {
                    int n;
                    if (count == 0) {
                        n = 2;
                    } else {
                        count = count + 1;
                        n = count;
                    }
                    paramAndCount.put(paramName, n);
                    popup = true;
                }
                FieldType field = new FieldType();
                field.setName((String)paramName);
                field.setOriginalName((String)paramName);
                field.setIncluded(YesnoType.Y);
                field.setPath("request." + (String)paramName);
                field.setStartPos(Integer.valueOf(0));
                ApplicationDatatypeType datatype = new ApplicationDatatypeType();
                DatatypeType type = this.convertTypes(field, param_type, parameterMetaData.getPrecision(param), parameterMetaData.isSigned(param));
                datatype.setPrecision(Integer.valueOf(parameterMetaData.getPrecision(param)));
                datatype.setScale(Integer.valueOf(parameterMetaData.getScale(param)));
                datatype.setDatatype(type);
                field.setApplicationDatatype(datatype);
                requestField.getField().add(field);
            }
            ++param;
        }
        if (popup.booleanValue()) {
            List fields = requestField.getField();
            int i = fields.size() - 1;
            while (i >= 0) {
                Integer count = (Integer)paramAndCount.get(((FieldType)fields.get(i)).getName());
                if (count != null && count != 0) {
                    String name = ((FieldType)fields.get(i)).getName() + String.valueOf(count);
                    count = count - 1;
                    paramAndCount.put(((FieldType)fields.get(i)).getName(), count);
                    ((FieldType)fields.get(i)).setName(name);
                    newProps = name + ", " + (String)newProps;
                }
                --i;
            }
            newProps = ((String)newProps).substring(0, ((String)newProps).length() - 2);
        }
        requestSegment.getField().add(requestField);
        requestMsgType.getSegment().add(requestSegment);
        requestMsgType.setId(BigInteger.valueOf(1L));
        requestMsgType.setName(projectName + "_Request");
        final Message requestMessage = new Message();
        requestMessage.setMessage(requestMsgType);
        requestMessage.setMessageName(projectName + "_Request");
        requestMessage.setDirection(BigInteger.valueOf(0L));
        requestMessage.setServiceType(ServiceArchiveConstants.SP_Type.IMSDB.toString());
        String noWhere = sqlCommand.replace("\n", "").replace("\r", "");
        int whereWhere = noWhere.indexOf("WHERE");
        if (whereWhere > 0) {
            noWhere = noWhere.substring(0, whereWhere - 1);
        }
        statement = connection.prepareStatement(noWhere);
        ResultSet resultSet = statement.executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int numColumns = resultSetMetaData.getColumnCount();
        popup = false;
        HashMap<String, Integer> columnAndCount = new HashMap<String, Integer>();
        boolean next = true;
        int column = 1;
        while (column <= numColumns) {
            String column_type = resultSetMetaData.getColumnTypeName(column);
            if (!column_type.equals("STRUCT")) {
                boolean sign;
                String column_name = resultSetMetaData.getColumnName(column);
                Integer count = (Integer)columnAndCount.get(column_name);
                if (count == null) {
                    columnAndCount.put(column_name, 0);
                } else {
                    int n;
                    if (count == 0) {
                        n = 2;
                    } else {
                        count = count + 1;
                        n = count;
                    }
                    columnAndCount.put(column_name, n);
                    popup = true;
                }
                FieldType field = new FieldType();
                field.setName(column_name);
                field.setOriginalName(column_name);
                field.setIncluded(YesnoType.Y);
                field.setPath("response." + column_name);
                field.setStartPos(Integer.valueOf(0));
                try {
                    sign = resultSetMetaData.isSigned(column);
                }
                catch (SQLException e) {
                    ZCeeUILogger.info((String)"skipped isSign() due to segment error: {0}.", (Throwable)e, (Object[])new Object[0]);
                    sign = false;
                }
                ApplicationDatatypeType datatype = new ApplicationDatatypeType();
                DatatypeType type = this.convertTypes(field, column_type, resultSetMetaData.getColumnDisplaySize(column), sign);
                datatype.setDatatype(type);
                datatype.setPrecision(Integer.valueOf(resultSetMetaData.getPrecision(column)));
                datatype.setScale(Integer.valueOf(resultSetMetaData.getScale(column)));
                field.setApplicationDatatype(datatype);
                resultField.getField().add(field);
                if (column_type.equals("ARRAY")) {
                    String array_name = resultSetMetaData.getColumnName(column);
                    if (next) {
                        resultSet.next();
                        next = false;
                    }
                    Array columnArray = resultSet.getArray(array_name);
                    ResultSet arrayResultSet = columnArray.getResultSet();
                    ResultSetMetaData arrayMetaData = arrayResultSet.getMetaData();
                    int acolumn = 1;
                    while (acolumn <= arrayMetaData.getColumnCount()) {
                        String acolumn_type = arrayMetaData.getColumnTypeName(acolumn);
                        String acolumn_name = arrayMetaData.getColumnName(acolumn);
                        ZCeeUILogger.info((String)"array column type: {0}, array column name {1}", (Object[])new Object[]{acolumn_type, acolumn_name});
                        FieldType subfield = new FieldType();
                        subfield.setName(acolumn_name);
                        subfield.setOriginalName(acolumn_name);
                        subfield.setIncluded(YesnoType.Y);
                        subfield.setPath("response." + array_name + "." + acolumn_name);
                        subfield.setStartPos(Integer.valueOf(0));
                        try {
                            sign = resultSetMetaData.isSigned(acolumn);
                        }
                        catch (SQLException e) {
                            ZCeeUILogger.info((String)"skipped isSign() due to segment error: {0}.", (Throwable)e, (Object[])new Object[0]);
                            sign = false;
                        }
                        ApplicationDatatypeType subdatatype = new ApplicationDatatypeType();
                        type = this.convertTypes(subfield, acolumn_type, arrayMetaData.getColumnDisplaySize(acolumn), sign);
                        subdatatype.setDatatype(type);
                        subdatatype.setPrecision(Integer.valueOf(arrayMetaData.getPrecision(acolumn)));
                        subdatatype.setScale(Integer.valueOf(arrayMetaData.getScale(acolumn)));
                        subfield.setApplicationDatatype(subdatatype);
                        field.getField().add(subfield);
                        ++acolumn;
                    }
                }
            }
            ++column;
        }
        if (popup.booleanValue()) {
            List fields = resultField.getField();
            int i = fields.size() - 1;
            while (i >= 0) {
                Integer count = (Integer)columnAndCount.get(((FieldType)fields.get(i)).getName());
                if (count != null && count != 0) {
                    String name = ((FieldType)fields.get(i)).getName() + String.valueOf(count);
                    count = count - 1;
                    columnAndCount.put(((FieldType)fields.get(i)).getName(), count);
                    ((FieldType)fields.get(i)).setName(name);
                    newCols = name + ", " + (String)newCols;
                }
                --i;
            }
            newCols = ((String)newCols).substring(0, ((String)newCols).length() - 2);
        }
        responseSegment.getField().add(responseField);
        responseMsgType.getSegment().add(responseSegment);
        responseMsgType.setId(BigInteger.valueOf(1L));
        responseMsgType.setName(projectName + "_Response");
        final Message responseMessage = new Message();
        responseMessage.setMessage(responseMsgType);
        responseMessage.setMessageName(projectName + "_Response");
        responseMessage.setDirection(BigInteger.valueOf(0L));
        responseMessage.setServiceType(ServiceArchiveConstants.SP_Type.IMSDB.toString());
        connection.commit();
        connection.close();
        this.newNames.add((String)newProps);
        this.newNames.add((String)newCols);
        ArrayList<IFile> filesToClose = new ArrayList<IFile>();
        Boolean dataloss = false;
        IFile oldRequestFile = ProjectTreeFileHelper.getzCEEProgramMsgFile((String)projectName, (String)"request");
        Message oldRequestMessage = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)oldRequestFile);
        FieldType oldRequestDs = ImsdbServiceSchemaController.getFirstDataStructure(oldRequestMessage);
        FieldType newRequestDs = ImsdbServiceSchemaController.getFirstDataStructure(requestMessage);
        if (oldRequestMessage != null && oldRequestDs != null && newRequestDs != null) {
            ImsdbFieldInfoPreservationVisitor visitor = new ImsdbFieldInfoPreservationVisitor(oldRequestDs, newRequestDs);
            this.walker.accept((IMessageVisitor)visitor, oldRequestDs);
            oldRequestDs.getField();
            dataloss = visitor.warnDataLoss(oldRequestDs.getField(), newRequestDs);
            filesToClose.add(oldRequestFile);
        }
        IFile oldResponseFile = ProjectTreeFileHelper.getzCEEProgramMsgFile((String)projectName, (String)"response");
        Message oldResponseMessage = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)oldResponseFile);
        FieldType oldResponseDs = ImsdbServiceSchemaController.getFirstDataStructure(oldResponseMessage);
        FieldType newResponseDs = ImsdbServiceSchemaController.getFirstDataStructure(responseMessage);
        if (oldResponseMessage != null && oldResponseDs != null && newResponseDs != null) {
            ImsdbFieldInfoPreservationVisitor visitor = new ImsdbFieldInfoPreservationVisitor(oldResponseDs, newResponseDs);
            this.walker.accept((IMessageVisitor)visitor, oldResponseDs);
            dataloss = dataloss | visitor.warnDataLoss(((FieldType)oldResponseDs.getField().get(0)).getField(), (FieldType)newResponseDs.getField().get(0));
            filesToClose.add(oldResponseFile);
        }
        WorkspaceUtil.closeEditorIfOpen(filesToClose, (String)"com.ibm.zosconnect.editors.programinterface");
        final Boolean[] returnCode = new Boolean[]{true};
        if (dataloss.booleanValue()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(XSwt.getActiveShell(), ImsDbXlat.label("GENERATE_SERVICE_INTERFACE", new String[0]), MessageDialog.getDefaultImage(), ImsDbXlat.label("DATA_LOSS_COMFIRMATION", new String[0]), 4, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
                    returnCode[0] = dialog.open() == 0;
                }
            });
        }
        if (returnCode[0].booleanValue()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IProject project = workspaceRoot.getProject(projectName);
            IResourceRuleFactory ruleFactory = workspace.getRuleFactory();
            WorkspaceJob job = new WorkspaceJob(TAG){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        ProjectTreeFileHelper.marshallzCEEServiceInterfaceMsg((String)projectName, (Message)requestMessage, (String)"request");
                        ProjectTreeFileHelper.marshallzCEEServiceInterfaceMsg((String)projectName, (Message)responseMessage, (String)"response");
                    }
                    catch (JAXBException e) {
                        ZCeeUILogger.error((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(ruleFactory.modifyRule((IResource)project));
            job.schedule();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private static FieldType getFirstDataStructure(Message message) {
        SegmentType segment;
        FieldType dataStructure = null;
        if (message != null && message.getMessage() != null && message.getMessage().getSegment() != null && message.getMessage().getSegment().size() > 0 && (segment = (SegmentType)message.getMessage().getSegment().get(0)).getField() != null && segment.getField().size() > 0) {
            dataStructure = (FieldType)segment.getField().get(0);
        }
        return dataStructure;
    }

    private DatatypeType convertTypes(FieldType field, String imsType, int size, boolean issigned) {
        MarshallerType marshaller = new MarshallerType();
        YesnoType sign = issigned ? YesnoType.Y : YesnoType.N;
        marshaller.setIsSigned(sign);
        switch (imsType) {
            case "java.lang.String": {
                imsType = "CHAR";
                break;
            }
            case "java.lang.Long": {
                imsType = "BIGINT";
                break;
            }
            case "java.lang.Boolean": {
                imsType = "BOOLEAN";
                break;
            }
            case "java.sql.Clob": {
                imsType = "CLOB";
                break;
            }
            case "java.sql.Date": {
                imsType = "DATE";
                break;
            }
            case "java.math.BigDecimal": {
                imsType = "DECIMAL";
                break;
            }
            case "java.lang.Double": {
                imsType = "DOUBLE";
                break;
            }
            case "java.lang.Float": {
                imsType = "FLOAT";
                break;
            }
            case "java.lang.Integer": {
                imsType = "INTEGER";
                break;
            }
            case "java.lang.Short": {
                imsType = "SMALLINT";
                break;
            }
            case "java.sql.Time": {
                imsType = "TIME";
                break;
            }
            case "java.sql.Timestamp": {
                imsType = "TIMESTAMP";
                break;
            }
            case "java.lang.Byte": {
                imsType = "TINYINT";
                break;
            }
            case "java.sql.Array": {
                imsType = "ARRAY";
                break;
            }
            case "java.sql.Struct": {
                imsType = "STRUCT";
            }
        }
        switch (imsType) {
            case "TINYINT": {
                marshaller.setIsNativeInteger(YesnoType.Y);
                marshaller.setAlignment(AlignmentType.NATURAL);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(1));
                field.setMaxBytes(Integer.valueOf(1));
                return DatatypeType.BYTE;
            }
            case "INTEGER": {
                marshaller.setIsNativeInteger(YesnoType.Y);
                marshaller.setAlignment(AlignmentType.NATURAL);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(4));
                field.setMaxBytes(Integer.valueOf(4));
                return DatatypeType.INT;
            }
            case "CHAR": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.CHAR;
            }
            case "DOUBLE": {
                marshaller.setAlignment(AlignmentType.NATURAL);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(8));
                field.setMaxBytes(Integer.valueOf(8));
                return DatatypeType.DOUBLE;
            }
            case "FLOAT": {
                marshaller.setAlignment(AlignmentType.NATURAL);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(4));
                field.setMaxBytes(Integer.valueOf(4));
                return DatatypeType.FLOAT;
            }
            case "BOOLEAN": {
                marshaller.setTypeConverter(PhysicalDatatypeType.BIT);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(1));
                field.setMaxBytes(Integer.valueOf(1));
                return DatatypeType.BIT;
            }
            case "BLOB": {
                return DatatypeType.BLOB;
            }
            case "BIGINT": {
                marshaller.setIsNativeInteger(YesnoType.Y);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(8));
                field.setMaxBytes(Integer.valueOf(8));
                return DatatypeType.LONG;
            }
            case "SMALLINT": {
                marshaller.setIsNativeInteger(YesnoType.Y);
                marshaller.setAlignment(AlignmentType.NATURAL);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(2));
                field.setMaxBytes(Integer.valueOf(2));
                return DatatypeType.SHORT;
            }
            case "VARCHAR": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.CHAR;
            }
            case "PACKEDDECIMAL": {
                marshaller.setTypeConverter(PhysicalDatatypeType.PACKEDDECIMAL);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.DECIMAL;
            }
            case "ZONEDDECIMAL": {
                marshaller.setTypeConverter(PhysicalDatatypeType.ZONEDDECIMAL);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.DECIMAL;
            }
            case "DECIMAL": {
                marshaller.setIsNativeInteger(YesnoType.Y);
                marshaller.setAlignment(AlignmentType.NATURAL);
                marshaller.setTypeConverter(PhysicalDatatypeType.BINARY);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.DECIMAL;
            }
            case "DATE": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.DATE;
            }
            case "TIME": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.TIME;
            }
            case "TIMESTAMP": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.TIME;
            }
            case "TYPELIST": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.OTHER;
            }
            case "BINARY": {
                marshaller.setIsNativeInteger(YesnoType.N);
                marshaller.setAlignment(AlignmentType.NATURAL);
                marshaller.setTypeConverter(PhysicalDatatypeType.BINARY);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.BINARY;
            }
            case "SECONDARY_INDEX": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.OTHER;
            }
            case "CLOB": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.CHAR;
            }
            case "DBCS": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.CHAR;
            }
            case "XML": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                return DatatypeType.CHAR;
            }
            case "BYTE": {
                marshaller.setIsNativeInteger(YesnoType.Y);
                field.setMarshaller(marshaller);
                field.setBytes(Integer.valueOf(1));
                field.setMaxBytes(Integer.valueOf(1));
                return DatatypeType.BYTE;
            }
            case "ARRAY": {
                field.setBytes(Integer.valueOf(size));
                field.setMaxBytes(Integer.valueOf(size));
                field.setMinOccurs(Integer.valueOf(0));
                field.setMaxOccurs(Integer.valueOf(0));
                return DatatypeType.ARRAY;
            }
        }
        field.setBytes(Integer.valueOf(size));
        field.setMaxBytes(Integer.valueOf(size));
        return DatatypeType.OTHER;
    }

    public List<String> getNewNames() {
        return this.newNames;
    }
}

