/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.controllers;

import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class ImsdbFieldInfoPreservationVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FieldType existingDs;
    private final FieldType newDs;

    public ImsdbFieldInfoPreservationVisitor(FieldType existingDs, FieldType newDs) {
        this.existingDs = existingDs;
        this.newDs = newDs;
    }

    public boolean isExpandArrays() {
        return false;
    }

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field, fieldPath);
        return state;
    }

    private void doFieldInfoPreservation(FieldType field, FieldPath fieldPath) {
        FieldType matchingNewField = this.getMatchingField(field, fieldPath);
        if (matchingNewField != null) {
            this.doFieldPreservation_common(field, fieldPath, matchingNewField);
        }
    }

    private void doFieldPreservation_common(FieldType field, FieldPath fieldPath, FieldType matchingNewField) {
        matchingNewField.setName(field.getName());
        matchingNewField.setRemarks(field.getRemarks());
        matchingNewField.setDefaultValue(field.getDefaultValue());
        matchingNewField.setIncluded(field.getIncluded());
    }

    private FieldType getMatchingField(FieldType existingFld, FieldPath fieldPath) {
        FieldType retVal = null;
        Stack pathStack = fieldPath.getSegmentStack();
        if (existingFld == this.existingDs && StringUtils.equals((CharSequence)this.existingDs.getOriginalName(), (CharSequence)this.newDs.getOriginalName())) {
            return this.newDs;
        }
        int size = pathStack.size();
        if (size > 1) {
            FieldType currExistingField = this.existingDs;
            FieldType currNewField = this.newDs;
            FieldType matchingExistingChild = null;
            FieldType matchingNewChild = null;
            int i = 1;
            while (i < size - 1) {
                String currPathSeg = (String)pathStack.get(i);
                matchingExistingChild = this.getMatchingChildField(currExistingField, currPathSeg, false);
                matchingNewChild = this.getMatchingChildField(currNewField, matchingExistingChild.getOriginalName(), true);
                if (matchingNewChild == null) {
                    currNewField = null;
                    break;
                }
                currExistingField = matchingExistingChild;
                currNewField = matchingNewChild;
                matchingNewChild = null;
                ++i;
            }
            if (currNewField != null) {
                retVal = this.getMatchingChildField(currNewField, existingFld.getOriginalName(), true);
            }
        }
        return retVal;
    }

    private FieldType getMatchingChildField(FieldType parentField, String nameToMatch, boolean matchOrigName) {
        FieldType retVal = null;
        List childList = parentField.getField();
        int i = 0;
        while (i < childList.size()) {
            FieldType currField = (FieldType)childList.get(i);
            String currFieldName = null;
            currFieldName = matchOrigName ? currField.getOriginalName() : currField.getName();
            if (currFieldName.equalsIgnoreCase(nameToMatch)) {
                retVal = currField;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public Boolean warnDataLoss(List<FieldType> existingChildList, FieldType newChildList) {
        Boolean loss = false;
        int i = 0;
        while (i < existingChildList.size()) {
            if (this.getMatchingChildField(newChildList, existingChildList.get(i).getOriginalName(), true) == null) {
                loss = true;
            }
            ++i;
        }
        return loss;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType arrayParentField = fieldParents.peek();
        this.doFieldInfoPreservation(arrayParentField, fieldPath);
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field, fieldPath);
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field, fieldPath);
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public int getVariableArrayOccurrenceCount(FieldType dynArrayField) {
        int retVal = -1;
        return retVal;
    }

    public int getCountedArrayOccurrenceCount(FieldType arrayField) throws MessageWalkerException {
        return 0;
    }
}

