/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.connections.utils;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import com.ibm.cics.core.connections.internal.DisconnectedState;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.imsdb.connections.categories.IImsDbConnection;
import java.util.ArrayList;
import java.util.List;

public class ImsDbUtils {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private static IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();

    public static List<IImsDbConnection> getConnections(boolean connect) {
        ArrayList<IImsDbConnection> retVal = new ArrayList<IImsDbConnection>();
        List connectionProfiles = connectionManager.getConnectionProfiles("com.ibm.zosconnect.ui.service.imsdb.connections.type");
        for (ConnectionProfile profile : connectionProfiles) {
            IImsDbConnection connection = ImsDbUtils.getConnection(profile, connect);
            if (connection == null) continue;
            retVal.add(connection);
        }
        return retVal;
    }

    public static List<ConnectionProfile> getAllConnections() {
        List connectionProfiles = connectionManager.getConnectionProfiles("com.ibm.zosconnect.ui.service.imsdb.connections.type");
        return connectionProfiles;
    }

    public static List<IImsDbConnection> getConnections() {
        return ImsDbUtils.getConnections(false);
    }

    public static IImsDbConnection getConnection(ConnectionProfile profile, boolean connect) {
        IConnection connection;
        IImsDbConnection retVal = null;
        IConnectionState connectionState = connectionService.getConnectionState(profile);
        if (connectionState instanceof DisconnectedState && connect) {
            connectionService.connect(profile.getId());
            connectionState = connectionService.getConnectionState(profile);
        }
        if (connectionState instanceof ConnectedState && (connection = ((ConnectedState)connectionState).getConnection()) instanceof IImsDbConnection) {
            retVal = (IImsDbConnection)connection;
        }
        return retVal;
    }

    public static ConnectionProfile getDefaultConnectionProfile() {
        IConnectionService cs = ConnectionsPlugin.getDefault().getConnectionService();
        DefaultConnectionService dcs = ((ConnectionService)cs).getDefaultConnectionService();
        ConnectionRegistry cr = ConnectionRegistry.getConnectionRegistry();
        return dcs.getDefaultConnectionProfile(cr.getConnectionCategory("com.ibm.zosconnect.ui.service.imsdb.connections.category"));
    }

    public static boolean isDefaultConnectionProfile(ConnectionProfile profile) {
        IConnectionService cs = ConnectionsPlugin.getDefault().getConnectionService();
        DefaultConnectionService dcs = ((ConnectionService)cs).getDefaultConnectionService();
        return dcs.isDefault(profile);
    }

    public static void doConnect(ConnectionProfile profile, boolean async) {
        if (profile != null) {
            if (async) {
                connectionService.connectAsync(profile.getId());
            } else {
                connectionService.connect(profile.getId());
            }
        }
    }

    public static void doDisconnect(ConnectionProfile profile) {
        if (profile != null) {
            if (ConnectionUtils.supportsMultipleConnections((IConnectionDescriptor)profile.getConnectionDescriptor())) {
                ImsDbUtils.multiConnectionPreDisconnect(profile);
            }
            try {
                connectionService.disconnect(profile.getConnectionDescriptor().getCategory().getId());
            }
            catch (ConnectionException e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }
    }

    private static void multiConnectionPreDisconnect(ConnectionProfile connectionProfile) {
        IConnectionState desirableState;
        String connectionCategoryId = connectionProfile.getConnectionDescriptor().getCategory().getId();
        IConnectionState state = connectionService.getConnectionState(connectionCategoryId);
        if (!state.getID().equals(connectionProfile.getId()) && (desirableState = connectionService.getConnectionState(connectionProfile)) instanceof ConnectedState) {
            IConnection connection = ((ConnectedState)desirableState).getConnection();
            ((ConnectionService)connectionService).switchToAlreadyConnected(connection, connectionProfile);
        }
    }

    public static List<ConnectionProfile> getConnectionProfiles() {
        return connectionManager.getConnectionProfiles("com.ibm.zosconnect.ui.service.imsdb.connections.type");
    }

    public static String getServerNameWithHostAndPort(ConnectionProfile profile) {
        if (profile == null || profile.getConnectionConfiguration() == null) {
            return "";
        }
        ConnectionConfiguration config = profile.getConnectionConfiguration();
        return ImsDbUtils.getServerNameWithHostAndPort(config);
    }

    public static String getServerNameWithHostAndPort(ConnectionConfiguration config) {
        if (config == null) {
            return "";
        }
        StringBuilder serverName = new StringBuilder();
        serverName.append("\"");
        serverName.append(config.getName());
        serverName.append("\" (");
        serverName.append(config.getHost());
        serverName.append(Xlat.colon());
        serverName.append(config.getPort());
        serverName.append(")");
        return serverName.toString();
    }
}

