/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.connections.types;

import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.zosconnect.ui.common.connections.ZCeeHostnameVerifier;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.service.imsdb.connections.categories.IImsDbConnection;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ImsDbConnection
extends AbstractConnection
implements IImsDbConnection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ImsDbConnection.class.getName();
    public static final String CONNECT_TIMEOUT_KEY = "CONNECT_TIMEOUT";
    private boolean connected = false;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private ZosConnectPreferencesWrapper prefsWrapper = new ZosConnectPreferencesWrapper();

    @Override
    public Connection getConnection(String psbName, Boolean array) throws ZosConnectUIException {
        boolean isTraceOn;
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"getIMSConnection()", (Object[])new Object[0]);
        Connection imsConnection = null;
        ConnectionConfiguration configuration = this.getConfiguration();
        String hostname = configuration.getHost();
        String portnum = Integer.toString(configuration.getPort());
        String username = configuration.getUserID();
        String password = configuration.getPassword();
        int loginTimeout = NumberUtils.toInt((String)configuration.getExtendedAttribute(CONNECT_TIMEOUT_KEY), (int)30000);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(loginTimeout);
        boolean isSsl = configuration.getSecureHint();
        String arrayParms = array != false ? "flattenTables=false;expandArrayResultSet=true;" : "flattenTables=true;";
        String connectionURL = "jdbc:ims://" + hostname + ":" + portnum + "/" + psbName + ":loginTimeout=" + seconds + ";dpsbOnCommit=true;fetchSize=0;preloadUserTypeConverters=false;" + arrayParms;
        if (isSsl) {
            String sslTrustStoreLocationStr = ExplorerSecurityHelper.getCurrentTrustStore();
            String sslTrustStorePassphraseStr = ExplorerSecurityHelper.getCurrentTrustStorePassphrase();
            String sslKeyStoreLocationStr = ExplorerSecurityHelper.getCurrentKeyStore();
            String sslKeyStorePassphraseStr = ExplorerSecurityHelper.getCurrentKeyStorePassphrase();
            String sslProtocol = this.sslContext.getProtocol();
            connectionURL = connectionURL + "sslConnection=true;";
            if (sslTrustStoreLocationStr != null && !sslTrustStoreLocationStr.isEmpty()) {
                connectionURL = connectionURL + "sslTrustStoreLocation=" + sslTrustStoreLocationStr + ";";
            }
            if (sslTrustStorePassphraseStr != null && !sslTrustStorePassphraseStr.isEmpty()) {
                connectionURL = connectionURL + "sslTrustStorePassword=" + sslTrustStorePassphraseStr + ";";
            }
            if (sslKeyStoreLocationStr != null && !sslKeyStoreLocationStr.isEmpty()) {
                connectionURL = connectionURL + "sslKeyStoreLocation=" + sslKeyStoreLocationStr + ";";
            }
            if (sslKeyStorePassphraseStr != null && !sslKeyStorePassphraseStr.isEmpty()) {
                connectionURL = connectionURL + "sslKeyStorePassword=" + sslKeyStorePassphraseStr + ";";
            }
            if (sslProtocol != null && !sslProtocol.isEmpty()) {
                connectionURL = connectionURL + "sslSecureSocketProtocol=" + sslProtocol + ";";
            }
        }
        if (isTraceOn = this.prefsWrapper.getVerboseLogging()) {
            String connId = configuration.getName();
            connId = connId.replace(':', '-');
            String traceFileName = "IMS_JDBC_trace_" + connId + ".txt";
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IPath metadataPath = workspaceRoot.getRawLocation().append(".metadata");
            String metadataFolderStr = metadataPath.toOSString();
            connectionURL = connectionURL + "traceFile=" + traceFileName + ";traceFileAppend=false;traceLevel=-1;traceDirectory=" + metadataFolderStr + ";";
        }
        try {
            imsConnection = DriverManager.getConnection(connectionURL, username, password);
        }
        catch (SQLException e) {
            throw new ZosConnectUIException((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"getIMSConnection()", (Object[])new Object[0]);
        return imsConnection;
    }

    private void checkConnectionCertChain() throws ZosConnectUIException {
        ZCeeUILogger.entering((String)TAG, (String)"checkCert", (Object[])new Object[0]);
        ConnectionConfiguration configuration = this.getConfiguration();
        try {
            this.initSSLConfiguration();
            URL url = null;
            url = new URL("https://" + configuration.getHost() + ":" + configuration.getPort());
            HttpsURLConnection urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setSSLSocketFactory(this.sslSocketFactory);
            urlConn.setHostnameVerifier((HostnameVerifier)new ZCeeHostnameVerifier());
            Integer connectTimeout = NumberUtils.toInt((String)configuration.getExtendedAttribute(CONNECT_TIMEOUT_KEY), (int)30000);
            urlConn.setConnectTimeout(connectTimeout);
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.setRequestProperty("Accept", "application/json");
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("GET");
            urlConn.connect();
            urlConn.disconnect();
        }
        catch (IOException ioe) {
            throw new ZosConnectUIException((Throwable)ioe);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"checkCert", (Object[])new Object[0]);
    }

    public void connect() throws ConnectionException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"connect()", (Object[])new Object[0]);
        ConnectionConfiguration cc = this.getConfiguration();
        boolean isSsl = cc.getSecureHint();
        if (isSsl) {
            try {
                this.checkConnectionCertChain();
            }
            catch (Throwable e) {
                throw new ConnectionException(e.getMessage(), e);
            }
        }
        try {
            Class.forName("com.ibm.ims.jdbc.IMSDriver");
            try {
                this.connected = false;
                this.initSSLConfiguration();
                Connection imsConnection = this.getConnection("DFSCP000", false);
                if (imsConnection != null) {
                    imsConnection.close();
                }
                this.connected = true;
            }
            catch (ZosConnectUIException e) {
                ZCeeUILogger.error((Throwable)e);
                if (HttpStatusCodes.Unauthorized.equals(e.getHttpStatusCode())) {
                    ZCeeErrorDialog.openError((Exception)((Object)e));
                    throw new AuthenticationException(e.getExternalMessage());
                }
                ZCeeErrorDialog.openError((Exception)((Object)e), (boolean)true);
                throw new ConnectionException(e.getExternalMessage());
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                ZCeeErrorDialog.openError((Exception)e, (boolean)true);
                throw new ConnectionException(e);
            }
        }
        catch (ClassNotFoundException e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"connect()", (Object[])new Object[0]);
    }

    public void disconnect() throws ConnectionException {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"disconnect()", (Object[])new Object[0]);
        this.connected = false;
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"disconnect()", (Object[])new Object[0]);
    }

    public boolean isConnected() {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"isConnected()", (Object[])new Object[0]);
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"isConnected()", (Object[])new Object[0]);
        return this.connected;
    }

    public void initSSLConfiguration() throws IOException {
        ZCeeUILogger.entering((String)TAG, (String)"initSSLConfiguration()", (Object[])new Object[0]);
        boolean enableExtraTLSProtocols = false;
        if (this.isClientCert()) {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
        } else {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
        }
        ZCeeUILogger.info((String)"protocol={0},enableExtraTLSProtocols={1}", (Object[])new Object[]{this.sslContext.getProtocol(), enableExtraTLSProtocols});
        ZCeeUILogger.exiting((String)TAG, (String)"initSSLConfiguration()", (Object[])new Object[0]);
    }

    public boolean isClientCert() {
        return this.getConfiguration().getCertificateDetails() != null;
    }

    @Override
    public String getName() {
        return this.getConfiguration().getName();
    }

    @Override
    public void setConnected(boolean b) {
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"setConnected()", (Object[])new Object[0]);
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"setConnected()", (Object[])new Object[0]);
        this.connected = b;
    }
}

