/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb.connections.customizers;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.AbstractConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImsDbCustomizer
extends AbstractConnectionCustomizer
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionConfiguration configuration;
    private ZosConnectPreferencesWrapper prefWrapper = new ZosConnectPreferencesWrapper();
    private Text connectTimeout = null;
    private FieldDecorationRegistry decorationRegistry = FieldDecorationRegistry.getDefault();
    private FieldDecoration errorFieldDecoration = this.decorationRegistry.getFieldDecoration("DEC_ERROR");
    private ControlDecoration connectTimeoutDecoration;
    private Integer connectionTimeoutValue = 0;

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.configuration = connectionConfiguration;
        String connectTimeoutVal = connectionConfiguration.getExtendedAttribute("CONNECT_TIMEOUT");
        if (!StringUtils.isBlank((CharSequence)connectTimeoutVal)) {
            XSwt.setText((Text)this.connectTimeout, (String)connectTimeoutVal);
        }
    }

    public void createControl(Composite parent) {
        String connectionTimeoutAttVal;
        Composite body = new Composite(parent, 0);
        this.setGridLayout(body, 3, 5, 0, true, false);
        this.connectionTimeoutValue = this.configuration != null ? (StringUtils.isNumeric((CharSequence)(connectionTimeoutAttVal = this.configuration.getExtendedAttribute("CONNECT_TIMEOUT"))) ? Integer.valueOf(connectionTimeoutAttVal) : Integer.valueOf(this.prefWrapper.getConnectTimeout())) : Integer.valueOf(this.prefWrapper.getConnectTimeout());
        this.connectTimeout = this.createText(body, Xlat.label((String)"CONNECT_TIMEOUT") + Xlat.colon(), Xlat.description((String)"CONNECT_TIMEOUT"), Xlat.label((String)"UNIT_MILLISECONDS"), this.connectionTimeoutValue.toString(), this, this.decorationRegistry.getMaximumDecorationWidth(), 150);
        this.connectTimeoutDecoration = new ControlDecoration((Control)this.connectTimeout, 16512);
        this.connectTimeoutDecoration.setImage(this.errorFieldDecoration.getImage());
        this.connectTimeoutDecoration.hide();
    }

    public void clear() {
        XSwt.setText((Text)this.connectTimeout, (String)String.valueOf(this.prefWrapper.getConnectTimeout()));
    }

    public void performDefaults() {
        XSwt.setText((Text)this.connectTimeout, (String)String.valueOf(this.prefWrapper.getConnectTimeout()));
    }

    public void updateCurrentConfiguration() {
        if (this.configuration == null) {
            return;
        }
        this.configuration.setExtendedAttribute("CONNECT_TIMEOUT", XSwt.getText((Text)this.connectTimeout));
    }

    public void modifyText(ModifyEvent event) {
        Object source = event.getSource();
        if (source == this.connectTimeout) {
            for (IConnectionCustomizerListener listener : this.getListeners()) {
                listener.propertyChanged("CONNECT_TIMEOUT", (Object)XSwt.getText((Text)this.connectTimeout));
            }
        }
    }

    public String validateEnteredData() {
        String message = null;
        this.connectTimeoutDecoration.setDescriptionText("");
        this.connectTimeoutDecoration.hide();
        if (StringUtils.isBlank(message) && !XSwt.isDisposed((Control)this.connectTimeout)) {
            try {
                this.connectionTimeoutValue = Integer.valueOf(this.connectTimeout.getText());
                if (this.connectionTimeoutValue < 0) {
                    message = Xlat.error((String)"INVALID_CONNECT_TIMEOUT_VALUE");
                    this.connectTimeoutDecoration.setDescriptionText(message);
                    this.connectTimeoutDecoration.show();
                }
            }
            catch (NumberFormatException numberFormatException) {
                message = Xlat.error((String)"INVALID_CONNECT_TIMEOUT_VALUE");
                this.connectTimeoutDecoration.setDescriptionText(message);
                this.connectTimeoutDecoration.show();
            }
        }
        return message;
    }

    private Text createText(Composite parent, String leadingLabel, String tooltip, String trailingLabel, String initialValue, ModifyListener modifyListener, int horizontalIndent, int widthHint) {
        Label label1 = new Label(parent, 0);
        label1.setText(leadingLabel);
        Text text = new Text(parent, 2052);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = widthHint;
        gridData.horizontalIndent = horizontalIndent;
        text.setToolTipText(tooltip);
        if (trailingLabel != null && !trailingLabel.isEmpty()) {
            Label label2 = new Label(parent, 0);
            label2.setText(trailingLabel);
        }
        text.setLayoutData((Object)gridData);
        if (modifyListener != null) {
            text.addModifyListener(modifyListener);
        }
        return text;
    }

    private void setGridLayout(Composite composite, Integer numColumns, Integer marginHeight, Integer marginWidth, Boolean grabExcessVerticalSpace, Boolean expandHorizontal) {
        GridLayout layout = new GridLayout();
        if (numColumns != null) {
            layout.numColumns = numColumns;
        }
        if (marginHeight != null) {
            layout.marginHeight = marginHeight;
        }
        if (marginWidth != null) {
            layout.marginWidth = marginWidth;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        if (expandHorizontal.booleanValue()) {
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
        }
        if (grabExcessVerticalSpace != null) {
            data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        }
        composite.setLayoutData((Object)data);
    }
}

