/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.imsdb;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceCapabilitiesValidator;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public class ImsDbCapabilitiesValidator
implements IServiceCapabilitiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public final String className = this.getClass().getName();
    public static final String VALIDATOR_ID = "ibm.services.imsdb.";

    public ArrayList<String> getExploitedCapabilityList(IProject project) {
        ZCeeUILogger.entering((String)this.className, (String)"getExploitedCapabilityList", (Object[])new Object[]{project});
        ArrayList<String> usedCapabilities = new ArrayList<String>();
        try {
            ServiceProjectController serviceProjectController = new ServiceProjectController(project);
            ServiceModelController serviceModelController = serviceProjectController.getServiceModel();
            String serviceType = serviceModelController.getValue("servicetype");
            if (serviceType.equals("imsDatabase") && this.usingArraySupport(serviceModelController)) {
                usedCapabilities.add("ibm.services.imsdb.arraySupport");
            }
        }
        catch (Exception e) {
            EclipseLogger.logError((Throwable)e);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"getExploitedCapabilityList", (Object[])new Object[]{usedCapabilities});
        return usedCapabilities;
    }

    private boolean usingArraySupport(ServiceModelController serviceModelController) {
        String value = serviceModelController.getValue("arraySupport");
        return value != null && value.contentEquals("true");
    }
}

