/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.lang.common.ui;

import com.ibm.etools.lang.common.ui.GridUtil;
import com.ibm.etools.lang.common.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class SystemLibraryTable
extends Composite
implements SelectionListener {
    private Button addBtn;
    private Button editBtn;
    private Button removeBtn;
    private Button upBtn;
    private Button downBtn;
    public TableViewer tableViewer;
    private Collection tableElements = new ArrayList();
    private final String[] COLUMNS = new String[]{"STRING"};

    protected abstract String getSystemLibraryLocation();

    public SystemLibraryTable(Composite parent) {
        super(parent, 0);
        this.createLibraryTable(parent);
    }

    public SystemLibraryTable(Composite parent, Collection tableElements) {
        this(parent);
        this.tableElements = tableElements;
    }

    private void createLibraryTable(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(GridUtil.createFill());
        this.createLibraryTableViewer(this);
        Composite btnGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 15;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createVerticalFill());
        this.editBtn = new Button(btnGroup, 8);
        this.editBtn.setText(Messages.SystemLibraryTable_Button_Edit);
        this.editBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.editBtn.setEnabled(false);
        this.addBtn = new Button(btnGroup, 8);
        this.addBtn.setText(Messages.SystemLibraryTable_Button_Add);
        this.addBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.addBtn.setEnabled(true);
        this.removeBtn = new Button(btnGroup, 8);
        this.removeBtn.setText(Messages.SystemLibraryTable_Button_Remove);
        this.removeBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.removeBtn.setEnabled(false);
        this.upBtn = new Button(btnGroup, 8);
        this.upBtn.setText(Messages.SystemLibraryTable_Button_MoveUp);
        this.upBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.upBtn.setEnabled(false);
        this.downBtn = new Button(btnGroup, 8);
        this.downBtn.setText(Messages.SystemLibraryTable_Button_MoveDown);
        this.downBtn.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.downBtn.setEnabled(false);
        this.editBtn.addSelectionListener((SelectionListener)this);
        this.addBtn.addSelectionListener((SelectionListener)this);
        this.removeBtn.addSelectionListener((SelectionListener)this);
        this.upBtn.addSelectionListener((SelectionListener)this);
        this.downBtn.addSelectionListener((SelectionListener)this);
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
        this.tableViewer.setInput((Object)this.tableElements);
    }

    private void createLibraryTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridUtil.createFill();
        data.heightHint = 50;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[1];
        TableColumn stringColumn = new TableColumn(table, 16384);
        stringColumn.setText(Messages.SystemLibraryTable_Table_Column_Location);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        cellEditors[0] = new TextCellEditor((Composite)table);
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(this.COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new PreferenceCellModifier((Viewer)this.tableViewer));
        this.tableViewer.setCellEditors(cellEditors);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.tableViewer.getTable()) {
            this.enableButtons();
        } else if (source == this.addBtn) {
            this.performAdd();
        } else if (source == this.editBtn) {
            this.performEdit();
        } else if (source == this.removeBtn) {
            this.performRemove();
        } else if (source == this.upBtn) {
            this.performMoveUp();
        } else if (source == this.downBtn) {
            this.performMoveDown();
        }
    }

    private void performMoveUp() {
        int idx = this.tableViewer.getTable().getSelectionIndex();
        LibraryTableElement sel = (LibraryTableElement)this.tableViewer.getElementAt(idx);
        String selectionItemlocation = sel.getText();
        this.tableViewer.remove((Object)sel);
        LibraryTableElement libraryTableElement = new LibraryTableElement(selectionItemlocation);
        this.tableViewer.insert((Object)libraryTableElement, idx - 1);
        this.tableViewer.getTable().select(idx - 1);
        this.enableButtons();
    }

    private void performMoveDown() {
        int idx = this.tableViewer.getTable().getSelectionIndex();
        LibraryTableElement sel = (LibraryTableElement)this.tableViewer.getElementAt(idx);
        String selectionItemlocation = sel.getText();
        this.tableViewer.remove((Object)sel);
        LibraryTableElement libraryTableElement = new LibraryTableElement(selectionItemlocation);
        this.tableViewer.insert((Object)libraryTableElement, idx + 1);
        this.tableViewer.getTable().select(idx + 1);
        this.enableButtons();
    }

    private void performRemove() {
        int idx = this.tableViewer.getTable().getSelectionIndex();
        if (idx != -1) {
            LibraryTableElement sel = (LibraryTableElement)this.tableViewer.getElementAt(idx);
            this.tableViewer.remove((Object)sel);
        }
        if (this.tableViewer.getElementAt(idx) != null) {
            this.tableViewer.getTable().select(idx);
        }
        this.enableButtons();
    }

    private void performEdit() {
        int idx = this.tableViewer.getTable().getSelectionIndex();
        if (idx != -1) {
            LibraryTableElement sel = (LibraryTableElement)this.tableViewer.getElementAt(idx);
            this.showEditDialog(Messages.SystemLibraryTable_Button_EditLocation, sel.getText());
        }
        this.enableButtons();
    }

    private void performAdd() {
        String text = this.getSystemLibraryLocation();
        LibraryTableElement entry = null;
        if (text != null && text.trim() != "") {
            entry = new LibraryTableElement(text);
            this.tableViewer.add((Object)entry);
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)entry), true);
            this.enableButtons();
        }
    }

    public Collection getTableList() {
        ArrayList<String> list = new ArrayList<String>();
        int totalCount = this.tableViewer.getTable().getItems().length;
        int i = 0;
        while (i < totalCount) {
            list.add(((LibraryTableElement)this.tableViewer.getElementAt(i)).getText());
            ++i;
        }
        return list;
    }

    public void setTableInput(Collection list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.tableElements.add(new LibraryTableElement((String)iter.next()));
        }
        this.tableViewer.refresh();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void enableButtons() {
        int idx = this.tableViewer.getTable().getSelectionIndex();
        boolean enable = this.tableViewer.getTable().getItemCount() > 0 && idx != -1;
        this.editBtn.setEnabled(enable);
        this.removeBtn.setEnabled(enable);
        if (enable) {
            int totalcount = this.tableViewer.getTable().getItems().length;
            if (idx == 0) {
                this.upBtn.setEnabled(false);
            } else {
                this.upBtn.setEnabled(true);
            }
            if (idx == totalcount - 1) {
                this.downBtn.setEnabled(false);
            } else {
                this.downBtn.setEnabled(true);
            }
        } else {
            this.upBtn.setEnabled(enable);
            this.downBtn.setEnabled(enable);
        }
    }

    private void showEditDialog(String title, String location) {
        int idx;
        EditDialog dialog = new EditDialog(this.getShell(), title, location);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (idx = this.tableViewer.getTable().getSelectionIndex()) != -1) {
            LibraryTableElement tableElem = (LibraryTableElement)this.tableViewer.getElementAt(idx);
            tableElem.setText(dialog.getLocation());
            this.tableViewer.update((Object)tableElem, null);
        }
    }

    private class EditDialog
    extends Dialog
    implements SelectionListener {
        private String _location;
        private String _title;
        private Text locationText;
        private Button browseBtn;

        public EditDialog(Shell shell, String title, String location) {
            super(shell);
            this._location = location;
            this._title = title;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this._title);
        }

        public void setLocation(String location) {
            this._location = location;
        }

        public String getLocation() {
            return this._location;
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 400;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 0);
            label.setText(Messages.SystemLibraryTable_Label_Location);
            this.locationText = new Text(result, 2048);
            this.locationText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.browseBtn = new Button(result, 8);
            this.browseBtn.setText(Messages.SystemLibraryTable_Button_Browse);
            this.browseBtn.setEnabled(true);
            this.browseBtn.addSelectionListener((SelectionListener)this);
            if (this._location != null) {
                this.locationText.setText(this._location);
            }
            return result;
        }

        protected void okPressed() {
            if (this.locationText.getText().trim() != "") {
                this._location = this.locationText.getText().trim();
            }
            super.okPressed();
        }

        public void widgetSelected(SelectionEvent e) {
            String text;
            Object source = e.getSource();
            if (source == this.browseBtn && (text = SystemLibraryTable.this.getSystemLibraryLocation()) != null && text.trim() != "") {
                this.locationText.setText(text);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class LibraryTableElement {
        private String text;

        public LibraryTableElement(String text) {
            this.setText(text);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    private class PreferenceCellModifier
    implements ICellModifier {
        private Viewer viewer;

        public PreferenceCellModifier(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof LibraryTableElement && property.equals(SystemLibraryTable.this.COLUMNS[0])) {
                return false;
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof LibraryTableElement) {
                LibraryTableElement libraryTableElement = (LibraryTableElement)element;
                if (property.equals(SystemLibraryTable.this.COLUMNS[0])) {
                    return libraryTableElement.getText();
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object myElement;
            if (element instanceof TableItem && (myElement = ((TableItem)element).getData()) instanceof LibraryTableElement) {
                LibraryTableElement libraryTableElement = (LibraryTableElement)myElement;
                if (property.equals(SystemLibraryTable.this.COLUMNS[0])) {
                    libraryTableElement.setText((String)value);
                }
                this.viewer.refresh();
            }
        }
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object element) {
            return SystemLibraryTable.this.tableElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof LibraryTableElement) {
                LibraryTableElement libraryTableElement = (LibraryTableElement)element;
                if (columnIndex == 0) {
                    return libraryTableElement.getText();
                }
            }
            return "";
        }
    }
}

